/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.interception.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import weblogic.messaging.interception.exceptions.InterceptionServiceException;
import weblogic.messaging.interception.interfaces.AssociationInfo;
import weblogic.messaging.interception.interfaces.Processor;
import weblogic.messaging.interception.interfaces.ProcessorHandle;
import weblogic.messaging.interception.internal.Association;
import weblogic.messaging.interception.internal.ProcessorHandleImpl;
import weblogic.messaging.interception.internal.ProcessorTypeWrapper;

public class ProcessorWrapper {
    private String type = null;
    private String name = null;
    private Processor p = null;
    private HashMap associationsMap = new HashMap(0);
    private long registrationTime = 0L;
    private ProcessorHandle pHandle = null;
    private boolean forcedShutdown = false;
    private ProcessorTypeWrapper ptw = null;

    ProcessorWrapper(String string, String string2, ProcessorTypeWrapper processorTypeWrapper) {
        this.type = string;
        this.name = string2;
        this.ptw = processorTypeWrapper;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    synchronized void setProcessorHandle(ProcessorHandle processorHandle) {
        this.pHandle = processorHandle;
    }

    synchronized ProcessorHandle getProcessorHandle() {
        return this.pHandle;
    }

    synchronized long getRegistrationTime() {
        return this.registrationTime;
    }

    synchronized Processor getProcessor() {
        return this.p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InterceptionServiceException addProcessor(Processor processor) {
        int n;
        InterceptionServiceException interceptionServiceException = null;
        ProcessorWrapper processorWrapper = this;
        synchronized (processorWrapper) {
            this.p = processor;
            this.registrationTime = System.currentTimeMillis();
            n = this.associationsMap.size();
            this.forcedShutdown = false;
        }
        if (n > 0) {
            interceptionServiceException = ProcessorWrapper.updateState(processor, true);
        }
        if (interceptionServiceException != null) {
            processorWrapper = this;
            synchronized (processorWrapper) {
                if (processor == this.p) {
                    this.p = null;
                    this.registrationTime = 0L;
                    this.forcedShutdown = true;
                }
            }
        }
        return interceptionServiceException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InterceptionServiceException removeProcessor(ProcessorHandle processorHandle) {
        Processor processor = null;
        ProcessorWrapper processorWrapper = this;
        synchronized (processorWrapper) {
            if (processorHandle != null && this.pHandle != processorHandle) {
                return new InterceptionServiceException("Processor has been removed");
            }
            processor = this.getProcessor();
        }
        if (processor == null) {
            return new InterceptionServiceException("Processor has been removed");
        }
        InterceptionServiceException interceptionServiceException = this.removeProcessor(processor, false);
        return interceptionServiceException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InterceptionServiceException removeProcessor(Processor processor, boolean bl) {
        InterceptionServiceException interceptionServiceException = null;
        ProcessorHandle processorHandle = null;
        ProcessorWrapper processorWrapper = this;
        synchronized (processorWrapper) {
            if (processor == this.p) {
                this.p = null;
                this.registrationTime = 0L;
                processorHandle = this.pHandle;
                this.pHandle = null;
                this.forcedShutdown = bl;
            }
        }
        if (processorHandle != null) {
            ((ProcessorHandleImpl)processorHandle).removeProcessorWrapper();
        }
        interceptionServiceException = ProcessorWrapper.shutdownProcessor(processor);
        return interceptionServiceException;
    }

    private static InterceptionServiceException shutdownProcessor(Processor processor) {
        Throwable throwable = null;
        try {
            processor.onShutdown();
        }
        catch (RuntimeException runtimeException) {
            throwable = runtimeException;
        }
        catch (Error error) {
            throwable = error;
        }
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof Error) {
            return new InterceptionServiceException("Processor throws illegal error", throwable);
        }
        return new InterceptionServiceException("Processor throws illegal runtime exception", throwable);
    }

    private static InterceptionServiceException updateState(Processor processor, boolean bl) {
        InterceptionServiceException interceptionServiceException = null;
        Throwable throwable = null;
        try {
            processor.associationStateChange(bl);
        }
        catch (RuntimeException runtimeException) {
            throwable = runtimeException;
            interceptionServiceException = ProcessorWrapper.shutdownProcessor(processor);
        }
        catch (Error error) {
            throwable = error;
            interceptionServiceException = ProcessorWrapper.shutdownProcessor(processor);
        }
        if (interceptionServiceException != null) {
            return interceptionServiceException;
        }
        if (throwable != null) {
            if (throwable instanceof Error) {
                return new InterceptionServiceException("Processor throws illegal error", throwable);
            }
            return new InterceptionServiceException("Processor throws illegal runtime exception", throwable);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAssociation(Association association) throws InterceptionServiceException {
        Processor processor;
        int n;
        Object object = this;
        synchronized (object) {
            this.associationsMap.put(association.getInternalName(), association);
            n = this.associationsMap.size();
            processor = this.p;
        }
        if (n == 1 && processor != null && (object = ProcessorWrapper.updateState(processor, true)) != null) {
            ProcessorWrapper processorWrapper = this;
            synchronized (processorWrapper) {
                if (processor == this.p) {
                    this.p = null;
                    this.registrationTime = 0L;
                    this.forcedShutdown = true;
                }
            }
            throw object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeProcessorWrapperIfNotUsed() {
        ProcessorTypeWrapper processorTypeWrapper = this.ptw;
        synchronized (processorTypeWrapper) {
            ProcessorWrapper processorWrapper = this;
            synchronized (processorWrapper) {
                if (this.pHandle != null || this.p != null || this.associationsMap.size() > 0) {
                    return;
                }
                this.ptw.removeProcessorWrapper(this.name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAssociation(Association association) throws InterceptionServiceException {
        int n;
        Processor processor;
        Object object = this;
        synchronized (object) {
            processor = this.p;
            this.associationsMap.remove(association.getInternalName());
            n = this.associationsMap.size();
        }
        if (n == 0 && processor != null && (object = ProcessorWrapper.updateState(processor, false)) != null) {
            ProcessorWrapper processorWrapper = this;
            synchronized (processorWrapper) {
                if (processor == this.p) {
                    this.p = null;
                    this.registrationTime = 0L;
                    this.forcedShutdown = true;
                }
            }
            throw object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Iterator getAssociationInfos() {
        HashMap hashMap = null;
        Object[] objectArray = this;
        synchronized (this) {
            hashMap = (HashMap)this.associationsMap.clone();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            objectArray = hashMap.values().toArray();
            LinkedList<AssociationInfo> linkedList = new LinkedList<AssociationInfo>();
            for (int i = 0; i < objectArray.length; ++i) {
                linkedList.add(((Association)objectArray[i]).getInfoInternal());
            }
            return linkedList.listIterator();
        }
    }

    synchronized boolean forcedShutdown() {
        return this.forcedShutdown;
    }
}

