/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.interception.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.extensions.WLMessageProducer;

public class JMSHelper {
    public static final void Send(WLMessageProducer wLMessageProducer, Message message) throws JMSException {
        JMSHelper.SendInternal(wLMessageProducer, null, message);
    }

    public static final void Send(WLMessageProducer wLMessageProducer, Destination destination, Message message) throws JMSException {
        JMSHelper.SendInternal(wLMessageProducer, destination, message);
    }

    public static final void Send(WLMessageProducer wLMessageProducer, Message message, int n, int n2, long l) throws JMSException {
        JMSHelper.SendInternal(wLMessageProducer, null, message, n, n2, l);
    }

    public static final void Send(WLMessageProducer wLMessageProducer, Destination destination, Message message, int n, int n2, long l) throws JMSException {
        JMSHelper.SendInternal(wLMessageProducer, destination, message, n, n2, l);
    }

    public static final void SendFromMessage(WLMessageProducer wLMessageProducer, Message message) throws JMSException {
        JMSHelper.SendInternal(wLMessageProducer, null, message, message.getJMSDeliveryMode(), message.getJMSPriority(), JMSHelper.getRelativeTimeToLive(message));
    }

    public static final void SendFromMessage(WLMessageProducer wLMessageProducer, Destination destination, Message message) throws JMSException {
        JMSHelper.SendInternal(wLMessageProducer, destination, message, message.getJMSDeliveryMode(), message.getJMSPriority(), JMSHelper.getRelativeTimeToLive(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void SendInternal(WLMessageProducer wLMessageProducer, Destination destination, Message message) throws JMSException {
        CopiedMessage copiedMessage = null;
        try {
            copiedMessage = new CopiedMessage(message);
            if (destination == null) {
                wLMessageProducer.send(message);
            } else {
                wLMessageProducer.send(destination, message);
            }
        }
        finally {
            if (copiedMessage != null) {
                copiedMessage.restoreMessage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void SendInternal(WLMessageProducer wLMessageProducer, Destination destination, Message message, int n, int n2, long l) throws JMSException {
        CopiedMessage copiedMessage = null;
        try {
            copiedMessage = new CopiedMessage(message);
            if (destination == null) {
                wLMessageProducer.send(message, n, n2, l);
            } else {
                wLMessageProducer.send(destination, message, n, n2, l);
            }
        }
        finally {
            if (copiedMessage != null) {
                copiedMessage.restoreMessage();
            }
        }
    }

    public static final void Forward(WLMessageProducer wLMessageProducer, Message message) throws JMSException {
        JMSHelper.ForwardInternal(wLMessageProducer, null, message, false);
    }

    public static final void Forward(WLMessageProducer wLMessageProducer, Destination destination, Message message) throws JMSException {
        JMSHelper.ForwardInternal(wLMessageProducer, destination, message, false);
    }

    public static final void Forward(WLMessageProducer wLMessageProducer, Message message, int n, int n2, long l) throws JMSException {
        JMSHelper.ForwardInternal(wLMessageProducer, null, message, n, n2, l, false);
    }

    public static final void Forward(WLMessageProducer wLMessageProducer, Destination destination, Message message, int n, int n2, long l) throws JMSException {
        JMSHelper.ForwardInternal(wLMessageProducer, destination, message, n, n2, l, false);
    }

    public static final void ForwardFromMessage(WLMessageProducer wLMessageProducer, Message message) throws JMSException {
        JMSHelper.ForwardInternal(wLMessageProducer, null, message, message.getJMSDeliveryMode(), message.getJMSPriority(), JMSHelper.getRelativeTimeToLive(message), true);
    }

    public static final void ForwardFromMessage(WLMessageProducer wLMessageProducer, Destination destination, Message message) throws JMSException {
        JMSHelper.ForwardInternal(wLMessageProducer, destination, message, message.getJMSDeliveryMode(), message.getJMSPriority(), JMSHelper.getRelativeTimeToLive(message), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void ForwardInternal(WLMessageProducer wLMessageProducer, Destination destination, Message message, boolean bl) throws JMSException {
        CopiedMessage copiedMessage = null;
        try {
            copiedMessage = bl ? new CopiedMessage(wLMessageProducer, message) : new CopiedMessage(message);
            if (destination == null) {
                wLMessageProducer.forward(message);
            } else {
                wLMessageProducer.forward(destination, message);
            }
        }
        finally {
            if (copiedMessage != null) {
                copiedMessage.restoreMessage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void ForwardInternal(WLMessageProducer wLMessageProducer, Destination destination, Message message, int n, int n2, long l, boolean bl) throws JMSException {
        CopiedMessage copiedMessage = null;
        try {
            copiedMessage = bl ? new CopiedMessage(wLMessageProducer, message) : new CopiedMessage(message);
            if (destination == null) {
                wLMessageProducer.forward(message, n, n2, l);
            } else {
                wLMessageProducer.forward(destination, message, n, n2, l);
            }
        }
        finally {
            if (copiedMessage != null) {
                copiedMessage.restoreMessage();
            }
        }
    }

    public static long getRelativeTimeToLive(Message message) throws JMSException {
        long l = message.getJMSExpiration();
        l = l != 0L ? (l < 0L ? (Long.MAX_VALUE + l <= System.currentTimeMillis() ? Long.MIN_VALUE : (l -= System.currentTimeMillis())) : (l -= System.currentTimeMillis())) : 0L;
        return l;
    }

    public static final void ForwardPreserveMsgProperty(WLMessageProducer wLMessageProducer, Message message) throws JMSException {
        wLMessageProducer.setUnitOfOrder(message.getStringProperty("JMS_BEA_UnitOfOrder"));
        wLMessageProducer.setRedeliveryLimit(message.getIntProperty("JMS_BEA_RedeliveryLimit"));
        wLMessageProducer.forward(message, message.getJMSDeliveryMode(), message.getJMSPriority(), JMSHelper.getRelativeTimeToLive(message));
    }

    private static class CopiedMessage {
        private long absoluteExpirationTime;
        private long absoluteTimeToDeliver;
        private Destination destination;
        private int deliveryMode;
        private boolean redelivered;
        private int priority;
        private int redeliveryLimit;
        private JMSID connectionId;
        private JMSMessageId msgId;
        private boolean ddforwarded;
        private String unitOfOrderName;
        private boolean forwardFlag;
        private MessageImpl message;
        private WLMessageProducer producer;
        private String unitOfOrderName_p;
        private long timeToDelivery_p;
        private int redeliveryLimit_p;

        CopiedMessage(WLMessageProducer wLMessageProducer, Message message) throws JMSException {
            this(message);
            this.producer = wLMessageProducer;
            this.unitOfOrderName_p = wLMessageProducer.getUnitOfOrder();
            this.timeToDelivery_p = wLMessageProducer.getTimeToDeliver();
            this.redeliveryLimit_p = wLMessageProducer.getRedeliveryLimit();
            wLMessageProducer.setUnitOfOrder(this.unitOfOrderName);
            wLMessageProducer.setRedeliveryLimit(this.redeliveryLimit);
            if (this.absoluteTimeToDeliver > 0L && this.absoluteTimeToDeliver > System.currentTimeMillis()) {
                wLMessageProducer.setTimeToDeliver(this.absoluteTimeToDeliver - System.currentTimeMillis());
            } else {
                wLMessageProducer.setTimeToDeliver(0L);
            }
        }

        CopiedMessage(Message message) throws JMSException {
            this.message = (MessageImpl)message;
            this.absoluteExpirationTime = this.message.getJMSExpiration();
            this.absoluteTimeToDeliver = this.message.getJMSDeliveryTime();
            this.destination = this.message.getJMSDestination();
            this.deliveryMode = this.message.getJMSDeliveryMode();
            this.redelivered = this.message.getJMSRedelivered();
            this.priority = this.message.getJMSPriority();
            this.redeliveryLimit = this.message.getJMSRedeliveryLimit();
            this.connectionId = this.message.getConnectionId();
            this.msgId = this.message.getId();
            this.ddforwarded = this.message.getDDForwarded();
            this.unitOfOrderName = this.message.getUnitOfOrder();
            this.forwardFlag = this.message.isForwardable();
        }

        void restoreMessage() throws JMSException {
            this.message.setJMSExpiration(this.absoluteExpirationTime);
            this.message.setJMSDeliveryTime(this.absoluteTimeToDeliver);
            this.message.setJMSDestination(this.destination);
            this.message.setJMSDeliveryMode(this.deliveryMode);
            this.message.setJMSRedelivered(this.redelivered);
            this.message.setJMSPriority(this.priority);
            this.message.setJMSRedeliveryLimit(this.redeliveryLimit);
            this.message.setConnectionId(this.connectionId);
            this.message.setId(this.msgId);
            this.message.setDDForwarded(this.ddforwarded);
            this.message.setUnitOfOrderName(this.unitOfOrderName);
            this.message.setForward(this.forwardFlag);
            if (this.producer != null) {
                this.producer.setUnitOfOrder(this.unitOfOrderName_p);
                this.producer.setTimeToDeliver(this.timeToDelivery_p);
                this.producer.setRedeliveryLimit(this.redeliveryLimit_p);
            }
        }
    }
}

