/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.interception.module;

import java.io.File;
import weblogic.application.Deployment;
import weblogic.application.Module;
import weblogic.application.internal.SingleModuleDeployment;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.messaging.interception.module.InterceptionModule;

public final class InterceptionDeployment
extends SingleModuleDeployment
implements Deployment {
    public InterceptionDeployment(AppDeploymentMBean appDeploymentMBean, File file) throws DeploymentException {
        super(appDeploymentMBean, InterceptionDeployment.createModule(appDeploymentMBean), file);
    }

    private static Module createModule(AppDeploymentMBean appDeploymentMBean) throws DeploymentException {
        ComponentMBean[] componentMBeanArray = appDeploymentMBean.getAppMBean().getComponents();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Components: ");
        for (int i = 0; i < componentMBeanArray.length; ++i) {
            stringBuffer.append(componentMBeanArray[i].getName());
            if (i >= componentMBeanArray.length - 1) continue;
            stringBuffer.append(",");
        }
        if (componentMBeanArray == null || componentMBeanArray.length == 0) {
            throw new DeploymentException("Application " + appDeploymentMBean.getName() + " does not have any Components in it.");
        }
        if (componentMBeanArray.length > 1) {
            throw new DeploymentException("Application" + appDeploymentMBean.getName() + " is a MAR file, but it contains > 1 component.");
        }
        return new InterceptionModule(componentMBeanArray[0].getURI());
    }
}

