/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.interception.module;

import java.io.PrintWriter;
import weblogic.management.DeploymentException;
import weblogic.messaging.interception.module.WLDeploymentException;
import weblogic.utils.AssertionError;
import weblogic.utils.PlatformConstants;
import weblogic.utils.StackTraceUtils;

public final class InterceptionDeploymentException
extends DeploymentException {
    private String interceptionName;
    private String interceptionFileName;
    private WLDeploymentException[] deploymentExceptions;
    private Throwable unexpectedError;

    public InterceptionDeploymentException(String string, String string2, WLDeploymentException wLDeploymentException) {
        super(string);
        this.interceptionName = string;
        this.interceptionFileName = string2;
        this.deploymentExceptions = new WLDeploymentException[1];
        this.deploymentExceptions[0] = wLDeploymentException;
    }

    public InterceptionDeploymentException(String string, String string2, WLDeploymentException[] wLDeploymentExceptionArray) {
        super(string);
        this.interceptionName = string;
        this.interceptionFileName = string2;
        this.deploymentExceptions = wLDeploymentExceptionArray;
    }

    public InterceptionDeploymentException(String string, String string2, Throwable throwable) {
        super(string);
        this.interceptionName = string;
        this.interceptionFileName = string2;
        this.unexpectedError = throwable;
    }

    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer(200);
        if (this.deploymentExceptions != null) {
            stringBuffer.append(PlatformConstants.EOL);
            stringBuffer.append("Reason: ");
            for (int i = 0; i < this.deploymentExceptions.length; ++i) {
                stringBuffer.append(this.deploymentExceptions[i].getErrorMessage());
                stringBuffer.append(PlatformConstants.EOL);
            }
        } else if (this.unexpectedError != null) {
            stringBuffer.append(StackTraceUtils.throwable2StackTrace((Throwable)this.unexpectedError));
            stringBuffer.append(PlatformConstants.EOL);
        } else {
            throw new AssertionError("Expected either deploymentExceptions or unexpectedError to be non-null.");
        }
        stringBuffer.append(PlatformConstants.EOL);
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getMessage();
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        printWriter.println(this.getMessage());
    }
}

