/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.interception.module;

import java.io.File;
import weblogic.application.Deployment;
import weblogic.application.DeploymentFactory;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.messaging.interception.module.InterceptionDeployment;

public final class InterceptionDeploymentFactory
implements DeploymentFactory {
    private boolean isInterception(File file) {
        if (file.isDirectory()) {
            return false;
        }
        return file.getName().endsWith("-interception.xml");
    }

    public Deployment createDeployment(AppDeploymentMBean appDeploymentMBean, File file) throws DeploymentException {
        if (!this.isInterception(file)) {
            return null;
        }
        return new InterceptionDeployment(appDeploymentMBean, file);
    }

    public Deployment createDeployment(SystemResourceMBean systemResourceMBean, File file) throws DeploymentException {
        return null;
    }
}

