/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.interception.module;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import weblogic.application.AdminModeCompletionBarrier;
import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.Module;
import weblogic.application.ModuleException;
import weblogic.application.UpdateListener;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.AssociationBean;
import weblogic.j2ee.descriptor.wl.InterceptionBean;
import weblogic.management.ManagementException;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.messaging.interception.MessageInterceptionService;
import weblogic.messaging.interception.exceptions.InterceptionServiceException;
import weblogic.messaging.interception.interfaces.AssociationHandle;
import weblogic.messaging.interception.interfaces.InterceptionPointNameDescriptionListener;
import weblogic.messaging.interception.interfaces.InterceptionService;
import weblogic.messaging.interception.interfaces.ProcessorHandle;
import weblogic.messaging.interception.module.InterceptionComponent;
import weblogic.messaging.interception.module.InterceptionParser;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.classloaders.GenericClassLoader;

public class InterceptionModule
implements Module,
UpdateListener {
    private InterceptionBean wholeModule = null;
    private HashMap doLaterList = new HashMap();
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private ApplicationContextInternal appCtx;
    private InterceptionParser parser;
    private final String uri;
    private InterceptionComponent interceptionComponent;

    public InterceptionModule(String string) {
        this.uri = string;
        this.parser = new InterceptionParser();
    }

    public String getId() {
        return this.uri;
    }

    public String getType() {
        return WebLogicModuleType.MODULETYPE_INTERCEPT;
    }

    public DescriptorBean[] getDescriptors() {
        return new DescriptorBean[0];
    }

    public ComponentRuntimeMBean[] getComponentRuntimeMBeans() {
        return new ComponentRuntimeMBean[]{this.interceptionComponent};
    }

    public void initUsingLoader(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        this.init(applicationContext, genericClassLoader, registration);
    }

    public static String getCanonicalPath(ApplicationContextInternal applicationContextInternal, String string) {
        File[] fileArray = applicationContextInternal.getApplicationPaths();
        string = fileArray[0] + "/" + string;
        return new File(string).getAbsolutePath().replace(File.separatorChar, '/');
    }

    static void callAddAssociation(AssociationBean associationBean) throws InterceptionServiceException {
        InterceptionService interceptionService = MessageInterceptionService.getSingleton();
        interceptionService.addAssociation(associationBean.getInterceptionPoint().getType(), associationBean.getInterceptionPoint().getNameSegment(), associationBean.getProcessor().getType(), associationBean.getProcessor().getName(), true);
    }

    private static void callRemoveAssociation(AssociationBean associationBean) throws InterceptionServiceException {
        InterceptionService interceptionService = MessageInterceptionService.getSingleton();
        AssociationHandle associationHandle = interceptionService.getAssociationHandle(associationBean.getInterceptionPoint().getType(), associationBean.getInterceptionPoint().getNameSegment());
        if (associationHandle != null) {
            interceptionService.removeAssociation(associationHandle);
        }
    }

    public boolean loadConfiguration() throws InterceptionServiceException {
        int n;
        InterceptionService interceptionService = MessageInterceptionService.getSingleton();
        for (n = 0; n < this.wholeModule.getProcessorTypes().length; ++n) {
            try {
                interceptionService.registerProcessorType(this.wholeModule.getProcessorTypes()[n].getType(), this.wholeModule.getProcessorTypes()[n].getFactory());
                continue;
            }
            catch (InterceptionServiceException interceptionServiceException) {
                // empty catch block
            }
        }
        for (n = 0; n < this.wholeModule.getProcessors().length; ++n) {
            interceptionService.addProcessor(this.wholeModule.getProcessors()[n].getType(), this.wholeModule.getProcessors()[n].getName(), this.wholeModule.getProcessors()[n].getMetadata());
        }
        for (n = 0; n < this.wholeModule.getAssociations().length; ++n) {
            AssociationBean associationBean = this.wholeModule.getAssociations()[n];
            String string = associationBean.getInterceptionPoint().getType();
            if (interceptionService.getInterceptionPointNameDescription(string) == null) {
                DoLaterClass doLaterClass = (DoLaterClass)this.doLaterList.get(string);
                if (doLaterClass == null) {
                    doLaterClass = new DoLaterClass(string);
                    this.doLaterList.put(string, doLaterClass);
                }
                doLaterClass.addLater(associationBean);
                continue;
            }
            InterceptionModule.callAddAssociation(associationBean);
        }
        return true;
    }

    public boolean unloadConfiguration() throws InterceptionServiceException {
        Object object;
        int n;
        InterceptionService interceptionService = MessageInterceptionService.getSingleton();
        for (n = 0; n < this.wholeModule.getAssociations().length; ++n) {
            object = this.wholeModule.getAssociations()[n];
            String string = object.getInterceptionPoint().getType();
            if (interceptionService.getInterceptionPointNameDescription(string) == null) {
                DoLaterClass doLaterClass = (DoLaterClass)this.doLaterList.get(string);
                if (doLaterClass == null) continue;
                doLaterClass.dontAddLater((AssociationBean)object);
                continue;
            }
            InterceptionModule.callRemoveAssociation(object);
        }
        for (n = 0; n < this.wholeModule.getProcessors().length; ++n) {
            object = interceptionService.getProcessorHandle(this.wholeModule.getProcessors()[n].getType(), this.wholeModule.getProcessors()[n].getName());
            if (object == null) continue;
            interceptionService.removeProcessor((ProcessorHandle)object);
        }
        return true;
    }

    public GenericClassLoader init(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        boolean bl = false;
        LinkedList linkedList = new LinkedList();
        this.appCtx = (ApplicationContextInternal)applicationContext;
        registration.addUpdateListener(this);
        this.wholeModule = this.parser.createInterceptionDescriptor(this.appCtx, this.uri);
        try {
            this.interceptionComponent = new InterceptionComponent(this.appCtx.getApplicationId(), this.appCtx);
            this.interceptionComponent.begin();
        }
        catch (ManagementException managementException) {
            throw new ModuleException("ERROR: Could not create JMSComponent", managementException);
        }
        return genericClassLoader;
    }

    public void prepare() {
    }

    public void activate() throws ModuleException {
        try {
            this.loadConfiguration();
        }
        catch (InterceptionServiceException interceptionServiceException) {
            throw new ModuleException("Cannot load interception configuration" + interceptionServiceException, interceptionServiceException);
        }
    }

    public void start() {
    }

    public void deactivate() throws ModuleException {
        try {
            this.unloadConfiguration();
        }
        catch (InterceptionServiceException interceptionServiceException) {
            throw new ModuleException("Cannot unload interception configuration");
        }
    }

    public void unprepare() {
    }

    public void destroy(UpdateListener.Registration registration) throws ModuleException {
        registration.removeUpdateListener(this);
        try {
            this.interceptionComponent.end();
        }
        catch (ManagementException managementException) {
            throw new ModuleException("unregister of InterceptionComponent failed", managementException);
        }
    }

    public void remove() {
    }

    public void adminToProduction() {
    }

    public void gracefulProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) {
    }

    public void forceProductionToAdmin() {
    }

    public boolean acceptURI(String string) {
        if (".".equals(string)) {
            return true;
        }
        return this.uri.equals(string);
    }

    public void prepareUpdate(String string) {
    }

    public void activateUpdate(String string) throws ModuleException {
        this.deactivate();
        this.activate();
    }

    public void rollbackUpdate(String string) {
    }

    private final class DoLaterClass
    implements InterceptionPointNameDescriptionListener {
        private String type = null;
        private LinkedList doLater = new LinkedList();
        private boolean registered = false;
        private InterceptionService service = MessageInterceptionService.getSingleton();

        public DoLaterClass(String string) {
            this.type = string;
            try {
                this.service.registerInterceptionPointNameDescriptionListener(this);
            }
            catch (InterceptionServiceException interceptionServiceException) {
                throw new AssertionError((Object)("Programmer error - exception when registering for notification with Interception Service" + interceptionServiceException));
            }
        }

        public void addLater(AssociationBean associationBean) throws InterceptionServiceException {
            if (this.registered) {
                InterceptionModule.callAddAssociation(associationBean);
            } else {
                this.doLater.add(associationBean);
            }
        }

        private boolean sameNamedAssociations(AssociationBean associationBean, AssociationBean associationBean2) {
            String[] stringArray;
            String[] stringArray2 = associationBean.getInterceptionPoint().getNameSegment();
            if (stringArray2.length != (stringArray = associationBean2.getInterceptionPoint().getNameSegment()).length) {
                return false;
            }
            for (int i = 0; i < stringArray2.length; ++i) {
                if (stringArray2[i].equals(stringArray[i])) continue;
                return false;
            }
            return true;
        }

        public void dontAddLater(AssociationBean associationBean) {
            ListIterator listIterator = this.doLater.listIterator();
            while (listIterator.hasNext()) {
                AssociationBean associationBean2 = (AssociationBean)listIterator.next();
                if (!this.sameNamedAssociations(associationBean, associationBean2)) continue;
                this.doLater.remove(associationBean2);
                break;
            }
        }

        public final void addAssociationsFromList() {
            ListIterator listIterator = this.doLater.listIterator(0);
            while (listIterator.hasNext()) {
                AssociationBean associationBean = (AssociationBean)listIterator.next();
                try {
                    InterceptionModule.callAddAssociation(associationBean);
                }
                catch (InterceptionServiceException interceptionServiceException) {}
            }
            this.doLater = null;
        }

        public void onRegister() {
            this.registered = true;
            try {
                SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() {
                        DoLaterClass.this.addAssociationsFromList();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new AssertionError((Object)("addAssociations problem" + privilegedActionException));
            }
        }

        public String getType() {
            return this.type;
        }
    }
}

