/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.interception.module;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ModuleException;
import weblogic.application.descriptor.AbstractDescriptorLoader2;
import weblogic.application.descriptor.VersionMunger;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.InterceptionBean;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.utils.classloaders.GenericClassLoader;

public class InterceptionParser {
    private AbstractDescriptorLoader2 interceptionDescriptor = null;
    private String interceptionFileName;
    private final boolean debug = false;

    public InterceptionBean createInterceptionDescriptor(String string) throws ModuleException {
        if (string == null) {
            throw new ModuleException("Null URI specified");
        }
        if (this.interceptionDescriptor == null) {
            this.interceptionDescriptor = InterceptionParser.createDescriptorLoader(new File(string), null, null, null, null);
        }
        try {
            return this.getInterceptionBean();
        }
        catch (Exception exception) {
            throw new ModuleException(exception.toString(), exception);
        }
    }

    public InterceptionBean createInterceptionDescriptor(ApplicationContextInternal applicationContextInternal, String string) throws ModuleException {
        if (string == null) {
            throw new ModuleException("Null URI specified");
        }
        AppDeploymentMBean appDeploymentMBean = applicationContextInternal.getAppDeploymentMBean();
        DeploymentPlanBean deploymentPlanBean = null;
        File file = null;
        String string2 = null;
        String string3 = null;
        if (appDeploymentMBean != null) {
            deploymentPlanBean = appDeploymentMBean.getDeploymentPlanDescriptor();
            file = null;
            if (appDeploymentMBean.getPlanDir() != null) {
                file = new File(appDeploymentMBean.getLocalPlanDir());
            }
            string2 = this.getModuleName(appDeploymentMBean, string);
            string3 = this.getModuleUri(appDeploymentMBean, string);
        }
        if (this.interceptionDescriptor == null) {
            this.interceptionDescriptor = InterceptionParser.createDescriptorLoader(new File(this.getCanonicalPath(applicationContextInternal, string)), file, deploymentPlanBean, string2, string3);
        }
        try {
            return this.getInterceptionBean();
        }
        catch (Exception exception) {
            throw new ModuleException(exception.toString());
        }
    }

    private String getModuleUri(AppDeploymentMBean appDeploymentMBean, String string) {
        if (appDeploymentMBean.getSourcePath() != null && appDeploymentMBean.getSourcePath().endsWith(".xml")) {
            return ".";
        }
        return string;
    }

    private String getModuleName(AppDeploymentMBean appDeploymentMBean, String string) {
        if (appDeploymentMBean.getSourcePath() != null) {
            return new File(appDeploymentMBean.getSourcePath()).getName();
        }
        return string;
    }

    public InterceptionBean createInterceptionDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) throws IOException, XMLStreamException {
        this.interceptionDescriptor = InterceptionParser.createDescriptorLoader(descriptorManager, genericClassLoader, file, deploymentPlanBean, string, string2);
        return this.getInterceptionBean();
    }

    public String getCanonicalPath(ApplicationContextInternal applicationContextInternal, String string) {
        File[] fileArray = applicationContextInternal.getApplicationPaths();
        string = fileArray[0] + "/" + string;
        return new File(string).getAbsolutePath().replace(File.separatorChar, '/');
    }

    public InterceptionBean getInterceptionBean() throws IOException, XMLStreamException {
        return (InterceptionBean)this.interceptionDescriptor.loadDescriptorBean();
    }

    private static AbstractDescriptorLoader2 createDescriptorLoader(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
        return new AbstractDescriptorLoader2(descriptorManager, genericClassLoader, file, deploymentPlanBean, string, string2){

            protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
                return InterceptionParser.createVersionMunger(inputStream, this);
            }
        };
    }

    private static AbstractDescriptorLoader2 createDescriptorLoader(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
        return new AbstractDescriptorLoader2(file, file2, deploymentPlanBean, string, string2){

            protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
                return InterceptionParser.createVersionMunger(inputStream, this);
            }
        };
    }

    private static VersionMunger createVersionMunger(InputStream inputStream, AbstractDescriptorLoader2 abstractDescriptorLoader2) throws XMLStreamException {
        String string = "weblogic.j2ee.descriptor.wl.InterceptionBeanImpl$SchemaHelper2";
        return new VersionMunger(inputStream, abstractDescriptorLoader2, string, "http://xmlns.oracle.com/weblogic/weblogic-interception");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            InterceptionParser.usage();
        }
        System.out.println("\n\n... getting InterceptionBean:");
        ((DescriptorBean)new InterceptionParser().createInterceptionDescriptor(stringArray[0])).getDescriptor().toXML((OutputStream)System.out);
    }

    private static void usage() {
        System.err.println("usage: java weblogic.messaging.interception.module.InterceptionParser <descriptor file name>");
        System.err.println("\n\n example:\n java weblogic.messaging.interception.module.InterceptionParser sample.xml");
        System.exit(0);
    }
}

