/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.kernel.runtime;

import java.util.ArrayList;
import java.util.Comparator;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import weblogic.messaging.Message;
import weblogic.messaging.kernel.Cursor;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.MessageElement;
import weblogic.messaging.runtime.CursorDelegate;
import weblogic.messaging.runtime.CursorRuntimeImpl;
import weblogic.messaging.runtime.OpenDataConverter;

public class MessageCursorDelegate
extends CursorDelegate {
    protected OpenDataConverter messageOpenDataConverter;
    protected transient CursorIterator cursorIterator;
    protected transient ArrayList lastPageList;

    public MessageCursorDelegate(CursorRuntimeImpl cursorRuntimeImpl, OpenDataConverter openDataConverter, Cursor cursor, OpenDataConverter openDataConverter2, int n) {
        super(cursorRuntimeImpl, openDataConverter, n);
        this.messageOpenDataConverter = openDataConverter2;
        this.cursorIterator = new CursorIterator(cursor);
        this.endPosition = 0L;
        this.startPosition = 0L;
    }

    public CompositeData[] getNext(int n) throws OpenDataException {
        this.updateAccessTime();
        if (this.endPosition >= this.cursorIterator.size()) {
            return null;
        }
        int n2 = 0;
        this.lastPageList = new ArrayList();
        this.startPosition = this.endPosition;
        this.cursorIterator.seek(this.startPosition);
        do {
            this.lastPageList.add(this.cursorIterator.currentElement());
        } while (this.cursorIterator.next() != null && ++n2 < n);
        this.endPosition = this.startPosition + (long)n2;
        return this.getCompositeDataArray(this.lastPageList);
    }

    public CompositeData[] getPrevious(int n) throws OpenDataException {
        int n2;
        this.updateAccessTime();
        if (this.startPosition <= 0L) {
            this.startPosition = 0L;
            return null;
        }
        this.lastPageList = new ArrayList();
        this.endPosition = this.startPosition;
        this.cursorIterator.seek(this.startPosition - 1L);
        this.lastPageList.add(0, this.cursorIterator.currentElement());
        for (n2 = 1; this.cursorIterator.previous() != null && n2 < n; ++n2) {
            this.lastPageList.add(0, this.cursorIterator.currentElement());
        }
        this.startPosition = this.endPosition - (long)n2;
        return this.getCompositeDataArray(this.lastPageList);
    }

    public CompositeData[] getItems(long l, int n) throws OpenDataException {
        this.updateAccessTime();
        if (this.cursorIterator.size() == 0L) {
            return null;
        }
        if (l < 0L || l >= this.cursorIterator.size()) {
            throw new IndexOutOfBoundsException("Value of start argument (" + l + ") is invalid.  Start index must be between 0 and " + this.cursorIterator.size() + " - 1.");
        }
        this.cursorIterator.seek(l);
        this.startPosition = this.endPosition = this.cursorIterator.getPosition();
        return this.getNext(n);
    }

    public Long getCursorSize() {
        this.updateAccessTime();
        return new Long(this.cursorIterator.size());
    }

    public void close() {
        super.close();
        this.cursorIterator.close();
    }

    public CompositeData getMessage(String string) throws OpenDataException {
        this.updateAccessTime();
        MessageElement messageElement = this.findMessage(new MessageIDMessageKey(string));
        if (messageElement == null) {
            return null;
        }
        return this.messageOpenDataConverter.createCompositeData(messageElement);
    }

    public CompositeData getMessage(long l) throws OpenDataException {
        this.updateAccessTime();
        MessageElement messageElement = this.findMessage(new HandleMessageKey(l));
        if (messageElement == null) {
            return null;
        }
        return this.messageOpenDataConverter.createCompositeData(messageElement);
    }

    protected CompositeData[] getCompositeDataArray(ArrayList arrayList) throws OpenDataException {
        CompositeData[] compositeDataArray = new CompositeData[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            compositeDataArray[i] = this.openDataConverter.createCompositeData((MessageElement)arrayList.get(i));
        }
        return compositeDataArray;
    }

    protected boolean compareMessageID(Message message, String string) {
        return message != null && message.getMessageID().toString().equals(string);
    }

    protected MessageElement findMessage(MessageKey messageKey) {
        if (this.lastPageList != null) {
            for (int i = 0; i < this.lastPageList.size(); ++i) {
                MessageElement messageElement = (MessageElement)this.lastPageList.get(i);
                if (!messageKey.matches(messageElement)) continue;
                return messageElement;
            }
        }
        this.cursorIterator.rewind();
        while (this.cursorIterator.hasNext()) {
            MessageElement messageElement = this.cursorIterator.currentElement();
            if (messageKey.matches(messageElement)) {
                return messageElement;
            }
            this.cursorIterator.next();
        }
        return null;
    }

    public class CursorIterator {
        private Cursor cursor;
        private long currentPosition;
        private MessageElement currentElement;

        public CursorIterator(Cursor cursor) {
            this.cursor = cursor;
            this.rewind();
        }

        public void close() {
            this.cursor.close();
        }

        public boolean hasPrevious() {
            return this.currentPosition != 0L;
        }

        public boolean hasNext() {
            if (this.size() == 0L) {
                return false;
            }
            return this.currentPosition != this.size() - 1L;
        }

        public MessageElement previous() {
            if (this.currentPosition == 0L) {
                return null;
            }
            try {
                MessageElement messageElement = this.cursor.previous();
                if (messageElement != null && messageElement.getMessage().equals(this.currentElement.getMessage())) {
                    messageElement = this.cursor.previous();
                }
                if (messageElement != null) {
                    --this.currentPosition;
                }
                this.currentElement = messageElement;
            }
            catch (KernelException kernelException) {
                this.currentElement = null;
            }
            catch (Exception exception) {
                this.currentElement = null;
            }
            return this.currentElement;
        }

        public MessageElement next() {
            if (this.currentPosition == (long)(this.cursor.size() - 1)) {
                return null;
            }
            try {
                MessageElement messageElement = this.cursor.next();
                if (messageElement != null && messageElement.getMessage().equals(this.currentElement.getMessage())) {
                    messageElement = this.cursor.next();
                }
                if (messageElement != null) {
                    ++this.currentPosition;
                }
                this.currentElement = messageElement;
            }
            catch (KernelException kernelException) {
                this.currentElement = null;
            }
            catch (Exception exception) {
                this.currentElement = null;
            }
            return this.currentElement;
        }

        public long getPosition() {
            return this.currentPosition;
        }

        public MessageElement currentElement() {
            return this.currentElement;
        }

        public MessageElement seek(long l) {
            if (l >= this.size() || l < 0L) {
                return null;
            }
            while (this.getPosition() < l) {
                this.next();
            }
            while (this.getPosition() > l) {
                this.previous();
            }
            return this.currentElement;
        }

        public MessageElement seek(MessageElement messageElement) {
            this.rewind();
            do {
                if (this.currentElement() != messageElement) continue;
                return messageElement;
            } while (this.next() != null);
            return null;
        }

        public MessageElement rewind() {
            try {
                while (this.cursor.previous() != null) {
                }
                this.currentElement = this.cursor.next();
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
            this.currentPosition = 0L;
            return this.currentElement;
        }

        public long size() {
            return this.cursor.size();
        }

        public void setComparator(Comparator comparator) {
            this.cursor.setElementComparator(comparator);
        }
    }

    class MessageIDMessageKey
    implements MessageKey {
        String messageID;

        MessageIDMessageKey(String string) {
            this.messageID = string;
        }

        public boolean matches(MessageElement messageElement) {
            Message message = messageElement.getMessage();
            return MessageCursorDelegate.this.compareMessageID(message, this.messageID);
        }
    }

    class HandleMessageKey
    implements MessageKey {
        long handle;

        HandleMessageKey(long l) {
            this.handle = l;
        }

        public boolean matches(MessageElement messageElement) {
            return messageElement != null && messageElement.getInternalSequenceNumber() == this.handle;
        }
    }

    static interface MessageKey {
        public boolean matches(MessageElement var1);
    }
}

