/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.path;

import java.io.Serializable;
import java.security.AccessController;
import weblogic.management.provider.ManagementService;
import weblogic.messaging.path.AsyncMap;
import weblogic.messaging.path.AsyncMapRemote;
import weblogic.messaging.path.CompletionAsyncResultAdapter;
import weblogic.messaging.path.ExceptionAdapter;
import weblogic.messaging.path.helper.PathHelper;
import weblogic.rmi.extensions.AsyncResult;
import weblogic.rmi.extensions.server.FutureResponse;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class AsyncMapImpl
implements AsyncMapRemote {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    protected String jndiName;
    private final AsyncMap asyncMapDelegate;
    private final ExceptionAdapter exceptionAdapter;

    AsyncMapImpl(String string, AsyncMap asyncMap, ExceptionAdapter exceptionAdapter) {
        this.jndiName = string;
        this.exceptionAdapter = exceptionAdapter;
        this.asyncMapDelegate = asyncMap;
    }

    private static void impossible(String string) {
        throw new Error("must not invoke this '" + string + "' signature on " + ManagementService.getRuntimeAccess(kernelId).getServerName());
    }

    public final void get(Serializable serializable, AsyncResult asyncResult) {
        AsyncMapImpl.impossible("get");
    }

    public final void get(Serializable serializable, AsyncResult asyncResult, FutureResponse futureResponse) {
        CompletionAsyncResultAdapter completionAsyncResultAdapter = new CompletionAsyncResultAdapter(futureResponse, asyncResult, this.exceptionAdapter);
        if (PathHelper.PathSvcVerbose.isDebugEnabled()) {
            PathHelper.PathSvcVerbose.debug("AsyncMapImpl get " + serializable);
        }
        try {
            this.asyncMapDelegate.get(serializable, completionAsyncResultAdapter);
        }
        catch (RuntimeException runtimeException) {
            AsyncMapImpl.notifyCaller(completionAsyncResultAdapter, runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            AsyncMapImpl.notifyCaller(completionAsyncResultAdapter, error);
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyCaller(CompletionAsyncResultAdapter completionAsyncResultAdapter, Throwable throwable) {
        CompletionAsyncResultAdapter completionAsyncResultAdapter2 = completionAsyncResultAdapter;
        synchronized (completionAsyncResultAdapter2) {
            if (completionAsyncResultAdapter.hasResult()) {
                return;
            }
        }
        completionAsyncResultAdapter.setResult(throwable);
    }

    public void remove(Serializable serializable, Serializable serializable2, AsyncResult asyncResult) {
        AsyncMapImpl.impossible("remove");
    }

    public void remove(Serializable serializable, Serializable serializable2, AsyncResult asyncResult, FutureResponse futureResponse) {
        CompletionAsyncResultAdapter completionAsyncResultAdapter = new CompletionAsyncResultAdapter(futureResponse, asyncResult, this.exceptionAdapter);
        if (PathHelper.PathSvcVerbose.isDebugEnabled()) {
            PathHelper.PathSvcVerbose.debug("AsyncMapImpl remove " + serializable + ", value:" + serializable2);
        }
        try {
            this.asyncMapDelegate.remove(serializable, serializable2, completionAsyncResultAdapter);
        }
        catch (RuntimeException runtimeException) {
            AsyncMapImpl.notifyCaller(completionAsyncResultAdapter, runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            AsyncMapImpl.notifyCaller(completionAsyncResultAdapter, error);
            throw error;
        }
    }

    public void put(Serializable serializable, Serializable serializable2, AsyncResult asyncResult) {
        AsyncMapImpl.impossible("put");
    }

    public void put(Serializable serializable, Serializable serializable2, AsyncResult asyncResult, FutureResponse futureResponse) {
        CompletionAsyncResultAdapter completionAsyncResultAdapter = new CompletionAsyncResultAdapter(futureResponse, asyncResult, this.exceptionAdapter);
        if (PathHelper.PathSvcVerbose.isDebugEnabled()) {
            PathHelper.PathSvcVerbose.debug("AsyncMapImpl put " + serializable + ", value:" + serializable2);
        }
        try {
            this.asyncMapDelegate.put(serializable, serializable2, completionAsyncResultAdapter);
        }
        catch (RuntimeException runtimeException) {
            AsyncMapImpl.notifyCaller(completionAsyncResultAdapter, runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            AsyncMapImpl.notifyCaller(completionAsyncResultAdapter, error);
            throw error;
        }
    }

    public void putIfAbsent(Serializable serializable, Serializable serializable2, AsyncResult asyncResult) {
        AsyncMapImpl.impossible("putIfAbsent");
    }

    public void putIfAbsent(Serializable serializable, Serializable serializable2, AsyncResult asyncResult, FutureResponse futureResponse) {
        CompletionAsyncResultAdapter completionAsyncResultAdapter = new CompletionAsyncResultAdapter(futureResponse, asyncResult, this.exceptionAdapter);
        if (PathHelper.PathSvcVerbose.isDebugEnabled()) {
            PathHelper.PathSvcVerbose.debug("AsyncMapImpl putIfAbsent " + serializable + ", value:" + serializable2);
        }
        try {
            this.asyncMapDelegate.putIfAbsent(serializable, serializable2, completionAsyncResultAdapter);
        }
        catch (RuntimeException runtimeException) {
            AsyncMapImpl.notifyCaller(completionAsyncResultAdapter, runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            AsyncMapImpl.notifyCaller(completionAsyncResultAdapter, error);
            throw error;
        }
    }

    public String getJndiName() {
        return this.jndiName;
    }
}

