/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.path;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import weblogic.common.CompletionListener;
import weblogic.common.CompletionRequest;
import weblogic.messaging.path.ExceptionAdapter;
import weblogic.messaging.path.helper.PathHelper;
import weblogic.rmi.extensions.AsyncResult;
import weblogic.rmi.extensions.AsyncResultFactory;
import weblogic.rmi.extensions.AsyncResultListener;
import weblogic.rmi.extensions.server.FutureResponse;
import weblogic.utils.StackTraceUtils;

public class CompletionAsyncResultAdapter
extends CompletionRequest
implements CompletionListener,
AsyncResultListener {
    private final AsyncResult asyncResult;
    private final FutureResponse futureResponse;
    private final CompletionRequest completionRequest;
    private final ExceptionAdapter exceptionAdapter;
    private static final NullResult singletonNullResult = new NullResult();

    public CompletionAsyncResultAdapter(FutureResponse futureResponse, AsyncResult asyncResult, ExceptionAdapter exceptionAdapter) {
        this.asyncResult = asyncResult;
        this.futureResponse = futureResponse;
        this.exceptionAdapter = exceptionAdapter;
        this.addListener(this);
        this.completionRequest = null;
    }

    public CompletionAsyncResultAdapter(CompletionRequest completionRequest) {
        this.completionRequest = completionRequest;
        this.addListener(this);
        this.asyncResult = null;
        this.futureResponse = null;
        this.exceptionAdapter = null;
    }

    public AsyncResult getCallbackableResult() {
        return AsyncResultFactory.getCallbackableResult((AsyncResultListener)this);
    }

    public final void handleResult(AsyncResult asyncResult) {
        Object object;
        try {
            object = asyncResult.getObject();
            if (object instanceof NullResult) {
                object = null;
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = CompletionAsyncResultAdapter.wrapException(this.exceptionAdapter, throwable);
            this.completionRequest.setResult((Object)throwable2);
            this.exceptionMonitor(throwable2);
            return;
        }
        if (PathHelper.PathSvcVerbose.isDebugEnabled()) {
            PathHelper.PathSvcVerbose.debug("CompletionAsyncResultAdapter result " + object);
        }
        if (object instanceof Throwable) {
            object = CompletionAsyncResultAdapter.wrapException(this.exceptionAdapter, (Throwable)object);
        }
        this.completionRequest.setResult(object);
    }

    static Throwable unwrapException(ExceptionAdapter exceptionAdapter, Throwable throwable) {
        if (exceptionAdapter != null) {
            throwable = exceptionAdapter.unwrapException(throwable);
        }
        return throwable;
    }

    static Throwable wrapException(ExceptionAdapter exceptionAdapter, Throwable throwable) {
        if (exceptionAdapter != null) {
            throwable = exceptionAdapter.wrapException(throwable);
        }
        return throwable;
    }

    Throwable wrapException(Throwable throwable) {
        return CompletionAsyncResultAdapter.wrapException(this.exceptionAdapter, throwable);
    }

    void exceptionMonitor(Throwable throwable) {
    }

    public final void onException(CompletionRequest completionRequest, Throwable throwable) {
        if (PathHelper.retired && PathHelper.PathSvcVerbose.isDebugEnabled()) {
            PathHelper.PathSvc.debug("debug setResult ", throwable);
        }
        this.onCompletion(completionRequest, throwable);
    }

    public final void onCompletion(CompletionRequest completionRequest, Object object) {
        block13: {
            try {
                Throwable throwable;
                if (object instanceof Throwable) {
                    throwable = CompletionAsyncResultAdapter.unwrapException(this.exceptionAdapter, (Throwable)object);
                    throwable = StackTraceUtils.getThrowableWithCause((Throwable)throwable);
                    object = throwable;
                } else if (object == null) {
                    throwable = null;
                    object = singletonNullResult;
                } else {
                    throwable = null;
                }
                if (throwable != null && this.futureResponse != null) {
                    this.futureResponse.sendThrowable(throwable);
                } else if (this.asyncResult != null) {
                    this.asyncResult.setResult(object);
                    if (this.futureResponse != null) {
                        this.futureResponse.send();
                    }
                } else {
                    this.futureResponse.getMsgOutput().writeObject(object, object.getClass());
                    this.futureResponse.send();
                }
            }
            catch (RemoteException remoteException) {
                if (PathHelper.PathSvc.isDebugEnabled()) {
                    PathHelper.PathSvc.debug(remoteException.getMessage(), (Throwable)remoteException);
                }
            }
            catch (IOException iOException) {
                if (!PathHelper.PathSvc.isDebugEnabled()) break block13;
                PathHelper.PathSvc.debug(iOException.getMessage(), (Throwable)iOException);
            }
        }
    }

    public static final class NullResult
    implements Serializable {
        static final long serialVersionUID = -3666697078933257427L;
    }
}

