/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.path;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import weblogic.messaging.path.Member;
import weblogic.utils.encoders.BASE64Decoder;
import weblogic.utils.encoders.BASE64Encoder;

public class MemberInfo {
    static final long serialVersionUID = -6246813905189434496L;
    private static final String ITEM_VERSION_NUMBER = "VersionNumber";
    private static final String ITEM_SERIALIZED_MEMBER = "SerializedMember";
    private static String OPEN_TYPE_NAME = "MemberInfo";
    private static String OPEN_DESCRIPTION = "This object represents information about a path service member.A Member is an entry in an Assembly. For example, Queues are Members of a JMS Distributed Queue Assembly.  A 'path' is a particular Assembly member given a key.  A single Member will be identified by many different 'path' keys";
    private static String[] itemNames = new String[]{"VersionNumber", "SerializedMember"};
    private static String[] itemDescriptions = new String[]{"The version number.", "The serialized representation of a path service Member"};
    private static OpenType[] itemTypes = new OpenType[]{SimpleType.INTEGER, SimpleType.STRING};
    private static final int VERSION = 1;
    private Member member;

    public MemberInfo(CompositeData compositeData) throws OpenDataException {
        this.readCompositeData(compositeData);
    }

    public MemberInfo(Member member) {
        this.member = member;
    }

    public Member getMember() {
        return this.member;
    }

    public CompositeData toCompositeData() throws OpenDataException {
        CompositeDataSupport compositeDataSupport = new CompositeDataSupport(this.getCompositeType(), this.getCompositeDataMap());
        return compositeDataSupport;
    }

    protected void readCompositeData(CompositeData compositeData) throws OpenDataException {
        try {
            String string = (String)compositeData.get(ITEM_SERIALIZED_MEMBER);
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            byte[] byArray = bASE64Decoder.decodeBuffer(string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            this.member = (Member)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            OpenDataException openDataException = new OpenDataException("Unable to deserialize member.");
            openDataException.initCause(iOException);
            throw openDataException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            OpenDataException openDataException = new OpenDataException("Unable to deserialize member.");
            openDataException.initCause(classNotFoundException);
            throw openDataException;
        }
    }

    private Map getCompositeDataMap() throws OpenDataException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            try {
                hashMap.put(ITEM_VERSION_NUMBER, new Integer(1));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(this.member);
                BASE64Encoder bASE64Encoder = new BASE64Encoder();
                String string = bASE64Encoder.encodeBuffer(byteArrayOutputStream.toByteArray());
                hashMap.put(ITEM_SERIALIZED_MEMBER, string);
            }
            catch (IOException iOException) {
                OpenDataException openDataException = new OpenDataException("Unable to serialize member.");
                openDataException.initCause(iOException);
                throw openDataException;
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            throw throwable;
        }
        return hashMap;
    }

    private CompositeType getCompositeType() throws OpenDataException {
        CompositeType compositeType = new CompositeType(OPEN_TYPE_NAME, OPEN_DESCRIPTION, itemNames, itemDescriptions, itemTypes);
        return compositeType;
    }
}

