/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.path;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import weblogic.management.ManagementException;
import weblogic.management.runtime.PSAssemblyRuntimeMBean;
import weblogic.messaging.path.Key;
import weblogic.messaging.path.PSEntryCursorDelegate;
import weblogic.messaging.path.PSEntryCursorRuntimeDelegate;
import weblogic.messaging.path.PSEntryOpenDataHelper;
import weblogic.messaging.path.PathServiceMap;
import weblogic.messaging.path.PathServiceRuntimeDelegate;
import weblogic.messaging.path.helper.KeySerializable;
import weblogic.messaging.path.helper.KeyString;
import weblogic.messaging.runtime.CursorDelegate;
import weblogic.store.PersistentStoreException;

public class PSAssemblyRuntimeDelegate
extends PSEntryCursorRuntimeDelegate
implements PSAssemblyRuntimeMBean {
    private static transient long counter;
    private transient Key sampleKey;
    private transient PathServiceMap pathService;

    public PSAssemblyRuntimeDelegate(Key key, PathServiceRuntimeDelegate pathServiceRuntimeDelegate, PathServiceMap pathServiceMap) throws ManagementException {
        super(key.getAssemblyId() + "." + PSAssemblyRuntimeDelegate.getNewCounter(), pathServiceRuntimeDelegate);
        this.pathService = pathServiceMap;
        this.sampleKey = key;
    }

    private static synchronized long getNewCounter() {
        return counter++;
    }

    public String getMapEntries() throws ManagementException {
        return this.getMapEntries(0);
    }

    public String getMapEntries(int n) throws ManagementException {
        Object object;
        Set set;
        Key[] keyArray;
        try {
            keyArray = this.pathService.mapByKey(this.sampleKey);
            set = keyArray.keySet();
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new ManagementException(persistentStoreException.getMessage());
        }
        keyArray = new Key[set.size()];
        Iterator iterator = set.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object instanceof String) {
                keyArray[n2++] = new KeyString(this.sampleKey.getSubsystem(), this.sampleKey.getAssemblyId(), (String)object);
                continue;
            }
            keyArray[n2++] = new KeySerializable(this.sampleKey.getSubsystem(), this.sampleKey.getAssemblyId(), (Serializable)object);
        }
        object = new PSEntryCursorDelegate(this, new PSEntryOpenDataHelper(), n, keyArray, this.pathService);
        this.addCursorDelegate((CursorDelegate)object);
        return ((CursorDelegate)object).getHandle();
    }
}

