/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.path;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.naming.NamingException;
import weblogic.common.CompletionRequest;
import weblogic.jms.backend.BEUOOMember;
import weblogic.jms.frontend.FEProducer;
import weblogic.management.ManagementException;
import weblogic.messaging.path.Key;
import weblogic.messaging.path.Member;
import weblogic.messaging.path.MemberInfo;
import weblogic.messaging.path.PSEntryInfo;
import weblogic.messaging.path.PathServiceMap;
import weblogic.messaging.path.helper.PathHelper;
import weblogic.messaging.runtime.ArrayCursorDelegate;
import weblogic.messaging.runtime.CursorRuntimeImpl;
import weblogic.messaging.runtime.OpenDataConverter;

public class PSEntryCursorDelegate
extends ArrayCursorDelegate {
    private PSEntryInfo[] PSEntryArray;
    private PathServiceMap pathService;

    public PSEntryCursorDelegate(CursorRuntimeImpl cursorRuntimeImpl, OpenDataConverter openDataConverter, int n, Key[] keyArray, PathServiceMap pathServiceMap) {
        super(cursorRuntimeImpl, openDataConverter, n);
        this.pathService = pathServiceMap;
        this.PSEntryArray = new PSEntryInfo[keyArray.length];
        this.entryArray = this.PSEntryArray;
        for (int i = 0; i < keyArray.length; ++i) {
            this.PSEntryArray[i] = new PSEntryInfo(keyArray[i], i);
        }
    }

    private String jndiName() {
        return this.pathService.getJndiName();
    }

    public void remove(int n) throws ManagementException {
        this.updateAccessTime();
        try {
            PathHelper.manager().cachedRemove(this.jndiName(), this.PSEntryArray[n].getKey(), null, 32776);
        }
        catch (NamingException namingException) {
            throw new ManagementException("remove operation failed on item handle " + n, (Throwable)namingException);
        }
        catch (PathHelper.PathServiceException pathServiceException) {
            throw new ManagementException("remove operation failed on item handle " + n, (Throwable)pathServiceException);
        }
    }

    public void update(int n, CompositeData compositeData) throws ManagementException {
        Member member;
        MemberInfo memberInfo;
        this.updateAccessTime();
        try {
            memberInfo = new MemberInfo(compositeData);
            member = memberInfo.getMember();
        }
        catch (OpenDataException openDataException) {
            throw new ManagementException("update operation failed on item handle " + n, (Throwable)openDataException);
        }
        memberInfo = new CompletionRequest();
        try {
            PathHelper.manager().update(this.jndiName(), this.PSEntryArray[n].getKey(), member, (CompletionRequest)memberInfo);
        }
        catch (NamingException namingException) {
            throw new ManagementException("update operation failed on item handle " + n, (Throwable)namingException);
        }
        try {
            memberInfo.getResult();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new ManagementException("update operation failed on item handle " + n, throwable);
        }
    }

    public CompositeData getMember(int n) throws ManagementException {
        Object object;
        Member member;
        this.updateAccessTime();
        CompletionRequest completionRequest = new CompletionRequest();
        try {
            PathHelper.manager().cachedGet(this.jndiName(), this.PSEntryArray[n].getKey(), 33280, completionRequest);
        }
        catch (NamingException namingException) {
            throw new ManagementException("remove operation failed on item handle " + n, (Throwable)namingException);
        }
        try {
            member = (Member)completionRequest.getResult();
        }
        catch (Throwable throwable) {
            throw new ManagementException("getMember operation failed on item handle " + n, throwable);
        }
        if (member instanceof FEProducer.ExtendedBEUOOMember) {
            object = (FEProducer.ExtendedBEUOOMember)member;
            BEUOOMember bEUOOMember = new BEUOOMember(object.getStringId(), member.getWLServerName(), object.getDynamic());
            bEUOOMember.setTimestamp(object.getTimeStamp());
            bEUOOMember.setGeneration(object.getGeneration());
            member = bEUOOMember;
        }
        object = new MemberInfo(member);
        try {
            return ((MemberInfo)object).toCompositeData();
        }
        catch (OpenDataException openDataException) {
            throw new ManagementException("getMember operation failed on item handle " + n, (Throwable)openDataException);
        }
    }
}

