/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.path;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import weblogic.messaging.path.Key;
import weblogic.utils.encoders.BASE64Decoder;
import weblogic.utils.encoders.BASE64Encoder;

public class PSEntryInfo {
    private static final String ITEM_VERSION_NUMBER = "VersionNumber";
    private static final String ITEM_CURSOR_HANDLE = "CursorHandle";
    private static final String ITEM_SERIALIZED_KEY = "SerializedKey";
    private static String OPEN_TYPE_NAME = "PSEntryInfo";
    private static String OPEN_DESCRIPTION = "This object represents information about a path service entry.  It is used by the Path Service cursor to return batches of path service entries to an administration client";
    private static String[] itemNames = new String[]{"VersionNumber", "CursorHandle", "SerializedKey"};
    private static String[] itemDescriptions = new String[]{"The version number.", "The handle to the entry in the cursor.", "The serialized representation of a path service Key"};
    private static OpenType[] itemTypes = new OpenType[]{SimpleType.INTEGER, SimpleType.LONG, SimpleType.STRING};
    private static final int VERSION = 1;
    private Key key;
    private int cursorHandle;

    public PSEntryInfo(CompositeData compositeData) throws OpenDataException {
        this.readCompositeData(compositeData);
    }

    public PSEntryInfo(Key key, int n) {
        this.key = key;
        this.cursorHandle = n;
    }

    public Key getKey() {
        return this.key;
    }

    public long getCursorHandle() {
        return this.cursorHandle;
    }

    public CompositeData toCompositeData() throws OpenDataException {
        CompositeDataSupport compositeDataSupport = new CompositeDataSupport(this.getCompositeType(), this.getCompositeDataMap());
        return compositeDataSupport;
    }

    protected void readCompositeData(CompositeData compositeData) throws OpenDataException {
        Long l = (Long)compositeData.get(ITEM_CURSOR_HANDLE);
        if (l != null) {
            this.cursorHandle = l.intValue();
        }
        try {
            String string = (String)compositeData.get(ITEM_SERIALIZED_KEY);
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            byte[] byArray = bASE64Decoder.decodeBuffer(string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            this.key = (Key)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            OpenDataException openDataException = new OpenDataException("Unable to deserialize path service entry.");
            openDataException.initCause(iOException);
            throw openDataException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            OpenDataException openDataException = new OpenDataException("Unable to deserialize path service entry.");
            openDataException.initCause(classNotFoundException);
            throw openDataException;
        }
    }

    private Map getCompositeDataMap() throws OpenDataException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(ITEM_VERSION_NUMBER, new Integer(1));
        hashMap.put(ITEM_CURSOR_HANDLE, new Long(this.getCursorHandle()));
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this.getKey());
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            String string = bASE64Encoder.encodeBuffer(byteArrayOutputStream.toByteArray());
            hashMap.put(ITEM_SERIALIZED_KEY, string);
        }
        catch (IOException iOException) {
            OpenDataException openDataException = new OpenDataException("Unable to serialize path service entry.");
            openDataException.initCause(iOException);
            throw openDataException;
        }
        return hashMap;
    }

    private CompositeType getCompositeType() throws OpenDataException {
        CompositeType compositeType = new CompositeType(OPEN_TYPE_NAME, OPEN_DESCRIPTION, itemNames, itemDescriptions, itemTypes);
        return compositeType;
    }
}

