/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.path;

import weblogic.diagnostics.image.ImageManager;
import weblogic.diagnostics.image.ImageSource;
import weblogic.diagnostics.image.ImageSourceNotFoundException;
import weblogic.management.configuration.PathServiceMBean;
import weblogic.management.utils.GenericManagedService;
import weblogic.management.utils.GenericServiceManager;
import weblogic.messaging.path.PathServiceAdmin;
import weblogic.messaging.path.PathServiceDiagnosticImageSource;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;

public class PathService
extends AbstractServerService {
    public static final String PATH_SERVICE = "PathService";
    public static final String HASH_POLICY = "Hash";
    private static PathService singleton;
    private PathServiceAdmin pathServiceAdmin;
    private boolean registered;
    private GenericManagedService pathServiceService;
    static final String IMAGE_NAME = "PathService";
    private final ImageSource IMAGE_SOURCE = new PathServiceDiagnosticImageSource(this);

    public PathService() {
        singleton = this;
    }

    public static PathService getService() {
        return singleton;
    }

    public PathServiceAdmin getPathServiceAdmin() {
        return this.pathServiceAdmin;
    }

    public void setPathServiceAdmin(PathServiceAdmin pathServiceAdmin) {
        this.pathServiceAdmin = pathServiceAdmin;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public synchronized void start() throws ServiceFailureException {
        if (!this.registered) {
            GenericServiceManager genericServiceManager = GenericServiceManager.getManager();
            this.pathServiceService = genericServiceManager.register(PathServiceMBean.class, PathServiceAdmin.class, true);
            this.registered = true;
        }
        this.pathServiceService.start();
        this.registerDiagnosticImageSource();
    }

    public synchronized void halt() throws ServiceFailureException {
        this.stop();
    }

    public void stop() throws ServiceFailureException {
        if (!this.registered) {
            return;
        }
        this.pathServiceService.stop();
        this.registered = false;
        this.unregisterDiagnosticImageSource();
    }

    public void registerDiagnosticImageSource() {
        ImageManager imageManager = ImageManager.getInstance();
        imageManager.registerImageSource("PathService", this.IMAGE_SOURCE);
    }

    private void unregisterDiagnosticImageSource() {
        ImageManager imageManager = ImageManager.getInstance();
        try {
            imageManager.unregisterImageSource("PathService");
        }
        catch (ImageSourceNotFoundException imageSourceNotFoundException) {
            // empty catch block
        }
    }
}

