/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.path;

import java.security.AccessController;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.jndi.Environment;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.UndeploymentException;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.PathServiceMBean;
import weblogic.management.configuration.PersistentStoreMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.utils.GenericAdminHandler;
import weblogic.messaging.path.AsyncMapImpl;
import weblogic.messaging.path.ExceptionAdapter;
import weblogic.messaging.path.PathLogger;
import weblogic.messaging.path.PathService;
import weblogic.messaging.path.PathServiceMap;
import weblogic.messaging.path.PathServiceRuntimeDelegate;
import weblogic.messaging.path.helper.PathHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.server.ServiceFailureException;
import weblogic.store.PersistentStoreManager;
import weblogic.store.xa.PersistentStoreXA;

public class PathServiceAdmin
implements GenericAdminHandler {
    private PathServiceMap pathMap;
    private boolean running;
    private PathServiceRuntimeDelegate psRuntimeDelegate;
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public PathServiceAdmin() {
        PathService.getService().setPathServiceAdmin(this);
    }

    public PathServiceMap getPathMap() {
        return this.pathMap;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void prepare(DeploymentMBean deploymentMBean) throws DeploymentException {
    }

    public synchronized void activate(DeploymentMBean deploymentMBean) throws DeploymentException {
        if (deploymentMBean instanceof PathServiceMBean) {
            PathServiceMBean pathServiceMBean = (PathServiceMBean)deploymentMBean;
            PersistentStoreMBean persistentStoreMBean = pathServiceMBean.getPersistentStore();
            PersistentStoreXA persistentStoreXA = persistentStoreMBean == null ? (PersistentStoreXA)PersistentStoreManager.getManager().getDefaultStore() : (PersistentStoreXA)PersistentStoreManager.getManager().getStore(persistentStoreMBean.getName());
            String string = persistentStoreMBean == null ? "DefaultStore" : persistentStoreMBean.getName();
            assert (persistentStoreXA != null);
            this.pathMap = new PathServiceMap(PathHelper.DEFAULT_PATH_SERVICE_JNDI, persistentStoreXA, (ExceptionAdapter)PathHelper.jmsOrderExceptionAdapter());
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNEL_ID);
            String string2 = deploymentMBean.getName();
            try {
                this.psRuntimeDelegate = new PathServiceRuntimeDelegate(string2, this.pathMap);
            }
            catch (ManagementException managementException) {
                throw new DeploymentException(managementException.getMessage(), managementException);
            }
            try {
                this.doJNDIOperation(true, PathHelper.DEFAULT_PATH_SERVICE_JNDI, new AsyncMapImpl(PathHelper.DEFAULT_PATH_SERVICE_JNDI, this.pathMap, PathHelper.jmsOrderExceptionAdapter()));
            }
            catch (NamingException namingException) {
                throw new DeploymentException(namingException.getMessage(), namingException);
            }
            runtimeAccess.getServerRuntime().setPathServiceRuntime(this.psRuntimeDelegate);
            PathLogger.logPathStarted((String)runtimeAccess.getServer().getName(), (String)PathHelper.DEFAULT_PATH_SERVICE_JNDI, (String)string);
            this.running = true;
        }
    }

    public synchronized void deactivate(DeploymentMBean deploymentMBean) throws UndeploymentException {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.psRuntimeDelegate = null;
        this.pathMap = null;
        try {
            ManagementService.getRuntimeAccess(KERNEL_ID).getServerRuntime().setPathServiceRuntime(this.psRuntimeDelegate);
            try {
                try {
                    this.doJNDIOperation(false, PathHelper.DEFAULT_PATH_SERVICE_JNDI, null);
                }
                catch (NamingException namingException) {
                    throw new ServiceFailureException(namingException.getMessage(), (Throwable)namingException);
                }
                Object var4_2 = null;
                PathHelper.manager().unRegister(PathHelper.DEFAULT_PATH_SERVICE_JNDI);
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                PathHelper.manager().unRegister(PathHelper.DEFAULT_PATH_SERVICE_JNDI);
                throw throwable;
            }
        }
        catch (ServiceFailureException serviceFailureException) {
            throw new UndeploymentException(serviceFailureException);
        }
    }

    public void unprepare(DeploymentMBean deploymentMBean) throws UndeploymentException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doJNDIOperation(boolean bl, String string, Object object) throws NamingException {
        Environment environment = new Environment();
        environment.setCreateIntermediateContexts(true);
        environment.setReplicateBindings(true);
        Context context = environment.getInitialContext();
        SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID);
        try {
            if (bl) {
                context.bind(string, object);
            } else {
                context.unbind(string);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
            throw throwable;
        }
        SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
    }
}

