/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.path;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.diagnostics.image.ImageSourceCreationException;
import weblogic.messaging.path.PathService;
import weblogic.messaging.runtime.DiagnosticImageSource;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;
import weblogic.store.PersistentStoreException;
import weblogic.xml.stax.util.XMLPrettyPrinter;

public class PathServiceDiagnosticImageSource
extends DiagnosticImageSource {
    private PathService pathService;

    public PathServiceDiagnosticImageSource(PathService pathService) {
        this.pathService = pathService;
    }

    public void createDiagnosticImage(OutputStream outputStream) throws ImageSourceCreationException {
        super.createDiagnosticImage(outputStream);
        try {
            XMLPrettyPrinter xMLPrettyPrinter = new XMLPrettyPrinter((Writer)new PrintWriter(outputStream), 2);
            xMLPrettyPrinter.writeStartDocument();
            try {
                this.dump((XMLStreamWriter)xMLPrettyPrinter);
            }
            catch (DiagnosticImageTimeoutException diagnosticImageTimeoutException) {
                this.dumpTimeoutComment((XMLStreamWriter)xMLPrettyPrinter);
                return;
            }
            catch (PersistentStoreException persistentStoreException) {
                throw new ImageSourceCreationException("PathService image creation failed.", (Throwable)persistentStoreException);
            }
            xMLPrettyPrinter.writeEndDocument();
            xMLPrettyPrinter.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ImageSourceCreationException("PathService image creation failed.", (Throwable)xMLStreamException);
        }
    }

    public void dump(XMLStreamWriter xMLStreamWriter) throws DiagnosticImageTimeoutException, XMLStreamException, PersistentStoreException {
        this.checkTimeout();
        xMLStreamWriter.writeStartElement("PathService");
        if (this.pathService != null && this.pathService.getPathServiceAdmin() != null) {
            xMLStreamWriter.writeAttribute("running", String.valueOf(this.pathService.getPathServiceAdmin().isRunning()));
            xMLStreamWriter.writeAttribute("registered", String.valueOf(this.pathService.isRegistered()));
            if (this.pathService.getPathServiceAdmin().getPathMap() != null) {
                this.pathService.getPathServiceAdmin().getPathMap().dump(this, xMLStreamWriter);
            }
        }
        xMLStreamWriter.writeEndElement();
    }
}

