/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.path;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.naming.NamingException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.cache.lld.BaseCacheEntry;
import weblogic.cache.lld.ChangeListener;
import weblogic.common.CompletionListener;
import weblogic.common.CompletionRequest;
import weblogic.messaging.path.AsyncMap;
import weblogic.messaging.path.AsyncMapImpl;
import weblogic.messaging.path.ExceptionAdapter;
import weblogic.messaging.path.Key;
import weblogic.messaging.path.LegalMember;
import weblogic.messaging.path.PathServiceDiagnosticImageSource;
import weblogic.messaging.path.UpdatableMember;
import weblogic.messaging.path.helper.KeyString;
import weblogic.messaging.path.helper.PathHelper;
import weblogic.messaging.path.internal.PathObjectHandler;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;
import weblogic.store.PersistentMapAsyncTX;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreTransaction;
import weblogic.store.xa.PersistentStoreXA;

class PathServiceMap
extends AsyncMapImpl
implements AsyncMap {
    static final String MAP_CONNECTION_PREFIX = "weblogic.messaging.PathService.";
    HashMap createdMaps = new HashMap();
    private final PersistentStoreXA store;
    private ChangeListener invalidator;
    private final ExceptionAdapter exceptionAdapter;

    PathServiceMap(String string, PersistentStoreXA persistentStoreXA, ExceptionAdapter exceptionAdapter) {
        super(string, null, exceptionAdapter);
        this.store = persistentStoreXA;
        assert (persistentStoreXA != null);
        this.exceptionAdapter = exceptionAdapter;
        this.setInvalidator();
        if (PathHelper.PathSvcVerbose.isDebugEnabled()) {
            PathHelper.PathSvcVerbose.debug("PathService store: " + this.store + ", jndiName " + string);
        }
    }

    private void setInvalidator() {
        PathHelper.manager().register(true, this.jndiName, this);
        this.invalidator = PathHelper.manager().getDirtyCacheUpdaterMap(this.jndiName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PersistentMapAsyncTX mapByKey(Key key) throws PersistentStoreException {
        String string = PathServiceMap.mapNameFromKey(key);
        HashMap hashMap = this.createdMaps;
        synchronized (hashMap) {
            PersistentMapAsyncTX persistentMapAsyncTX = (PersistentMapAsyncTX)this.createdMaps.get(string);
            if (persistentMapAsyncTX != null) {
                return persistentMapAsyncTX;
            }
            persistentMapAsyncTX = this.store.createPersistentMap(string, PathObjectHandler.getObjectHandler(key.getSubsystem()));
            PersistentMapAsyncTX persistentMapAsyncTX2 = this.createdMaps.put(string, persistentMapAsyncTX);
            assert (persistentMapAsyncTX2 == null);
            return persistentMapAsyncTX;
        }
    }

    private static String mapNameFromKey(Key key) {
        return MAP_CONNECTION_PREFIX + key.getAssemblyId() + Key.RESERVED_SUBSYSTEMS[key.getSubsystem()];
    }

    static KeyString sampleKeyFromMapName(String string) {
        if (string.startsWith(MAP_CONNECTION_PREFIX)) {
            for (int i = 0; i < Key.RESERVED_SUBSYSTEMS.length; ++i) {
                if (!string.endsWith(Key.RESERVED_SUBSYSTEMS[i])) continue;
                String string2 = string.substring(MAP_CONNECTION_PREFIX.length(), string.length() - Key.RESERVED_SUBSYSTEMS[i].length());
                return new KeyString((byte)i, string2, string2);
            }
        }
        return null;
    }

    public void putIfAbsent(Object object, final Object object2, final CompletionRequest completionRequest) {
        PersistentMapAsyncTX persistentMapAsyncTX;
        if (PathHelper.PathSvcVerbose.isDebugEnabled()) {
            PathHelper.PathSvcVerbose.debug("PathService putIfAbsent key: " + object + ", value " + object2);
        }
        final Key key = (Key)object;
        try {
            persistentMapAsyncTX = this.mapByKey(key);
        }
        catch (PersistentStoreException persistentStoreException) {
            completionRequest.setResult((Object)this.exceptionAdapter.wrapException(persistentStoreException));
            return;
        }
        persistentMapAsyncTX.putIfAbsent((Object)key.getKeyId(), object2, (CompletionRequest)new CompReqListener(){

            public final void onException(CompletionRequest completionRequest2, Throwable throwable) {
                if (PathHelper.PathSvcVerbose.isDebugEnabled()) {
                    PathHelper.PathSvcVerbose.debug("PathService putIfAbsent key: " + key + ", value " + object2, throwable);
                }
                PathServiceMap.wrappedSetResult(completionRequest, throwable, PathServiceMap.this.exceptionAdapter);
            }

            public final void onCompletion(CompletionRequest completionRequest2, final Object object) {
                if (object == null || object.equals(object2)) {
                    PathServiceMap.wrappedSetResult(completionRequest, object, PathServiceMap.this.exceptionAdapter);
                    return;
                }
                if (!(object instanceof LegalMember)) {
                    PathServiceMap.wrappedSetResult(completionRequest, object, PathServiceMap.this.exceptionAdapter);
                    return;
                }
                ((LegalMember)object).isLegal(key, (LegalMember)object, new CompReqListener(){

                    public final void onException(CompletionRequest completionRequest, Throwable throwable) {
                        PathServiceMap.wrappedSetResult(completionRequest, throwable, PathServiceMap.this.exceptionAdapter);
                    }

                    public final void onCompletion(CompletionRequest completionRequest, Object object2) {
                        if (object2 == Boolean.TRUE) {
                            PathServiceMap.wrappedSetResult(completionRequest, object, PathServiceMap.this.exceptionAdapter);
                            return;
                        }
                        persistentMapAsyncTX.remove((Object)key.getKeyId(), object, (CompletionRequest)new CompReqListener(){

                            public final void onException(CompletionRequest completionRequest, Throwable throwable) {
                                PathServiceMap.wrappedSetResult(completionRequest, throwable, PathServiceMap.this.exceptionAdapter);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public final void onCompletion(CompletionRequest completionRequest, Object object) {
                                try {
                                    persistentMapAsyncTX.putIfAbsent((Object)key.getKeyId(), object2, (CompletionRequest)new CompReqListener(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        public final void onException(CompletionRequest completionRequest, Throwable throwable) {
                                            try {
                                                PathServiceMap.this.broadcastRemove(key);
                                                Object var4_3 = null;
                                            }
                                            catch (Throwable throwable2) {
                                                Object var4_4 = null;
                                                PathServiceMap.wrappedSetResult(completionRequest, throwable, PathServiceMap.this.exceptionAdapter);
                                                throw throwable2;
                                            }
                                            PathServiceMap.wrappedSetResult(completionRequest, throwable, PathServiceMap.this.exceptionAdapter);
                                        }

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        public final void onCompletion(CompletionRequest completionRequest, Object object) {
                                            try {
                                                if (object != null && !object.equals(object)) {
                                                    PathServiceMap.this.broadcastRemove(key);
                                                }
                                                Object var4_3 = null;
                                            }
                                            catch (Throwable throwable) {
                                                Object var4_4 = null;
                                                if (PathHelper.PathSvcVerbose.isDebugEnabled()) {
                                                    PathHelper.PathSvcVerbose.debug("PathService putIfAbsent key: " + key + ", value " + object2 + ", result " + object);
                                                }
                                                PathServiceMap.wrappedSetResult(completionRequest, object, PathServiceMap.this.exceptionAdapter);
                                                throw throwable;
                                            }
                                            if (PathHelper.PathSvcVerbose.isDebugEnabled()) {
                                                PathHelper.PathSvcVerbose.debug("PathService putIfAbsent key: " + key + ", value " + object2 + ", result " + object);
                                            }
                                            PathServiceMap.wrappedSetResult(completionRequest, object, PathServiceMap.this.exceptionAdapter);
                                        }
                                    });
                                }
                                catch (RuntimeException runtimeException) {
                                    boolean bl;
                                    CompletionRequest completionRequest2 = completionRequest;
                                    synchronized (completionRequest2) {
                                        bl = !completionRequest.hasResult();
                                    }
                                    if (bl) {
                                        completionRequest.setResult((Object)PathServiceMap.this.exceptionAdapter.wrapException(runtimeException));
                                    }
                                    throw runtimeException;
                                }
                                catch (Error error) {
                                    boolean bl;
                                    CompletionRequest completionRequest3 = completionRequest;
                                    synchronized (completionRequest3) {
                                        bl = !completionRequest.hasResult();
                                    }
                                    if (bl) {
                                        completionRequest.setResult((Object)PathServiceMap.this.exceptionAdapter.wrapException(error));
                                    }
                                    throw error;
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object object, Object object2, final CompletionRequest completionRequest) {
        try {
            PersistentMapAsyncTX persistentMapAsyncTX;
            final Key key = (Key)object;
            final UpdatableMember updatableMember = (UpdatableMember)object2;
            try {
                persistentMapAsyncTX = this.mapByKey(key);
            }
            catch (PersistentStoreException persistentStoreException) {
                completionRequest.setResult((Object)this.exceptionAdapter.wrapException(persistentStoreException));
                return;
            }
            final PersistentStoreTransaction persistentStoreTransaction = persistentMapAsyncTX.begin();
            persistentMapAsyncTX.putIfAbsent((Object)key.getKeyId(), (Object)updatableMember, persistentStoreTransaction, (CompletionRequest)new CompReqListener(){

                public final void onException(CompletionRequest completionRequest2, Throwable throwable) {
                    try {
                        persistentStoreTransaction.rollback();
                    }
                    catch (PersistentStoreException persistentStoreException) {
                        PathServiceMap.wrappedSetResult(completionRequest, (Object)persistentStoreException, PathServiceMap.this.exceptionAdapter);
                        return;
                    }
                    PathServiceMap.wrappedSetResult(completionRequest, throwable, PathServiceMap.this.exceptionAdapter);
                }

                public final void onCompletion(CompletionRequest completionRequest2, Object object) {
                    boolean bl;
                    UpdatableMember updatableMember2;
                    try {
                        updatableMember2 = (UpdatableMember)object;
                        bl = updatableMember2 == null || updatableMember2.equals(updatableMember);
                    }
                    catch (RuntimeException runtimeException) {
                        PathServiceMap.rollbackSameThreadSetResult(persistentStoreTransaction, completionRequest, runtimeException, PathServiceMap.this.exceptionAdapter);
                        throw runtimeException;
                    }
                    catch (Error error) {
                        PathServiceMap.rollbackSameThreadSetResult(persistentStoreTransaction, completionRequest, error, PathServiceMap.this.exceptionAdapter);
                        throw error;
                    }
                    if (bl) {
                        persistentStoreTransaction.commit(completionRequest);
                        return;
                    }
                    persistentMapAsyncTX.put((Object)key.getKeyId(), (Object)updatableMember, persistentStoreTransaction, (CompletionRequest)new CompReqListener(){

                        public final void onException(CompletionRequest completionRequest, Throwable throwable) {
                            try {
                                persistentStoreTransaction.rollback();
                            }
                            catch (PersistentStoreException persistentStoreException) {
                                PathServiceMap.wrappedSetResult(completionRequest, (Object)persistentStoreException, PathServiceMap.this.exceptionAdapter);
                                return;
                            }
                            PathServiceMap.wrappedSetResult(completionRequest, throwable, PathServiceMap.this.exceptionAdapter);
                        }

                        public final void onCompletion(CompletionRequest completionRequest, Object object) {
                            updatableMember2.update(key, updatableMember, new CompReqListener(){

                                public final void onException(CompletionRequest completionRequest, Throwable throwable) {
                                    try {
                                        updatableMember.updateException(throwable, key, updatableMember2, persistentStoreTransaction, completionRequest);
                                    }
                                    catch (RuntimeException runtimeException) {
                                        PathServiceMap.rollbackSameThreadSetResult(persistentStoreTransaction, completionRequest, runtimeException, PathServiceMap.this.exceptionAdapter);
                                        throw runtimeException;
                                    }
                                    catch (Error error) {
                                        PathServiceMap.rollbackSameThreadSetResult(persistentStoreTransaction, completionRequest, error, PathServiceMap.this.exceptionAdapter);
                                        throw error;
                                    }
                                }

                                public final void onCompletion(CompletionRequest completionRequest, Object object) {
                                    persistentStoreTransaction.commit((CompletionRequest)new CompReqListener(){

                                        public void onException(CompletionRequest completionRequest, Throwable throwable) {
                                            PathServiceMap.wrappedSetResult(completionRequest, throwable, PathServiceMap.this.exceptionAdapter);
                                        }

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        public void onCompletion(CompletionRequest completionRequest, Object object) {
                                            if (object == null) {
                                                object = Boolean.TRUE;
                                            }
                                            try {
                                                PathServiceMap.this.broadcastRemove(key);
                                                Object var4_3 = null;
                                            }
                                            catch (Throwable throwable) {
                                                Object var4_4 = null;
                                                PathServiceMap.wrappedSetResult(completionRequest, object, PathServiceMap.this.exceptionAdapter);
                                                throw throwable;
                                            }
                                            PathServiceMap.wrappedSetResult(completionRequest, object, PathServiceMap.this.exceptionAdapter);
                                        }
                                    });
                                }
                            });
                        }
                    });
                }
            });
        }
        catch (RuntimeException runtimeException) {
            boolean bl;
            CompletionRequest completionRequest2 = completionRequest;
            synchronized (completionRequest2) {
                bl = !completionRequest.hasResult();
            }
            if (bl) {
                completionRequest.setResult((Object)this.exceptionAdapter.wrapException(runtimeException));
            }
            throw runtimeException;
        }
        catch (Error error) {
            boolean bl;
            CompletionRequest completionRequest3 = completionRequest;
            synchronized (completionRequest3) {
                bl = !completionRequest.hasResult();
            }
            if (bl) {
                completionRequest.setResult((Object)this.exceptionAdapter.wrapException(error));
            }
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void wrappedSetResult(CompletionRequest completionRequest, Object object, ExceptionAdapter exceptionAdapter) {
        CompletionRequest completionRequest2 = completionRequest;
        synchronized (completionRequest2) {
            if (completionRequest.hasResult()) {
                return;
            }
        }
        if (object instanceof Throwable) {
            object = exceptionAdapter.wrapException((Throwable)object);
        }
        completionRequest.setResult(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void rollbackSameThreadSetResult(PersistentStoreTransaction persistentStoreTransaction, CompletionRequest completionRequest, Object object, ExceptionAdapter exceptionAdapter) {
        try {
            try {
                persistentStoreTransaction.rollback();
            }
            catch (PersistentStoreException persistentStoreException) {
                object = persistentStoreException;
                Object var6_5 = null;
                PathServiceMap.wrappedSetResult(completionRequest, object, exceptionAdapter);
                return;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            PathServiceMap.wrappedSetResult(completionRequest, object, exceptionAdapter);
            throw throwable;
        }
        PathServiceMap.wrappedSetResult(completionRequest, object, exceptionAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(Object object, CompletionRequest completionRequest) {
        try {
            Key key = (Key)object;
            this.mapByKey(key).get((Object)key.getKeyId(), completionRequest);
        }
        catch (PersistentStoreException persistentStoreException) {
            CompletionRequest completionRequest2 = completionRequest;
            synchronized (completionRequest2) {
                if (completionRequest.hasResult()) {
                    return;
                }
            }
            completionRequest.setResult((Object)this.exceptionAdapter.wrapException(persistentStoreException));
        }
        catch (RuntimeException runtimeException) {
            boolean bl;
            CompletionRequest completionRequest3 = completionRequest;
            synchronized (completionRequest3) {
                bl = !completionRequest.hasResult();
            }
            if (bl) {
                completionRequest.setResult((Object)this.exceptionAdapter.wrapException(runtimeException));
            }
            throw runtimeException;
        }
        catch (Error error) {
            boolean bl;
            CompletionRequest completionRequest4 = completionRequest;
            synchronized (completionRequest4) {
                bl = !completionRequest.hasResult();
            }
            if (bl) {
                completionRequest.setResult((Object)this.exceptionAdapter.wrapException(error));
            }
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object object, final Object object2, final CompletionRequest completionRequest) {
        try {
            if (PathHelper.PathSvcVerbose.isDebugEnabled()) {
                PathHelper.PathSvcVerbose.debug("PathService remove key: " + object + ", value " + object2);
            }
            final Key key = (Key)object;
            this.mapByKey(key).remove((Object)key.getKeyId(), object2, (CompletionRequest)new CompReqListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void onException(CompletionRequest completionRequest2, Throwable throwable) {
                    try {
                        PathServiceMap.this.broadcastRemove(key);
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var4_4 = null;
                        PathServiceMap.wrappedSetResult(completionRequest, throwable, PathServiceMap.this.exceptionAdapter);
                        throw throwable2;
                    }
                    PathServiceMap.wrappedSetResult(completionRequest, throwable, PathServiceMap.this.exceptionAdapter);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void onCompletion(CompletionRequest completionRequest2, Object object) {
                    try {
                        if (object == Boolean.TRUE) {
                            PathServiceMap.this.broadcastRemove(key);
                        }
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        if (PathHelper.PathSvcVerbose.isDebugEnabled()) {
                            PathHelper.PathSvcVerbose.debug("PathService remove key: " + key + ", value " + object2 + ", result " + object);
                        }
                        PathServiceMap.wrappedSetResult(completionRequest, object, PathServiceMap.this.exceptionAdapter);
                        throw throwable;
                    }
                    if (PathHelper.PathSvcVerbose.isDebugEnabled()) {
                        PathHelper.PathSvcVerbose.debug("PathService remove key: " + key + ", value " + object2 + ", result " + object);
                    }
                    PathServiceMap.wrappedSetResult(completionRequest, object, PathServiceMap.this.exceptionAdapter);
                }
            });
        }
        catch (PersistentStoreException persistentStoreException) {
            CompletionRequest completionRequest2 = completionRequest;
            synchronized (completionRequest2) {
                if (completionRequest.hasResult()) {
                    return;
                }
            }
            completionRequest.setResult((Object)this.exceptionAdapter.wrapException(persistentStoreException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastRemove(Key key) {
        block5: {
            try {
                try {
                    PathHelper.manager().cachedRemove(this.jndiName, key, null, 520);
                }
                catch (NamingException namingException) {
                    PathHelper.PathSvcVerbose.debug(namingException.getMessage(), (Throwable)namingException);
                    Object var4_3 = null;
                    this.invalidator.onDelete(new BaseCacheEntry<Key, Object>(key, null));
                    break block5;
                }
                catch (PathHelper.PathServiceException pathServiceException) {
                    PathHelper.PathSvcVerbose.debug(pathServiceException.getMessage(), (Throwable)pathServiceException);
                    Object var4_4 = null;
                    this.invalidator.onDelete(new BaseCacheEntry<Key, Object>(key, null));
                }
                Object var4_2 = null;
                this.invalidator.onDelete(new BaseCacheEntry<Key, Object>(key, null));
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.invalidator.onDelete(new BaseCacheEntry<Key, Object>(key, null));
                throw throwable;
            }
        }
    }

    public PersistentStoreXA getStore() {
        return this.store;
    }

    public void dump(PathServiceDiagnosticImageSource pathServiceDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws DiagnosticImageTimeoutException, XMLStreamException, PersistentStoreException {
        KeyString keyString;
        pathServiceDiagnosticImageSource.checkTimeout();
        xMLStreamWriter.writeStartElement("Map");
        xMLStreamWriter.writeAttribute("jndiName", this.getJndiName());
        xMLStreamWriter.writeAttribute("storeName", this.store.getName());
        xMLStreamWriter.writeStartElement("Assemblies");
        Iterator iterator = this.store.getMapConnectionNames();
        ArrayList<KeyString> arrayList = new ArrayList<KeyString>();
        while (iterator.hasNext()) {
            keyString = PathServiceMap.sampleKeyFromMapName((String)iterator.next());
            if (keyString == null) continue;
            arrayList.add(keyString);
        }
        xMLStreamWriter.writeAttribute("count", String.valueOf(arrayList.size()));
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            pathServiceDiagnosticImageSource.checkTimeout();
            keyString = (KeyString)iterator.next();
            xMLStreamWriter.writeStartElement("Assembly");
            xMLStreamWriter.writeAttribute("name", keyString.getAssemblyId() + keyString.getSubsystem());
            PersistentMapAsyncTX persistentMapAsyncTX = this.mapByKey(keyString);
            Set set = persistentMapAsyncTX.keySet();
            xMLStreamWriter.writeStartElement("Keys");
            if (set == null || set.size() == 0) {
                xMLStreamWriter.writeAttribute("count", "0");
            } else {
                xMLStreamWriter.writeAttribute("count", String.valueOf(set.size()));
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    xMLStreamWriter.writeStartElement("Key");
                    Object e = iterator2.next();
                    xMLStreamWriter.writeCharacters(e.toString());
                    xMLStreamWriter.writeEndElement();
                }
            }
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    class SubsystemInfo {
        String name;
        int index;

        SubsystemInfo(String string, int n) {
            this.name = string;
            this.index = n;
        }
    }

    private static abstract class CompReqListener
    extends CompletionRequest
    implements CompletionListener {
        CompReqListener() {
            this.addListener(this);
        }
    }
}

