/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.path.helper;

import java.io.Serializable;
import java.rmi.RemoteException;
import weblogic.common.CompletionRequest;
import weblogic.messaging.path.AsyncMap;
import weblogic.messaging.path.AsyncMapRemote;
import weblogic.messaging.path.CompletionAsyncResultAdapter;
import weblogic.messaging.path.ExceptionAdapter;
import weblogic.messaging.path.helper.PathHelper;

class AsyncMapRemoteAdapter
implements AsyncMap {
    private final String jndiName;
    private final AsyncMapRemote asyncMapRemote;
    private final ExceptionAdapter exceptionAdapter;

    AsyncMapRemoteAdapter(String string, AsyncMapRemote asyncMapRemote, ExceptionAdapter exceptionAdapter) {
        this.jndiName = string;
        this.asyncMapRemote = asyncMapRemote;
        this.exceptionAdapter = exceptionAdapter;
    }

    private void emergencyClose(Exception exception) {
        PathHelper.manager().handleException(exception, this.jndiName, this);
    }

    public void putIfAbsent(Object object, Object object2, CompletionRequest completionRequest) {
        if (PathHelper.PathSvcVerbose.isDebugEnabled()) {
            PathHelper.PathSvcVerbose.debug("RemoteAdapter Key:" + object + ", value:" + object2);
        }
        try {
            this.asyncMapRemote.putIfAbsent((Serializable)object, (Serializable)object2, new RemoteCatcher(completionRequest).getCallbackableResult());
        }
        catch (RuntimeException runtimeException) {
            AsyncMapRemoteAdapter.notifyCaller(completionRequest, runtimeException, this.exceptionAdapter);
            throw runtimeException;
        }
        catch (Error error) {
            AsyncMapRemoteAdapter.notifyCaller(completionRequest, error, this.exceptionAdapter);
            throw error;
        }
        catch (RemoteException remoteException) {
            this.emergencyClose(remoteException);
            AsyncMapRemoteAdapter.notifyCaller(completionRequest, remoteException, this.exceptionAdapter);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyCaller(CompletionRequest completionRequest, Throwable throwable, ExceptionAdapter exceptionAdapter) {
        CompletionRequest completionRequest2 = completionRequest;
        synchronized (completionRequest2) {
            if (completionRequest.hasResult()) {
                return;
            }
        }
        completionRequest.setResult((Object)exceptionAdapter.wrapException(throwable));
    }

    public void put(Object object, Object object2, CompletionRequest completionRequest) {
        try {
            this.asyncMapRemote.put((Serializable)object, (Serializable)object2, new RemoteCatcher(completionRequest).getCallbackableResult());
        }
        catch (RuntimeException runtimeException) {
            AsyncMapRemoteAdapter.notifyCaller(completionRequest, runtimeException, this.exceptionAdapter);
            throw runtimeException;
        }
        catch (Error error) {
            AsyncMapRemoteAdapter.notifyCaller(completionRequest, error, this.exceptionAdapter);
            throw error;
        }
        catch (RemoteException remoteException) {
            this.emergencyClose(remoteException);
            AsyncMapRemoteAdapter.notifyCaller(completionRequest, remoteException, this.exceptionAdapter);
            return;
        }
    }

    public void get(Object object, CompletionRequest completionRequest) {
        try {
            this.asyncMapRemote.get((Serializable)object, new RemoteCatcher(completionRequest).getCallbackableResult());
        }
        catch (RuntimeException runtimeException) {
            AsyncMapRemoteAdapter.notifyCaller(completionRequest, runtimeException, this.exceptionAdapter);
            throw runtimeException;
        }
        catch (Error error) {
            AsyncMapRemoteAdapter.notifyCaller(completionRequest, error, this.exceptionAdapter);
            throw error;
        }
        catch (RemoteException remoteException) {
            this.emergencyClose(remoteException);
            AsyncMapRemoteAdapter.notifyCaller(completionRequest, remoteException, this.exceptionAdapter);
            return;
        }
    }

    public void remove(Object object, Object object2, CompletionRequest completionRequest) {
        try {
            this.asyncMapRemote.remove((Serializable)object, (Serializable)object2, new RemoteCatcher(completionRequest).getCallbackableResult());
        }
        catch (RuntimeException runtimeException) {
            AsyncMapRemoteAdapter.notifyCaller(completionRequest, runtimeException, this.exceptionAdapter);
            throw runtimeException;
        }
        catch (Error error) {
            AsyncMapRemoteAdapter.notifyCaller(completionRequest, error, this.exceptionAdapter);
            throw error;
        }
        catch (RemoteException remoteException) {
            this.emergencyClose(remoteException);
            AsyncMapRemoteAdapter.notifyCaller(completionRequest, remoteException, this.exceptionAdapter);
            return;
        }
    }

    private class RemoteCatcher
    extends CompletionAsyncResultAdapter {
        AsyncMapRemoteAdapter remoteAdapter;

        RemoteCatcher(CompletionRequest completionRequest) {
            super(completionRequest);
            this.remoteAdapter = AsyncMapRemoteAdapter.this;
        }

        void exceptionMonitor(Throwable throwable) {
            if (throwable instanceof RemoteException) {
                this.remoteAdapter.emergencyClose((RemoteException)throwable);
            }
        }
    }
}

