/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.path.helper;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import weblogic.messaging.path.Key;
import weblogic.messaging.saf.utils.SAFClientUtil;

public class KeySerializable
implements Key,
Externalizable {
    static final long serialVersionUID = 7635946436418512920L;
    private Serializable id;
    private String assembly;
    private byte subsystem;
    private static int EXTVERSION = 1;
    private static int VERSION_MASK = 255;
    private static int FLAG_CLUSTER = 256;

    public KeySerializable(byte by, String string, Serializable serializable) {
        assert (string != null && by > -1 && by < Key.RESERVED_SUBSYSTEMS.length);
        this.subsystem = by;
        this.assembly = string;
        this.id = serializable;
        Comparable comparable = (Comparable)((Object)this.id);
    }

    public KeySerializable() {
    }

    public byte getSubsystem() {
        return this.subsystem;
    }

    public String getAssemblyId() {
        return this.assembly;
    }

    public Serializable getKeyId() {
        return this.id;
    }

    public int hashCode() {
        return this.assembly.hashCode() ^ this.id.hashCode() ^ this.subsystem;
    }

    public String toString() {
        return this.id + "^" + this.subsystem + "^" + this.assembly;
    }

    public boolean equals(Object object) {
        if (!(object instanceof KeySerializable)) {
            return false;
        }
        KeySerializable keySerializable = (KeySerializable)object;
        return keySerializable == this || this.subsystem == keySerializable.subsystem && (this.assembly == keySerializable.assembly || this.assembly.equals(keySerializable.assembly)) && (this.id == keySerializable.id || this.id.equals(keySerializable.id));
    }

    public int compareTo(Object object) {
        Key key = (Key)object;
        int n = ((Comparable)((Object)this.id)).compareTo(key.getKeyId());
        if (n != 0) {
            return n;
        }
        n = this.assembly.compareTo(key.getAssemblyId());
        if (n != 0) {
            return n;
        }
        return this.subsystem - key.getSubsystem();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = EXTVERSION;
        if (this.assembly == "CLUSTER") {
            n |= FLAG_CLUSTER;
        }
        objectOutput.writeInt(n);
        objectOutput.writeObject(this.id);
        objectOutput.writeByte(this.subsystem);
        if (this.assembly != "CLUSTER") {
            objectOutput.writeUTF(this.assembly);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & VERSION_MASK;
        if (n2 != EXTVERSION) {
            throw SAFClientUtil.versionIOException(n2, EXTVERSION, EXTVERSION);
        }
        this.id = (Serializable)objectInput.readObject();
        this.subsystem = objectInput.readByte();
        this.assembly = (n & FLAG_CLUSTER) == 0 ? objectInput.readUTF() : "CLUSTER";
    }
}

