/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.path.helper;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import weblogic.messaging.path.Key;
import weblogic.messaging.saf.utils.SAFClientUtil;

public class KeyString
implements Key,
Externalizable {
    static final long serialVersionUID = -6246813907189434496L;
    private String id;
    private String assembly;
    private byte subsystem;
    private static int EXTVERSION = 1;
    private static int VERSION_MASK = 255;
    private static int FLAG_CLUSTER = 256;

    public KeyString(byte by, String string, String string2) {
        assert (by > -1 && by < Key.RESERVED_SUBSYSTEMS.length);
        this.subsystem = by;
        this.assembly = string.intern();
        this.id = string2.intern();
    }

    public KeyString() {
    }

    public byte getSubsystem() {
        return this.subsystem;
    }

    public String getAssemblyId() {
        return this.assembly;
    }

    public Serializable getKeyId() {
        return this.id;
    }

    public String getStringId() {
        return this.id;
    }

    public int hashCode() {
        return this.assembly.hashCode() ^ this.id.hashCode() ^ this.subsystem;
    }

    public String toString() {
        return this.id + "^" + this.subsystem + "^" + this.assembly;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Key)) {
            return false;
        }
        Key key = (Key)object;
        return key == this || this.subsystem == key.getSubsystem() && (this.assembly == key.getAssemblyId() || this.assembly.equals(key.getAssemblyId())) && (this.id == key.getKeyId() || this.id.equals(key.getKeyId()));
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        Key key = (Key)object;
        int n = this.id.compareTo(key.getKeyId());
        if (n != 0) {
            return n;
        }
        n = this.assembly.compareTo(key.getAssemblyId());
        if (n != 0) {
            return n;
        }
        return this.subsystem - key.getSubsystem();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = EXTVERSION;
        if (this.assembly == "CLUSTER") {
            n |= FLAG_CLUSTER;
        }
        objectOutput.writeInt(n);
        objectOutput.writeUTF(this.id);
        if (this.assembly != "CLUSTER") {
            objectOutput.writeUTF(this.assembly);
        }
        objectOutput.writeByte(this.subsystem);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & VERSION_MASK;
        if (n2 != EXTVERSION) {
            throw SAFClientUtil.versionIOException(n2, EXTVERSION, EXTVERSION);
        }
        this.id = objectInput.readUTF();
        this.assembly = (n & FLAG_CLUSTER) == 0 ? objectInput.readUTF().intern() : "CLUSTER";
        this.subsystem = objectInput.readByte();
    }
}

