/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.path.helper;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import weblogic.messaging.path.Member;
import weblogic.messaging.saf.utils.SAFClientUtil;

public class MemberString
implements Member,
Externalizable {
    static final long serialVersionUID = -5685689480293580262L;
    protected String id;
    protected String serverName;
    protected long timestamp;
    protected int generation;
    private static int lastGeneration;
    private static int EXTVERSION;
    private static int VERSION_MASK;
    private static int FLAG_ID_SERVER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemberString(String string, String string2) {
        assert (string != null && string2 != null);
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.timestamp = System.currentTimeMillis();
            this.generation = lastGeneration++;
        }
        this.id = string.intern();
        this.serverName = string2 == this.id || string2.equals(this.id) ? this.id : string2.intern();
    }

    public MemberString() {
    }

    public Serializable getMemberId() {
        return this.id;
    }

    public String getStringId() {
        return this.id;
    }

    public String getWLServerName() {
        return this.serverName;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public int getGeneration() {
        return this.generation;
    }

    public int hashCode() {
        return this.id.hashCode() ^ this.serverName.hashCode();
    }

    public String toString() {
        return this.id + "^" + this.serverName + "^" + this.generation + "^" + this.timestamp;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Member)) {
            return false;
        }
        Member member = (Member)object;
        return member == this || this.timestamp == member.getTimeStamp() && this.generation == member.getGeneration() && this.id.equals(member.getMemberId()) && this.serverName.equals(member.getWLServerName());
    }

    public int compareTo(Object object) {
        Member member = (Member)object;
        int n = this.id.compareTo((String)((Object)member.getMemberId()));
        if (n != 0) {
            return n;
        }
        n = this.serverName.compareTo(member.getWLServerName());
        if (n != 0) {
            return n;
        }
        long l = this.timestamp - member.getTimeStamp();
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        return this.generation - member.getGeneration();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = EXTVERSION;
        if (this.id == this.serverName || this.id.equals(this.serverName)) {
            n |= FLAG_ID_SERVER;
        }
        objectOutput.writeInt(n);
        objectOutput.writeInt(this.generation);
        objectOutput.writeLong(this.timestamp);
        objectOutput.writeUTF(this.id);
        if ((n & FLAG_ID_SERVER) == 0) {
            objectOutput.writeUTF(this.serverName);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & VERSION_MASK;
        if (n2 != EXTVERSION) {
            throw SAFClientUtil.versionIOException(n2, EXTVERSION, EXTVERSION);
        }
        this.generation = objectInput.readInt();
        this.timestamp = objectInput.readLong();
        this.id = objectInput.readUTF().intern();
        this.serverName = (n & FLAG_ID_SERVER) == 0 ? objectInput.readUTF().intern() : this.id;
    }

    static {
        EXTVERSION = 1;
        VERSION_MASK = 255;
        FLAG_ID_SERVER = 256;
    }
}

