/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.path.helper;

import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import weblogic.cache.lld.ChangeListener;
import weblogic.cache.lld.LLDFactory;
import weblogic.cache.utils.ExpiredMap;
import weblogic.cluster.ClusterService;
import weblogic.common.CompletionListener;
import weblogic.common.CompletionRequest;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.health.LowMemoryNotificationService;
import weblogic.health.MemoryEvent;
import weblogic.health.MemoryListener;
import weblogic.jms.extensions.JMSOrderException;
import weblogic.jndi.Environment;
import weblogic.messaging.path.AsyncMap;
import weblogic.messaging.path.AsyncMapRemote;
import weblogic.messaging.path.ExceptionAdapter;
import weblogic.messaging.path.Key;
import weblogic.messaging.path.Member;
import weblogic.messaging.path.helper.AsyncMapRemoteAdapter;
import weblogic.rjvm.PeerGoneException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.TxHelper;
import weblogic.utils.collections.ConcurrentHashMap;

public class PathHelper {
    public static final DebugLogger PathSvc = DebugLogger.getDebugLogger((String)"DebugPathSvc");
    public static final DebugLogger PathSvcVerbose = DebugLogger.getDebugLogger((String)"DebugPathSvcVerbose");
    public static boolean retired = false;
    private static Object lock = new Object();
    private HashMap servers = new HashMap();
    private static ServerInfo clusterServerInfo;
    public static final int QOS_CLEAR_CACHE = 8;
    public static final int QOS_OWNED_CACHE = 64;
    public static final int QOS_DIRTY_CACHE = 512;
    public static final int QOS_STORE = 32768;
    public static final int QOS_CACHE_ON_EQUAL = 16384;
    private static final int QOS_local = 584;
    private static PathHelper THE_ONE;
    public static String DEFAULT_PATH_SERVICE_JNDI;
    private static final JMSOrderExceptionAdapter jmsOrderExceptionAdapter;
    private TransactionManager tranManager = TxHelper.getTransactionManager();
    private static final int Retry_Put_If_Absent = 0;
    private static final int Retry_Remove = 1;
    private static final int Retry_Put = 2;
    private static final int Retry_Get = 3;
    private static final String PATH_SERVICE = "BEA.PathService";

    private PathHelper() {
    }

    public static PathHelper manager() {
        return THE_ONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cachedGet(String string, Key key, int n, CompletionRequest completionRequest) throws NamingException {
        Transaction transaction = this.tranManager.forceSuspend();
        try {
            this.cachedGetNoTx(string, key, n, completionRequest);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.tranManager.forceResume(transaction);
            throw throwable;
        }
        this.tranManager.forceResume(transaction);
    }

    private void cachedGetNoTx(String string, Key key, int n, CompletionRequest completionRequest) throws NamingException {
        Object object;
        ServerInfo serverInfo = this.createServerInfo(string);
        if ((0x248 & n) != 0 && (object = this.useCache(serverInfo, key, n)) != null) {
            completionRequest.setResult(object);
            return;
        }
        if ((0x8000 & n) != 0) {
            object = this.lookupAsyncMap(string, serverInfo);
            int n2 = n & 0xFFFF7FF7;
            CompletionRequest completionRequest2 = n2 != 0 ? this.updateCacheCR(serverInfo, key, null, n2, completionRequest) : completionRequest;
            object.get(key, new RetryOnce(3, string, key, null, (AsyncMap)object, completionRequest2));
        } else {
            completionRequest.setResult(null);
        }
    }

    public final Member cachedGet(String string, Key key, int n) throws Throwable {
        Object object;
        ServerInfo serverInfo = this.createServerInfo(string);
        if ((0x248 & n) != 0 && (object = this.useCache(serverInfo, key, n)) != null) {
            return object;
        }
        if ((0x8000 & n) != 0) {
            object = this.lookupAsyncMap(string, serverInfo);
            int n2 = n & 0xFFFF7FF7;
            CompletionRequest completionRequest = n2 != 0 ? this.updateCacheCR(serverInfo, key, null, n2, null) : new CompletionRequest();
            object.get(key, new RetryOnce(3, string, key, null, (AsyncMap)object, completionRequest));
            return (Member)completionRequest.getResult();
        }
        return null;
    }

    public final void cachedRemove(String string, Key key, Member member, int n, CompletionRequest completionRequest) throws NamingException {
        ServerInfo serverInfo = this.createServerInfo(string);
        if ((0x8000 & n) != 0) {
            n |= 0x248;
        }
        Member member2 = this.useCache(serverInfo, key, n);
        if ((0x8000 & n) == 0) {
            completionRequest.setResult((Object)member2);
            return;
        }
        AsyncMap asyncMap = this.lookupAsyncMap(string, serverInfo);
        asyncMap.remove(key, member, new RetryOnce(1, string, key, member, asyncMap, completionRequest));
    }

    public final boolean cachedRemove(String string, Key key, Member member, int n) throws NamingException, PathServiceException {
        ServerInfo serverInfo = this.createServerInfo(string);
        if ((0x8000 & n) != 0) {
            n |= 0x248;
        }
        Member member2 = this.useCache(serverInfo, key, n);
        if ((0x8000 & n) == 0) {
            return member2 != null;
        }
        CompletionRequest completionRequest = new CompletionRequest();
        AsyncMap asyncMap = this.lookupAsyncMap(string, serverInfo);
        asyncMap.remove(key, member, new RetryOnce(1, string, key, member, asyncMap, completionRequest));
        try {
            return Boolean.TRUE == completionRequest.getResult();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new PathServiceException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cachedPutIfAbsent(String string, Key key, Member member, int n, CompletionRequest completionRequest) throws NamingException {
        Transaction transaction = this.tranManager.forceSuspend();
        try {
            this.cachedPutIfAbsentNoTx(string, key, member, n, completionRequest);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.tranManager.forceResume(transaction);
            throw throwable;
        }
        this.tranManager.forceResume(transaction);
    }

    private void cachedPutIfAbsentNoTx(String string, Key key, Member member, int n, CompletionRequest completionRequest) throws NamingException {
        Object object;
        ServerInfo serverInfo = this.createServerInfo(string);
        if ((0x248 & n) != 0) {
            object = this.useCache(serverInfo, key, n);
            if ((0x8000 & n) == 0) {
                if ((0x200 & n) != 0) {
                    completionRequest.setResult((Object)serverInfo.dirtyPutIfAbsent(key, member));
                } else if ((0x40 & n) != 0) {
                    completionRequest.setResult((Object)serverInfo.ownedPutIfAbsent(key, member));
                }
                return;
            }
            if (object != null) {
                completionRequest.setResult(object);
                return;
            }
        }
        if ((0x8000 & n) != 0) {
            object = this.lookupAsyncMap(string, serverInfo);
            int n2 = n & 0xFFFF7FF7;
            CompletionRequest completionRequest2 = n2 != 0 ? this.updateCacheCR(serverInfo, key, member, n2, completionRequest) : completionRequest;
            object.putIfAbsent(key, member, new RetryOnce(0, string, key, member, (AsyncMap)object, completionRequest2));
        } else {
            completionRequest.setResult(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void update(String string, Key key, Member member, CompletionRequest completionRequest) throws NamingException {
        Transaction transaction = this.tranManager.forceSuspend();
        try {
            this.updateNoTx(string, key, member, completionRequest);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.tranManager.forceResume(transaction);
            throw throwable;
        }
        this.tranManager.forceResume(transaction);
    }

    private void updateNoTx(String string, Key key, Member member, CompletionRequest completionRequest) throws NamingException {
        ServerInfo serverInfo = this.createServerInfo(string);
        this.useCache(serverInfo, key, 584);
        AsyncMap asyncMap = this.lookupAsyncMap(string, serverInfo);
        asyncMap.put(key, member, new RetryOnce(2, string, key, member, asyncMap, completionRequest));
    }

    private CompletionRequest updateCacheCR(final ServerInfo serverInfo, final Key key, final Member member, final int n, CompletionRequest completionRequest) {
        return new UpdateCache(completionRequest){

            public void onException(CompletionRequest completionRequest, Throwable throwable) {
                if (this.userCompletionRequest != null) {
                    this.userCompletionRequest.setResult((Object)throwable);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCompletion(CompletionRequest completionRequest, Object object) {
                if ((0x200 & n) != 0) {
                    if (object == null && member == null || (0x4000 & n) != 0 && !member.equals(object)) {
                        serverInfo.dirtyRemove(key);
                    } else {
                        serverInfo.dirtyPut(key, object == null ? member : (Member)object);
                    }
                } else if ((0x40 & n) != 0) {
                    if (object == null && member == null || (0x4000 & n) != 0 && !member.equals(object)) {
                        serverInfo.ownedRemove(key);
                    } else {
                        serverInfo.ownedPut(key, object == null ? member : (Member)object);
                    }
                }
                if (this.userCompletionRequest != null) {
                    block11: {
                        boolean bl = this.userCompletionRequest.runListenersInSetResult(true);
                        try {
                            this.userCompletionRequest.setResult(object);
                            Object var5_4 = null;
                            if (!bl) break block11;
                            return;
                        }
                        catch (Throwable throwable) {
                            Object var5_5 = null;
                            if (bl) {
                                return;
                            }
                            this.userCompletionRequest.runListenersInSetResult(false);
                            throw throwable;
                        }
                    }
                    this.userCompletionRequest.runListenersInSetResult(false);
                    {
                    }
                }
            }
        };
    }

    private Member useCache(ServerInfo serverInfo, Key key, int n) {
        Member member;
        Member member2;
        if ((0x40 & n) != 0) {
            if ((8 & n) != 0) {
                member2 = serverInfo.ownedRemove(key);
            } else {
                member2 = serverInfo.ownedGet(key);
                if (member2 != null) {
                    return member2;
                }
            }
        } else {
            member2 = null;
        }
        if ((0x200 & n) != 0) {
            if ((8 & n) != 0) {
                member = serverInfo.dirtyRemove(key);
            } else {
                member = serverInfo.dirtyGet(key);
                if (member != null) {
                    return member;
                }
            }
        } else {
            member = null;
        }
        return member2 == null ? member : member2;
    }

    private static String broadcastJndiName(String string) {
        return PATH_SERVICE + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeListener getDirtyCacheUpdaterMap(String string) {
        Object object = lock;
        synchronized (object) {
            return ((ServerInfo)this.servers.get(string)).invalidator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerInfo findServerInfo(String string) {
        Object object = lock;
        synchronized (object) {
            return (ServerInfo)this.servers.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncMap lookupAsyncMap(String string, ServerInfo serverInfo) throws NamingException {
        AsyncMap asyncMap = serverInfo.delegate;
        if (asyncMap != null) {
            return asyncMap;
        }
        Object object = lock;
        synchronized (object) {
            asyncMap = serverInfo.delegate;
            if (asyncMap != null) {
                return asyncMap;
            }
            asyncMap = new AsyncMapRemoteAdapter(string, (AsyncMapRemote)this.jndiLookup(string), PathHelper.jmsOrderExceptionAdapter());
            serverInfo.delegate = asyncMap;
            return asyncMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object jndiLookup(String string) throws NamingException {
        Object object;
        Environment environment = new Environment();
        environment.setCreateIntermediateContexts(true);
        environment.setReplicateBindings(true);
        Context context = environment.getInitialContext();
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        SecurityServiceManager.pushSubject((AuthenticatedSubject)authenticatedSubject, (AuthenticatedSubject)authenticatedSubject);
        try {
            object = context.lookup(string);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            SecurityServiceManager.popSubject((AuthenticatedSubject)authenticatedSubject);
            throw throwable;
        }
        SecurityServiceManager.popSubject((AuthenticatedSubject)authenticatedSubject);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerInfo createServerInfo(String string) throws NamingException {
        Object object = lock;
        synchronized (object) {
            ServerInfo serverInfo = (ServerInfo)this.servers.get(string);
            if (serverInfo != null) {
                return serverInfo;
            }
            AsyncMapRemote asyncMapRemote = (AsyncMapRemote)this.jndiLookup(string);
            serverInfo = new ServerInfo(string, new AsyncMapRemoteAdapter(string, asyncMapRemote, PathHelper.jmsOrderExceptionAdapter()));
            ServerInfo serverInfo2 = this.servers.put(string, serverInfo);
            if (serverInfo2 == null) {
                return serverInfo;
            }
            serverInfo2.delegate = serverInfo.delegate;
            this.servers.put(string, serverInfo2);
            return serverInfo2;
        }
    }

    public static JMSOrderExceptionAdapter jmsOrderExceptionAdapter() {
        return jmsOrderExceptionAdapter;
    }

    public static Throwable wrapExtensionImpl(Throwable throwable) {
        if (throwable == null || throwable instanceof RuntimeException || throwable instanceof Error || throwable instanceof JMSOrderException) {
            return throwable;
        }
        return new JMSOrderException(throwable.getMessage(), throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(boolean bl, String string, AsyncMap asyncMap) {
        ServerInfo serverInfo;
        ServerInfo serverInfo2;
        ServerInfo serverInfo3 = null;
        Object object = lock;
        synchronized (object) {
            if (bl) {
                serverInfo3 = new ServerInfo(string, asyncMap);
            }
            serverInfo2 = clusterServerInfo;
            clusterServerInfo = serverInfo3;
            serverInfo = bl ? this.servers.put(string, serverInfo3) : (ServerInfo)this.servers.remove(string);
        }
        if (bl) {
            if (serverInfo2 != null || serverInfo != null) {
                PathSvc.debug("\n\nPathService double registration? remote and local? " + string, (Throwable)new Exception("debug deploy PathService" + serverInfo2 + serverInfo));
            }
        } else if (serverInfo2 != null && serverInfo2.delegate != asyncMap || serverInfo != null && serverInfo.delegate != asyncMap) {
            PathSvc.debug("\n\nPathService double unregistration? remote and local? " + string, (Throwable)new Exception("debug deploy PathService" + serverInfo2 + serverInfo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegister(String string) {
        Object object = lock;
        synchronized (object) {
            ServerInfo serverInfo = (ServerInfo)this.servers.remove(string);
            if (serverInfo == null || serverInfo.invalidator == null) {
                return;
            }
            serverInfo.dirty.clear();
            serverInfo.invalidator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Exception exception, String string, AsyncMap asyncMap) {
        if (asyncMap instanceof AsyncMapRemoteAdapter && exception instanceof RemoteException) {
            Object object = lock;
            synchronized (object) {
                ServerInfo serverInfo = this.findServerInfo(string);
                if (serverInfo == null || serverInfo.delegate != asyncMap) {
                    return;
                }
                this.unRegister(string);
            }
        }
    }

    static {
        THE_ONE = new PathHelper();
        DEFAULT_PATH_SERVICE_JNDI = "weblogic.PathService.default";
        jmsOrderExceptionAdapter = new JMSOrderExceptionAdapter();
    }

    private class LowMemoryForgetfulMap
    implements Map,
    MemoryListener {
        private int LOWMEM_SIZE = 4096;
        private int NORMAL_SIZE = 0x100000;
        private long LOWMEM_DELAY = 60000L;
        private long NORMAL_DELAY = 480000L;
        private long currentDelay;
        private int currentSize;
        ExpiredMap expiredMap;

        LowMemoryForgetfulMap() {
            LowMemoryNotificationService.addMemoryListener(this);
            this.normalUOOMemory();
            this.allocateNormal();
        }

        private void allocateNormal() {
            this.expiredMap = new ExpiredMap(this.currentSize, new HashMap(16), this.currentDelay);
        }

        private void normalUOOMemory() {
            this.currentSize = this.NORMAL_SIZE;
            this.currentDelay = this.NORMAL_DELAY;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void memoryChanged(MemoryEvent memoryEvent) {
            if (memoryEvent.getEventType() == 1) {
                ExpiredMap expiredMap = this.expiredMap;
                synchronized (expiredMap) {
                    this.currentSize = this.LOWMEM_SIZE;
                    this.currentDelay = this.LOWMEM_DELAY;
                    this.expiredMap.clear();
                    this.allocateNormal();
                }
            }
            if (memoryEvent.getEventType() == 0) {
                ExpiredMap expiredMap = this.expiredMap;
                synchronized (expiredMap) {
                    ExpiredMap expiredMap2 = this.expiredMap;
                    this.normalUOOMemory();
                    this.allocateNormal();
                    if (expiredMap2.size() > 0) {
                        this.expiredMap.putAll((Map)expiredMap2);
                    }
                }
            }
        }

        public int size() {
            return this.expiredMap.size();
        }

        public boolean isEmpty() {
            return this.expiredMap.isEmpty();
        }

        public boolean containsKey(Object object) {
            return this.expiredMap.containsKey(object);
        }

        public boolean equals(Object object) {
            return this.expiredMap.equals(object);
        }

        public int hashCode() {
            return this.expiredMap.hashCode();
        }

        public void putAll(Map map) {
            this.expiredMap.putAll(map);
        }

        public Object clone() {
            return this.expiredMap.clone();
        }

        public void clear() {
            this.expiredMap.clear();
        }

        public boolean containsValue(Object object) {
            return this.expiredMap.containsValue(object);
        }

        public Object get(Object object) {
            return this.expiredMap.get(object);
        }

        public Object put(Object object, Object object2) {
            return this.expiredMap.put(object, object2);
        }

        public Object putIfAbsent(Object object, Object object2) {
            return this.expiredMap.putIfAbsent(object, object2);
        }

        public Object remove(Object object) {
            return this.expiredMap.remove(object);
        }

        public Set keySet() {
            return this.expiredMap.keySet();
        }

        public Collection values() {
            return this.expiredMap.values();
        }

        public Set entrySet() {
            return this.expiredMap.entrySet();
        }
    }

    public static class JMSOrderExceptionAdapter
    implements ExceptionAdapter {
        public Throwable wrapException(Throwable throwable) {
            return PathHelper.wrapExtensionImpl(throwable);
        }

        public Throwable unwrapException(Throwable throwable) {
            while (throwable instanceof JMSOrderException && throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            return throwable;
        }
    }

    private class ServerInfo {
        private ConcurrentHashMap owned = new ConcurrentHashMap();
        private LowMemoryForgetfulMap dirty = new LowMemoryForgetfulMap();
        private String jndiName;
        private AsyncMap delegate;
        private ChangeListener invalidator;

        ServerInfo(String string, AsyncMap asyncMap) {
            this.jndiName = string;
            this.delegate = asyncMap;
            if (ClusterService.getServices() != null) {
                this.invalidator = LLDFactory.getInstance().createLLDInvalidator(PathHelper.broadcastJndiName(this.jndiName), this.dirty);
            }
        }

        String getJndiName() {
            return this.jndiName;
        }

        private Member dirtyPut(Key key, Member member) {
            Member member2 = (Member)this.dirty.put(key, member);
            if (member2 == null) {
                return null;
            }
            return member2;
        }

        private Member dirtyPutIfAbsent(Key key, Member member) {
            Member member2 = (Member)this.dirty.putIfAbsent(key, member);
            if (member2 == null) {
                return null;
            }
            return member2;
        }

        private Member dirtyGet(Key key) {
            Member member = (Member)this.dirty.get(key);
            if (member == null) {
                return null;
            }
            return member;
        }

        private Member dirtyRemove(Key key) {
            Member member = (Member)this.dirty.remove(key);
            if (member == null) {
                return null;
            }
            return member;
        }

        private Member ownedPut(Key key, Member member) {
            return (Member)this.owned.put((Object)key, (Object)member);
        }

        private Member ownedPutIfAbsent(Key key, Member member) {
            return (Member)this.owned.putIfAbsent((Object)key, (Object)member);
        }

        private Member ownedGet(Key key) {
            Member member = (Member)this.owned.get((Object)key);
            if (member == null && retired && PathSvcVerbose.isDebugEnabled()) {
                PathSvcVerbose.debug("Missing owned key " + key + " from " + this.owned.keySet());
            }
            return member;
        }

        private Member ownedRemove(Key key) {
            return (Member)this.owned.remove((Object)key);
        }

        public String toString() {
            return "jndiName=" + this.jndiName;
        }
    }

    private abstract class UpdateCache
    extends CompletionRequest
    implements CompletionListener {
        CompletionRequest userCompletionRequest;

        UpdateCache(CompletionRequest completionRequest) {
            this.userCompletionRequest = completionRequest;
            this.addListener(this);
        }
    }

    private class RetryOnce
    extends CompletionRequest
    implements CompletionListener {
        int type;
        String jndiName;
        Key key;
        Member member;
        AsyncMap oldMap;
        CompletionRequest userCompletionRequest;

        RetryOnce(int n, String string, Key key, Member member, AsyncMap asyncMap, CompletionRequest completionRequest) {
            this.type = n;
            this.key = key;
            this.member = member;
            this.oldMap = asyncMap;
            this.jndiName = string;
            this.userCompletionRequest = completionRequest;
            this.addListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCompletion(CompletionRequest completionRequest, Object object) {
            if (this.userCompletionRequest != null) {
                block4: {
                    boolean bl = this.userCompletionRequest.runListenersInSetResult(true);
                    try {
                        this.userCompletionRequest.setResult(object);
                        Object var5_4 = null;
                        if (!bl) break block4;
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        if (bl) {
                            return;
                        }
                        this.userCompletionRequest.runListenersInSetResult(false);
                        throw throwable;
                    }
                }
                this.userCompletionRequest.runListenersInSetResult(false);
                {
                }
            }
        }

        public void onException(CompletionRequest completionRequest, Throwable throwable) {
            if (this.userCompletionRequest == null) {
                return;
            }
            if (throwable instanceof PeerGoneException || throwable instanceof ConnectException) {
                this.doRetry(throwable);
            } else {
                this.onCompletion(this, throwable);
            }
        }

        private void doRetry(Throwable throwable) {
            AsyncMap asyncMap;
            try {
                ServerInfo serverInfo = PathHelper.this.createServerInfo(this.jndiName);
                asyncMap = PathHelper.this.lookupAsyncMap(this.jndiName, serverInfo);
                if (asyncMap == this.oldMap) {
                    PathSvc.debug("somehow retry has same map instance", throwable);
                    this.onCompletion(this, throwable);
                    return;
                }
            }
            catch (NamingException namingException) {
                this.onCompletion(this, throwable);
                return;
            }
            try {
                switch (this.type) {
                    case 0: {
                        asyncMap.putIfAbsent(this.key, this.member, this.userCompletionRequest);
                        return;
                    }
                    case 1: {
                        asyncMap.remove(this.key, this.member, this.userCompletionRequest);
                        return;
                    }
                    case 2: {
                        asyncMap.put(this.key, this.member, this.userCompletionRequest);
                        return;
                    }
                    case 3: {
                        asyncMap.get(this.key, this.userCompletionRequest);
                        return;
                    }
                }
            }
            catch (Throwable throwable2) {
                PathSvc.debug("returning first exception, encountered retry exception:", throwable2);
                this.onCompletion(this, throwable);
            }
        }
    }

    public class PathServiceException
    extends Exception {
        static final long serialVersionUID = -4564823747310961840L;

        PathServiceException(Throwable throwable) {
            super(throwable);
        }
    }
}

