/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.path.internal;

import java.io.Externalizable;
import java.io.IOException;
import weblogic.messaging.path.Key;
import weblogic.messaging.path.helper.KeySerializable;
import weblogic.messaging.path.helper.KeyString;
import weblogic.messaging.path.helper.MemberString;
import weblogic.store.ObjectHandler;
import weblogic.store.helper.StoreObjectHandler;

public final class PathObjectHandler
extends StoreObjectHandler {
    public static final short KEYSTRING = 1;
    public static final short MEMBERSTRING = 2;
    public static final short KEYSERIALIZABLE = 3;
    private static Object keyStringClass = new KeyString().getClass();
    private static Object memberStringClass = new MemberString().getClass();
    private static Object keySerializableClass = new KeySerializable().getClass();
    private static final Short shortKey = new Short(1);
    private static final Short shortMember = new Short(2);
    private static final Short shortSerializable = new Short(3);
    private static final ObjectHandler[] registeredHandlers = new ObjectHandler[Key.RESERVED_SUBSYSTEMS.length];

    public static void setObjectHandler(byte by, ObjectHandler objectHandler) {
        assert (registeredHandlers[by] == null || registeredHandlers[by] == objectHandler);
        PathObjectHandler.registeredHandlers[by] = objectHandler;
    }

    public static ObjectHandler getObjectHandler(byte by) {
        return registeredHandlers[by];
    }

    public final Class getClassForId(short s) {
        return null;
    }

    public final Short getIdForClass(Object clazz) {
        if ((clazz = clazz.getClass()) == keyStringClass) {
            return shortKey;
        }
        if (clazz == memberStringClass) {
            return shortMember;
        }
        if (clazz == keySerializableClass) {
            return shortSerializable;
        }
        return null;
    }

    public final void checkIfClassRecognized(short s) throws IOException {
        throw new IOException("Unrecognized class code " + s);
    }

    protected boolean haveExternal(short s) {
        switch (s) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    protected Externalizable newExternal(short s) throws IOException {
        switch (s) {
            case 1: {
                return new KeyString();
            }
            case 2: {
                return new MemberString();
            }
            case 3: {
                return new KeySerializable();
            }
        }
        assert (false);
        throw new IOException("Unrecognized class code " + s);
    }

    static {
        PathObjectHandler pathObjectHandler = new PathObjectHandler();
        for (int n = 0; n < registeredHandlers.length; n = (int)((byte)(n + 1))) {
            PathObjectHandler.registeredHandlers[n] = n == 1 ? null : pathObjectHandler;
        }
    }
}

