/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.runtime;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import weblogic.messaging.runtime.CursorDelegate;
import weblogic.messaging.runtime.CursorRuntimeImpl;
import weblogic.messaging.runtime.OpenDataConverter;

public class ArrayCursorDelegate
extends CursorDelegate {
    protected transient Object[] entryArray;

    public ArrayCursorDelegate(CursorRuntimeImpl cursorRuntimeImpl, OpenDataConverter openDataConverter, int n) {
        super(cursorRuntimeImpl, openDataConverter, n);
        this.endPosition = -1L;
        this.startPosition = -1L;
    }

    public CompositeData[] getNext(int n) throws OpenDataException {
        int n2 = n;
        if ((long)((int)this.getSize() - 1) - this.endPosition < (long)n) {
            n2 = (int)this.getSize() - 1 - (int)this.endPosition;
        }
        return this.returnItems(this.endPosition + 1L, n2);
    }

    public CompositeData[] getPrevious(int n) throws OpenDataException {
        int n2 = n;
        if (this.startPosition < (long)n) {
            n2 = (int)this.startPosition;
        }
        return this.returnItems(this.startPosition - (long)n2, n2);
    }

    public CompositeData[] getItems(long l, int n) throws OpenDataException {
        this.updateAccessTime();
        if (l < 0L || l >= (long)this.entryArray.length) {
            throw new IndexOutOfBoundsException("Value of start argument (" + l + ") is invalid.  Start index must be between 0 and " + this.entryArray.length + " - 1.");
        }
        this.startPosition = this.endPosition = l - 1L;
        return this.getNextItems(n);
    }

    protected CompositeData[] getPreviousItems(int n) throws OpenDataException {
        int n2 = n;
        if (this.startPosition < (long)n) {
            n2 = (int)this.startPosition;
        }
        return this.returnItems(this.startPosition - (long)n2, n2);
    }

    protected CompositeData[] getNextItems(int n) throws OpenDataException {
        int n2 = n;
        if ((long)((int)this.getSize() - 1) - this.endPosition < (long)n) {
            n2 = (int)this.getSize() - 1 - (int)this.endPosition;
        }
        return this.returnItems(this.endPosition + 1L, n2);
    }

    public Long getCursorSize() {
        this.updateAccessTime();
        return new Long(this.getSize());
    }

    private long getSize() {
        return this.entryArray.length;
    }

    private CompositeData[] returnItems(long l, int n) throws OpenDataException {
        this.updateAccessTime();
        if (n == 0) {
            return null;
        }
        CompositeData[] compositeDataArray = new CompositeData[n];
        for (int i = 0; i < n; ++i) {
            compositeDataArray[i] = this.openDataConverter.createCompositeData(this.entryArray[i]);
        }
        this.startPosition = l;
        this.endPosition = this.startPosition + (long)n - 1L;
        return compositeDataArray;
    }
}

