/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.runtime;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import weblogic.messaging.runtime.CursorRuntimeImpl;
import weblogic.messaging.runtime.OpenDataConverter;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;

public abstract class CursorDelegate
implements TimerListener {
    protected String handle;
    protected CursorRuntimeImpl runtimeDelegate;
    protected OpenDataConverter openDataConverter;
    protected long startPosition;
    protected long endPosition;
    private int timeout;
    private long lastAccessTime;
    private static long counter;
    private TimerManager timerManager;

    public CursorDelegate(CursorRuntimeImpl cursorRuntimeImpl, OpenDataConverter openDataConverter, int n) {
        this.runtimeDelegate = cursorRuntimeImpl;
        this.openDataConverter = openDataConverter;
        this.timeout = n;
        this.timerManager = TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager();
        if (n > 0) {
            this.timerManager.schedule((TimerListener)this, (long)n * 1000L);
        }
    }

    public Long getCursorStartPosition() {
        this.updateAccessTime();
        return new Long(this.startPosition);
    }

    public Long getCursorEndPosition() {
        this.updateAccessTime();
        return new Long(this.endPosition);
    }

    public abstract CompositeData[] getNext(int var1) throws OpenDataException;

    public abstract CompositeData[] getPrevious(int var1) throws OpenDataException;

    public abstract CompositeData[] getItems(long var1, int var3) throws OpenDataException;

    public abstract Long getCursorSize();

    public void close() {
        this.runtimeDelegate.removeCursorDelegate(this.handle);
    }

    protected void setHandle(String string) {
        this.handle = string;
    }

    public String getHandle() {
        return this.handle;
    }

    protected synchronized void updateAccessTime() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public void timerExpired(Timer timer) {
        long l = System.currentTimeMillis();
        if (l > this.lastAccessTime + (long)this.timeout) {
            this.close();
        } else {
            long l2 = (long)this.timeout - (l - this.lastAccessTime);
            this.timerManager.schedule((TimerListener)this, l2);
        }
    }
}

