/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.runtime;

import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import weblogic.management.ManagementException;
import weblogic.management.runtime.CursorRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.messaging.runtime.CursorDelegate;

public abstract class CursorRuntimeImpl
extends RuntimeMBeanDelegate
implements CursorRuntimeMBean {
    private transient long counter;
    private transient HashMap cursors = new HashMap();

    public CursorRuntimeImpl(String string, RuntimeMBean runtimeMBean) throws ManagementException {
        super(string, runtimeMBean);
    }

    public CursorRuntimeImpl(String string, RuntimeMBean runtimeMBean, boolean bl) throws ManagementException {
        super(string, runtimeMBean, bl);
    }

    public CursorRuntimeImpl(String string, boolean bl) throws ManagementException {
        super(string, bl);
    }

    public Long getCursorStartPosition(String string) throws ManagementException {
        CursorDelegate cursorDelegate = this.getCursorDelegate(string);
        return cursorDelegate.getCursorStartPosition();
    }

    public Long getCursorEndPosition(String string) throws ManagementException {
        CursorDelegate cursorDelegate = this.getCursorDelegate(string);
        return cursorDelegate.getCursorEndPosition();
    }

    public CompositeData[] getItems(String string, Long l, Integer n) throws ManagementException {
        CursorDelegate cursorDelegate = this.getCursorDelegate(string);
        try {
            return cursorDelegate.getItems(l, n);
        }
        catch (OpenDataException openDataException) {
            throw new ManagementException("Failed to get " + n + " items at " + l + " on cursor " + string + ": " + openDataException.toString(), (Throwable)openDataException);
        }
    }

    public CompositeData[] getNext(String string, Integer n) throws ManagementException {
        CursorDelegate cursorDelegate = this.getCursorDelegate(string);
        try {
            return cursorDelegate.getNext(n);
        }
        catch (OpenDataException openDataException) {
            throw new ManagementException("Failed to get next " + n + " items " + " on cursor " + string, (Throwable)openDataException);
        }
    }

    public CompositeData[] getPrevious(String string, Integer n) throws ManagementException {
        CursorDelegate cursorDelegate = this.getCursorDelegate(string);
        try {
            return cursorDelegate.getPrevious(n);
        }
        catch (OpenDataException openDataException) {
            throw new ManagementException("Failed to get previous " + n + " items " + " on cursor " + string, (Throwable)openDataException);
        }
    }

    public Long getCursorSize(String string) throws ManagementException {
        CursorDelegate cursorDelegate = this.getCursorDelegate(string);
        return cursorDelegate.getCursorSize();
    }

    public Void closeCursor(String string) throws ManagementException {
        CursorDelegate cursorDelegate = this.getCursorDelegate(string);
        cursorDelegate.close();
        this.removeCursorDelegate(string);
        return null;
    }

    public synchronized String addCursorDelegate(CursorDelegate cursorDelegate) {
        String string = this.name + ":" + this.counter++;
        cursorDelegate.setHandle(string);
        this.cursors.put(string, cursorDelegate);
        return string;
    }

    protected synchronized CursorDelegate getCursorDelegate(String string) throws ManagementException {
        CursorDelegate cursorDelegate = (CursorDelegate)this.cursors.get(string);
        if (cursorDelegate == null) {
            throw new ManagementException("no cursor matching handle " + string);
        }
        return cursorDelegate;
    }

    public synchronized CursorDelegate removeCursorDelegate(String string) {
        return (CursorDelegate)this.cursors.remove(string);
    }
}

