/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public abstract class MessageInfo {
    public static final int STATE_VISIBLE = 1;
    public static final int STATE_ORDERED = 16;
    public static final int STATE_DELAYED = 32;
    public static final int STATE_RECEIVE = 4;
    public static final int STATE_SEND = 2;
    public static final int STATE_TRANSACTION = 8;
    public static final int STATE_PAUSED = 256;
    public static final int STATE_REDELIVERY_COUNT_EXCEEDED = 128;
    public static final int STATE_EXPIRED = 64;
    private static final String OPEN_TYPE_NAME = "MessageInfo";
    private static final String OPEN_DESCRIPTION = "This object represents message meta-data that describes the context of the message at the time the management operation was performed.";
    protected ArrayList openItemNames = new ArrayList();
    protected ArrayList openItemDescriptions = new ArrayList();
    protected ArrayList openItemTypes = new ArrayList();
    protected static final String ITEM_HANDLE = "Handle";
    protected static final String ITEM_STATE = "State";
    protected static final String ITEM_XID_STRING = "XidString";
    protected static final String ITEM_SEQUENCE_NUMBER = "SequenceNumber";
    protected static final String ITEM_CONSUMER_ID = "ConsumerID";
    protected Long handle;
    protected int state;
    protected String stateString;
    protected String xidString;
    protected long sequenceNumber;
    protected String consumerID;

    protected MessageInfo() {
        this.initOpenInfo();
    }

    public MessageInfo(CompositeData compositeData) throws OpenDataException {
        this.readCompositeData(compositeData);
        this.initOpenInfo();
    }

    public MessageInfo(long l, int n, String string, long l2, String string2) {
        this.handle = new Long(l);
        this.state = n;
        this.stateString = MessageInfo.getStateString(n);
        this.xidString = string;
        this.sequenceNumber = l2;
        this.consumerID = string2;
        this.initOpenInfo();
    }

    public CompositeData toCompositeData() throws OpenDataException {
        CompositeDataSupport compositeDataSupport = new CompositeDataSupport(this.getCompositeType(), this.getCompositeDataMap());
        return compositeDataSupport;
    }

    public Long getHandle() {
        return this.handle;
    }

    public void setHandle(Long l) {
        this.handle = l;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        this.state = n;
        this.stateString = MessageInfo.getStateString(n);
    }

    public String getStateString() {
        return this.stateString;
    }

    public String getXidString() {
        return this.xidString;
    }

    public void setXidString(String string) {
        this.xidString = string;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long l) {
        this.sequenceNumber = l;
    }

    public String getConsumerID() {
        return this.consumerID;
    }

    public void setConsumerID(String string) {
        this.consumerID = string;
    }

    public static String getStateString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 1) {
            stringBuffer.append("visible");
            return stringBuffer.toString();
        }
        if ((n & 2) != 0) {
            stringBuffer.append("send ");
        }
        if ((n & 4) != 0) {
            stringBuffer.append("receive ");
        }
        if ((n & 8) != 0) {
            stringBuffer.append("transaction ");
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append("ordered ");
        }
        if ((n & 0x20) != 0) {
            stringBuffer.append("delayed ");
        }
        if ((n & 0x40) != 0) {
            stringBuffer.append("expired ");
        }
        if ((n & 0x80) != 0) {
            stringBuffer.append("redelivery-count-exceeded ");
        }
        if ((n & 0x100) != 0) {
            stringBuffer.append("paused ");
        }
        if ((n & 0x200) != 0) {
            stringBuffer.append("sequenced ");
        }
        if ((n & 0x400) != 0) {
            stringBuffer.append("unit-of-work-component ");
        }
        return stringBuffer.toString().trim();
    }

    protected void initOpenInfo() {
        this.openItemNames.add(ITEM_HANDLE);
        this.openItemNames.add(ITEM_STATE);
        this.openItemNames.add(ITEM_XID_STRING);
        this.openItemNames.add(ITEM_SEQUENCE_NUMBER);
        this.openItemNames.add(ITEM_CONSUMER_ID);
        this.openItemDescriptions.add("A handle that identifies this object in the cursor.");
        this.openItemDescriptions.add("The state of the message at the time of the management operation invocation.");
        this.openItemDescriptions.add("The Xid of the transaction for which this message is pending.");
        this.openItemDescriptions.add("The sequence number of the message that indicates its position in the FIFO ordering of the destination.");
        this.openItemDescriptions.add("Information that identifies the consumer of the message");
        this.openItemTypes.add(SimpleType.LONG);
        this.openItemTypes.add(SimpleType.INTEGER);
        this.openItemTypes.add(SimpleType.STRING);
        this.openItemTypes.add(SimpleType.LONG);
        this.openItemTypes.add(SimpleType.STRING);
    }

    protected void readCompositeData(CompositeData compositeData) throws OpenDataException {
        String string;
        Long l;
        String string2;
        Integer n;
        Long l2 = (Long)compositeData.get(ITEM_HANDLE);
        if (l2 != null) {
            this.setHandle(l2);
        }
        if ((n = (Integer)compositeData.get(ITEM_STATE)) != null) {
            this.setState(n);
        }
        if ((string2 = (String)compositeData.get(ITEM_XID_STRING)) != null) {
            this.setXidString(string2);
        }
        if ((l = (Long)compositeData.get(ITEM_SEQUENCE_NUMBER)) != null) {
            this.setSequenceNumber(l);
        }
        if ((string = (String)compositeData.get(ITEM_CONSUMER_ID)) != null) {
            this.setConsumerID(string);
        }
    }

    protected Map getCompositeDataMap() throws OpenDataException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(ITEM_HANDLE, this.handle);
        hashMap.put(ITEM_STATE, new Integer(this.state));
        hashMap.put(ITEM_XID_STRING, this.xidString);
        hashMap.put(ITEM_SEQUENCE_NUMBER, new Long(this.sequenceNumber));
        hashMap.put(ITEM_CONSUMER_ID, this.consumerID);
        return hashMap;
    }

    protected CompositeType getCompositeType() throws OpenDataException {
        CompositeType compositeType = new CompositeType(OPEN_TYPE_NAME, OPEN_DESCRIPTION, this.openItemNames.toArray(new String[this.openItemNames.size()]), this.openItemDescriptions.toArray(new String[this.openItemDescriptions.size()]), this.openItemTypes.toArray(new OpenType[this.openItemTypes.size()]));
        return compositeType;
    }
}

