/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf;

import java.io.Externalizable;
import java.util.List;
import weblogic.messaging.saf.SAFConversationHandle;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFEndpointManager;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.SAFRequest;
import weblogic.messaging.saf.SAFResult;
import weblogic.messaging.saf.SAFTransport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SAFManager {
    public void send(SAFRequest var1) throws SAFException;

    public void deliver(SAFConversationInfo var1, SAFRequest var2) throws SAFException;

    public SAFResult deliverSync(SAFConversationInfo var1, SAFRequest var2) throws SAFException;

    public void registerTransport(SAFTransport var1);

    public SAFTransport getTransport(int var1);

    public void registerEndpointManager(int var1, SAFEndpointManager var2);

    public SAFEndpointManager getEndpointManager(int var1);

    public String registerConversationOnSendingSide(SAFConversationInfo var1) throws SAFException;

    public String registerConversationOnSendingSide(SAFConversationInfo var1, ConversationNameRefinementCallback var2) throws SAFException;

    public SAFConversationInfo getCachedConversationInfoOnSendingSide(String var1) throws SAFException;

    public SAFConversationInfo getConversationInfoOnSendingSide(String var1) throws SAFException;

    public LocationInfo getLocationInfoForConversationOnSendingSide(String var1);

    public void closeConversationOnSendingSide(String var1, boolean var2) throws SAFException;

    public SAFConversationHandle registerConversationOnReceivingSide(SAFConversationInfo var1) throws SAFException;

    public SAFConversationHandle registerConversationOnReceivingSide(SAFConversationInfo var1, ConversationNameRefinementCallback var2, String var3) throws SAFException;

    public LocationInfo getLocationInfoForConversationOnReceivingSide(SAFConversationInfo var1);

    public void closeConversationOnReceivingSide(SAFConversationInfo var1) throws SAFException;

    public SAFConversationInfo getCachedConversationInfoOnReceivingSide(String var1) throws SAFException;

    public SAFConversationInfo getConversationInfoOnReceivingSide(String var1) throws SAFException;

    public long getLastAcknowledged(SAFConversationInfo var1) throws SAFException;

    public void acknowledge(String var1, long var2, long var4) throws SAFException;

    public void handleAsyncFault(String var1, String var2, Exception var3) throws SAFException;

    public void createConversationSucceeded(SAFConversationHandle var1) throws SAFException;

    public void storeConversationContextOnReceivingSide(String var1, Externalizable var2) throws SAFException;

    public void storeConversationContextOnSendingSide(String var1, Externalizable var2) throws SAFException;

    public List<Long> getAllSequenceNumberRangesOnReceivingSide(String var1) throws SAFException;

    public long getLastAssignedSequenceValueOnSendingSide(String var1) throws SAFException;

    public List<Long> getAllSequenceNumberRangesOnSendingSide(String var1) throws SAFException;

    public boolean hasSentLastMessageOnSendingSide(String var1) throws SAFException;

    public void setSentLastMessageOnSendingSide(String var1, long var2) throws SAFException;

    public boolean hasReceivedLastMessageOnReceivingSide(String var1) throws SAFException;

    public long getLastMessageSequenceNumberOnReceivingSide(String var1) throws SAFException;

    public long getLastMessageSequenceNumberOnSendingSide(String var1) throws SAFException;

    public boolean checkForConversationClosedOnReceivingSide(String var1) throws SAFException;

    public boolean checkForConversationClosedOnSendingSide(String var1) throws SAFException;

    public void addConversationLifecycleListener(ConversationLifecycleListener var1);

    public void removeConversationLifecycleListener(ConversationLifecycleListener var1);

    public static interface ConversationNameRefinementCallback {
        public void conversationPreStore(SAFConversationInfo var1, LocationInfo var2);
    }

    public static class LocationInfo {
        private String _storeName;

        public LocationInfo(String string) {
            this._storeName = string;
        }

        public String getStoreName() {
            return this._storeName;
        }
    }

    public static interface ConversationLifecycleListener {
        public void ack(SAFConversationInfo var1, long var2, long var4);

        public void addToCache(boolean var1, String var2, String var3, SAFConversationInfo var4, int var5);

        public void removeFromCache(boolean var1, String var2, String var3, SAFConversationInfo var4, int var5);

        public void preClose(boolean var1, boolean var2, SAFConversationInfo var3);
    }
}

