/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.SimpleType;
import weblogic.messaging.runtime.MessageInfo;
import weblogic.messaging.saf.SAFRequest;
import weblogic.utils.encoders.BASE64Decoder;
import weblogic.utils.encoders.BASE64Encoder;

public class SAFMessageInfo
extends MessageInfo {
    private static final String OPEN_TYPE_NAME = "SAFMessageInfo";
    private static final String OPEN_DESCRIPTION = "This object represents information about a SAFRequest instance.";
    private static final String ITEM_VERSION_NUMBER = "VersionNumber";
    private static final String ITEM_CONVERSATION_NAME = "ConversationName";
    private static final String ITEM_DELIVERY_MODE = "DeliveryMode";
    private static final String ITEM_MESSAGE_ID = "MessageId";
    private static final String ITEM_PAYLOAD_SIZE = "PayloadSize";
    private static final String ITEM_SEQUENCE_NUMBER = "SequenceNumber";
    private static final String ITEM_TIMESTAMP = "Timestamp";
    private static final String ITEM_TIME_TO_LIVE = "TimeToLive";
    private static final String ITEM_END_OF_CONVERSATION = "EndOfConversation";
    private static final String ITEM_DESTINATION_URL = "DestinationURL";
    private static final String ITEM_SERIALIZED_REQUEST = "SerializedRequest";
    private static final int VERSION = 1;
    private String conversationName;
    private int deliveryMode;
    private String messageId;
    private long payloadSize;
    private long sequenceNumber;
    private long timestamp;
    private long timeToLive;
    private boolean endOfConversation;
    private String destinationURL;
    private SAFRequest safRequest;

    public SAFMessageInfo() {
    }

    public SAFMessageInfo(CompositeData compositeData) throws OpenDataException {
        super(compositeData);
    }

    public SAFMessageInfo(long l, int n, String string, long l2, String string2, SAFRequest sAFRequest, String string3) {
        super(l, n, string, l2, string2);
        this.safRequest = sAFRequest;
        this.conversationName = sAFRequest.getConversationName();
        this.deliveryMode = sAFRequest.getDeliveryMode();
        this.messageId = sAFRequest.getMessageId();
        this.payloadSize = sAFRequest.getPayloadSize();
        this.sequenceNumber = sAFRequest.getSequenceNumber();
        this.timestamp = sAFRequest.getTimestamp();
        this.timeToLive = sAFRequest.getTimeToLive();
        this.endOfConversation = sAFRequest.isEndOfConversation();
        this.destinationURL = string3;
    }

    protected void initOpenInfo() {
        super.initOpenInfo();
        this.openItemNames.add(ITEM_VERSION_NUMBER);
        this.openItemNames.add(ITEM_CONVERSATION_NAME);
        this.openItemNames.add(ITEM_DELIVERY_MODE);
        this.openItemNames.add(ITEM_MESSAGE_ID);
        this.openItemNames.add(ITEM_PAYLOAD_SIZE);
        this.openItemNames.add(ITEM_TIMESTAMP);
        this.openItemNames.add(ITEM_TIME_TO_LIVE);
        this.openItemNames.add(ITEM_END_OF_CONVERSATION);
        this.openItemNames.add(ITEM_DESTINATION_URL);
        this.openItemNames.add(ITEM_SERIALIZED_REQUEST);
        this.openItemDescriptions.add("The version number.");
        this.openItemDescriptions.add("The name that uniquely identifies the SAF conversation.");
        this.openItemDescriptions.add("Indicates whether the delivery mode is persistent or non-persistent.");
        this.openItemDescriptions.add("The message ID of the request.");
        this.openItemDescriptions.add("The size of the payload in bytes.");
        this.openItemDescriptions.add("The timestamp of the message in milliseconds.");
        this.openItemDescriptions.add("The time-to-live value in milliseconds.");
        this.openItemDescriptions.add("Indicates whether this is the last message in the conversation.");
        this.openItemDescriptions.add("The URL of the destination to which this message is to be forwarded to.");
        this.openItemDescriptions.add("The serialized SAFRequest.");
        this.openItemTypes.add(SimpleType.INTEGER);
        this.openItemTypes.add(SimpleType.STRING);
        this.openItemTypes.add(SimpleType.INTEGER);
        this.openItemTypes.add(SimpleType.STRING);
        this.openItemTypes.add(SimpleType.LONG);
        this.openItemTypes.add(SimpleType.LONG);
        this.openItemTypes.add(SimpleType.LONG);
        this.openItemTypes.add(SimpleType.BOOLEAN);
        this.openItemTypes.add(SimpleType.STRING);
        this.openItemTypes.add(SimpleType.STRING);
    }

    public String getConversationName() {
        return this.conversationName;
    }

    public void setConversationName(String string) {
        this.conversationName = string;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(int n) {
        this.deliveryMode = n;
    }

    public boolean isEndOfConversation() {
        return this.endOfConversation;
    }

    public void setEndOfConversation(boolean bl) {
        this.endOfConversation = bl;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String string) {
        this.messageId = string;
    }

    public long getPayloadSize() {
        return this.payloadSize;
    }

    public void setPayloadSize(long l) {
        this.payloadSize = l;
    }

    public SAFRequest getSAFRequest() {
        return this.safRequest;
    }

    public void setSAFRequest(SAFRequest sAFRequest) {
        this.safRequest = sAFRequest;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long l) {
        this.sequenceNumber = l;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long l) {
        this.timeToLive = l;
    }

    public String getDestinationURL() {
        return this.destinationURL;
    }

    public void setDestinationURL(String string) {
        this.destinationURL = string;
    }

    public Externalizable getMessage() {
        if (this.safRequest != null) {
            return this.safRequest.getPayload();
        }
        return null;
    }

    public static Object from(CompositeData compositeData) throws OpenDataException {
        SAFMessageInfo sAFMessageInfo = new SAFMessageInfo();
        sAFMessageInfo.readCompositeData(compositeData);
        return sAFMessageInfo;
    }

    protected void readCompositeData(CompositeData compositeData) throws OpenDataException {
        String string;
        String string2;
        Long l;
        Long l2;
        Long l3;
        Long l4;
        String string3;
        Boolean bl;
        Integer n;
        super.readCompositeData(compositeData);
        String string4 = (String)compositeData.get(ITEM_CONVERSATION_NAME);
        if (string4 != null) {
            this.setConversationName(string4);
        }
        if ((n = (Integer)compositeData.get(ITEM_DELIVERY_MODE)) != null) {
            this.setDeliveryMode(n);
        }
        if ((bl = (Boolean)compositeData.get(ITEM_END_OF_CONVERSATION)) != null) {
            this.setEndOfConversation(bl);
        }
        if ((string3 = (String)compositeData.get(ITEM_MESSAGE_ID)) != null) {
            this.setMessageId(string3);
        }
        if ((l4 = (Long)compositeData.get(ITEM_PAYLOAD_SIZE)) != null) {
            this.setPayloadSize(l4);
        }
        if ((l3 = (Long)compositeData.get(ITEM_SEQUENCE_NUMBER)) != null) {
            this.setSequenceNumber(l3);
        }
        if ((l2 = (Long)compositeData.get(ITEM_TIMESTAMP)) != null) {
            this.setTimestamp(l2);
        }
        if ((l = (Long)compositeData.get(ITEM_TIME_TO_LIVE)) != null) {
            this.setTimeToLive(l);
        }
        if ((string2 = (String)compositeData.get(ITEM_DESTINATION_URL)) != null) {
            this.setDestinationURL(string2);
        }
        if ((string = (String)compositeData.get(ITEM_SERIALIZED_REQUEST)) != null) {
            try {
                BASE64Decoder bASE64Decoder = new BASE64Decoder();
                byte[] byArray = bASE64Decoder.decodeBuffer(string);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                this.setSAFRequest((SAFRequest)objectInputStream.readObject());
            }
            catch (IOException iOException) {
                throw new OpenDataException(iOException.toString());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new OpenDataException(classNotFoundException.toString());
            }
        }
    }

    protected Map getCompositeDataMap() throws OpenDataException {
        Map map = super.getCompositeDataMap();
        map.put(ITEM_VERSION_NUMBER, new Integer(1));
        map.put(ITEM_CONVERSATION_NAME, this.conversationName);
        map.put(ITEM_DELIVERY_MODE, new Integer(this.deliveryMode));
        map.put(ITEM_END_OF_CONVERSATION, new Boolean(this.endOfConversation));
        map.put(ITEM_MESSAGE_ID, this.messageId);
        map.put(ITEM_PAYLOAD_SIZE, new Long(this.payloadSize));
        map.put(ITEM_TIMESTAMP, new Long(this.timestamp));
        map.put(ITEM_TIME_TO_LIVE, new Long(this.timeToLive));
        map.put(ITEM_DESTINATION_URL, this.destinationURL);
        try {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(this.safRequest);
                BASE64Encoder bASE64Encoder = new BASE64Encoder();
                String string = bASE64Encoder.encodeBuffer(byteArrayOutputStream.toByteArray());
                map.put(ITEM_SERIALIZED_REQUEST, string);
            }
            catch (IOException iOException) {
                throw new OpenDataException(iOException.toString());
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            throw throwable;
        }
        return map;
    }
}

