/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.common;

import java.util.ArrayList;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.SAFRequest;
import weblogic.messaging.saf.SAFResult;
import weblogic.messaging.saf.common.AgentDeliverResponse;
import weblogic.messaging.saf.common.SAFDebug;
import weblogic.messaging.saf.common.SAFRequestImpl;
import weblogic.messaging.saf.common.SAFResultImpl;
import weblogic.messaging.saf.internal.AgentImpl;
import weblogic.messaging.saf.internal.ConversationReassembler;
import weblogic.messaging.saf.internal.ReceivingAgentImpl;

public final class AgentDeliverRequest {
    private final SAFRequest request;
    private final SAFConversationInfo conversationInfo;
    private final boolean syncAck;
    private Object result;
    private Throwable throwableResponse;
    private int numWaiting;

    public AgentDeliverRequest(SAFConversationInfo sAFConversationInfo, SAFRequest sAFRequest, boolean bl) {
        this.conversationInfo = sAFConversationInfo;
        this.request = sAFRequest;
        this.syncAck = bl;
    }

    public SAFRequest getRequest() {
        return this.request;
    }

    public final boolean isSyncAck() {
        return this.syncAck;
    }

    public SAFConversationInfo getConversationInfo() {
        return this.conversationInfo;
    }

    public AgentDeliverResponse finishDeliver(AgentImpl agentImpl) throws SAFException {
        ConversationReassembler conversationReassembler = ((ReceivingAgentImpl)agentImpl).getConversation(this.getConversationInfo());
        if (conversationReassembler == null) {
            return this.processDeliverFailure(6);
        }
        if (conversationReassembler.isClosed()) {
            return this.processDeliverFailure(5);
        }
        ((SAFRequestImpl)this.request).setAgentRequest(this);
        conversationReassembler.addMessage(this.request);
        if (!this.syncAck) {
            return new AgentDeliverResponse(null);
        }
        return this.getResult();
    }

    private AgentDeliverResponse processDeliverFailure(int n) throws SAFException {
        if (this.syncAck) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            arrayList.add(new Long(0L));
            arrayList.add(new Long(0L));
            return new AgentDeliverResponse(new SAFResultImpl(this.getConversationInfo(), arrayList, n, "Cannot synchronously deliver message to Endpoint: " + SAFResult.description[n]));
        }
        throw new SAFException("Cannot asynchronously deliver message to Endpoint for async : " + SAFResult.description[n]);
    }

    public final synchronized void notifyResult(AgentDeliverResponse agentDeliverResponse) {
        this.result = agentDeliverResponse;
        if (this.numWaiting > 0) {
            this.notify();
        }
    }

    private synchronized AgentDeliverResponse getResult() throws SAFException {
        while (this.result == null && this.throwableResponse == null) {
            this.sleepTillNotified();
        }
        if (this.throwableResponse != null) {
            if (this.throwableResponse instanceof RuntimeException) {
                throw (RuntimeException)this.throwableResponse;
            }
            if (this.throwableResponse instanceof SAFException) {
                throw (SAFException)this.throwableResponse;
            }
            throw new SAFException(this.throwableResponse.getMessage(), this.throwableResponse);
        }
        return (AgentDeliverResponse)this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sleepTillNotified() {
        if (SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFVerbose.debug(this + " is in sleepTillNotify()");
        }
        try {
            block7: {
                try {
                    ++this.numWaiting;
                    this.wait();
                    if (!SAFDebug.SAFVerbose.isDebugEnabled()) break block7;
                    SAFDebug.SAFVerbose.debug(this + " is waken up from sleepTillNotify()");
                }
                catch (InterruptedException interruptedException) {
                    Object var3_2 = null;
                    --this.numWaiting;
                    if (this.numWaiting <= 0) return;
                    this.notify();
                    return;
                }
            }
            Object var3_1 = null;
            --this.numWaiting;
            if (this.numWaiting <= 0) return;
            this.notify();
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            --this.numWaiting;
            if (this.numWaiting > 0) {
                this.notify();
            }
            Object var4_6 = null;
            Object var5_9 = null;
            boolean bl = false;
            if (!bl) throw throwable;
            if (var4_6 != null) {
                throw var4_6;
            }
            if (var5_9 == null) throw throwable;
            throw var5_9;
        }
    }
}

