/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFErrorHandler;
import weblogic.messaging.saf.common.SAFRemoteContext;
import weblogic.messaging.saf.internal.SAFDiagnosticImageSource;
import weblogic.messaging.saf.internal.SAFManagerImpl;
import weblogic.messaging.saf.utils.Util;

public final class SAFConversationInfoImpl
implements SAFConversationInfo {
    static final long serialVersionUID = -6685748132717633470L;
    private static final int EXTVERSION1 = 1;
    private static final int VERSION_MASK = 255;
    private static final int EXTVERSION = 1;
    private String conversationName;
    private int transportType;
    private int qos = 1;
    private long timestamp;
    private int destinationType;
    private String sourceURL;
    private String destinationURL;
    private long ttl = Long.MAX_VALUE;
    private long maximumIdleTime = Long.MAX_VALUE;
    private boolean inorder = true;
    private SAFRemoteContext remoteContext;
    private SAFErrorHandler errorHandler;
    private int conversationType;
    private boolean dynamic = true;
    private String dynamicConversationName;
    private Externalizable conversationContext;
    private SAFConversationInfo conversationOffer;
    private long conversationTimeout = Long.MAX_VALUE;
    private int timeoutPolicy;
    private String createConvMsgID;
    private boolean conversationAlreadyCreated = false;
    private static final int _HASREMOTECONTEXT = 512;
    private static final int _ISINORDER = 2048;
    private static final int _HASERRORHANDLER = 4096;
    private static final int _HASTIMESTAMP = 8192;
    private static final int _ISDYNAMIC = 32768;
    private static final int _ISWSRMSAFCONVERSATIONINFO = 65536;
    private static final int _HASDYNAMICCONVERSATIONNAME = 131072;
    private static final int _HASCONVERSATIONCONTEXT = 262144;
    private static final int _HASCONVTIMEOUT = 524288;
    private static final int _HASOFFER = 0x100000;
    private static final int _HASCONVTIMEOUTPOLICY = 0x200000;
    private static final int _HASCREATECONVMSGID = 0x400000;
    private static final int _ISCONVERSATIONALREADYCREATED = 0x1000000;

    public SAFConversationInfoImpl(int n) {
        this.conversationType = n;
    }

    public synchronized SAFConversationInfo getConversationOffer() {
        return this.conversationOffer;
    }

    public synchronized void setConversationOffer(SAFConversationInfo sAFConversationInfo) {
        this.conversationOffer = sAFConversationInfo;
    }

    public int getTimeoutPolicy() {
        return this.timeoutPolicy;
    }

    public void setTimeoutPolicy(int n) {
        this.timeoutPolicy = n;
    }

    public void setCreateConversationMessageID(String string) {
        this.createConvMsgID = string;
    }

    public String getCreateConversationMessageID() {
        return this.createConvMsgID;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SAFConversationInfoImpl)) {
            return false;
        }
        SAFConversationInfoImpl sAFConversationInfoImpl = (SAFConversationInfoImpl)object;
        if (this.conversationType == 2) {
            return this.conversationName.equals(sAFConversationInfoImpl.conversationName);
        }
        if (this.destinationType != sAFConversationInfoImpl.destinationType) {
            return false;
        }
        if (this.qos != sAFConversationInfoImpl.qos) {
            return false;
        }
        if (this.transportType != sAFConversationInfoImpl.transportType) {
            return false;
        }
        if (!this.conversationName.equals(sAFConversationInfoImpl.conversationName)) {
            return false;
        }
        if (!this.destinationURL.equals(sAFConversationInfoImpl.destinationURL)) {
            return false;
        }
        return this.sourceURL.equals(sAFConversationInfoImpl.sourceURL);
    }

    public int hashCode() {
        int n;
        int n2 = n = this.conversationName != null ? this.conversationName.hashCode() : 0;
        if (this.conversationType == 2) {
            return n;
        }
        n = 29 * n + this.transportType;
        n = 29 * n + this.qos;
        n = 29 * n + this.destinationType;
        if (this.sourceURL != null) {
            n = 29 * n + this.sourceURL.hashCode();
        }
        if (this.destinationURL != null) {
            n = 29 * n + this.destinationURL.hashCode();
        }
        return n;
    }

    public String toString() {
        return "<ConversationInfo> = { ConversationName=" + this.conversationName + "," + " DynamicName=" + this.dynamicConversationName + "," + " SourceURL=" + this.sourceURL + "," + " DestinationURL=" + this.destinationURL + "," + " DestinationType=" + this.destinationType + "," + " QOS=" + this.qos + "," + " timestamp=" + this.timestamp + "," + " timeoutPolicy=" + this.timeoutPolicy + "," + " timeToLive=" + this.ttl + "," + " conversationTimeout=" + this.conversationTimeout + "," + " maximumIdleTime=" + this.maximumIdleTime + "," + " createConversationMessageID=" + this.createConvMsgID + "," + " offeredConversationName=" + (this.getConversationOffer() == null ? null : this.getConversationOffer().getConversationName()) + "}";
    }

    public int getQOS() {
        return this.qos;
    }

    public void setQOS(int n) {
        this.qos = n;
    }

    public String getSourceURL() {
        return this.sourceURL;
    }

    public void setSourceURL(String string) {
        this.sourceURL = string;
    }

    public int getTransportType() {
        return this.transportType;
    }

    public void setTransportType(int n) {
        this.transportType = n;
    }

    public int getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(int n) {
        this.destinationType = n;
    }

    public String getDestinationURL() {
        return this.destinationURL;
    }

    public void setDestinationURL(String string) {
        this.destinationURL = string;
    }

    public long getTimeToLive() {
        return this.ttl;
    }

    public void setTimeToLive(long l) {
        this.ttl = l;
    }

    public long getMaximumIdleTime() {
        return this.maximumIdleTime;
    }

    public void setMaximumIdleTime(long l) {
        this.maximumIdleTime = l;
    }

    public long getConversationTimeout() {
        return this.conversationTimeout;
    }

    public void setConversationTimeout(long l) {
        this.conversationTimeout = l;
    }

    public String getConversationName() {
        return this.conversationName;
    }

    public void setConversationName(String string) {
        this.conversationName = string;
    }

    public boolean isInorder() {
        return this.inorder;
    }

    public void setInorder(boolean bl) {
        this.inorder = bl;
    }

    public SAFRemoteContext getRemoteContext() {
        return this.remoteContext;
    }

    public void setRemoteContext(SAFRemoteContext sAFRemoteContext) {
        this.remoteContext = sAFRemoteContext;
    }

    public SAFErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(SAFErrorHandler sAFErrorHandler) {
        this.errorHandler = sAFErrorHandler;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean bl) {
        this.dynamic = bl;
    }

    public synchronized String getDynamicConversationName() {
        return this.dynamicConversationName;
    }

    public synchronized void setDynamicConversationName(String string) {
        this.dynamicConversationName = string;
    }

    public SAFConversationInfoImpl() {
    }

    public synchronized void setContext(Externalizable externalizable) {
        this.conversationContext = externalizable;
    }

    public synchronized Externalizable getContext() {
        return this.conversationContext;
    }

    public boolean isConversationAlreadyCreated() {
        return this.conversationAlreadyCreated;
    }

    public void setConversationAlreadyCreated(boolean bl) {
        this.conversationAlreadyCreated = bl;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        int n2 = 0;
        n2 |= n;
        if (this.timestamp != 0L) {
            n2 |= 0x2000;
        }
        if (this.remoteContext != null) {
            n2 |= 0x200;
        }
        if (this.inorder) {
            n2 |= 0x800;
        }
        if (this.dynamic) {
            n2 |= 0x8000;
        }
        if (this.errorHandler != null) {
            n2 |= 0x1000;
        }
        if (this.conversationType == 2) {
            n2 |= 0x10000;
        }
        if (this.dynamicConversationName != null) {
            n2 |= 0x20000;
        }
        if (this.conversationContext != null) {
            n2 |= 0x40000;
        }
        if (this.conversationTimeout != Long.MAX_VALUE) {
            n2 |= 0x80000;
        }
        if (this.conversationOffer != null) {
            n2 |= 0x100000;
        }
        if (this.timeoutPolicy != 0) {
            n2 |= 0x200000;
        }
        if (this.createConvMsgID != null) {
            n2 |= 0x400000;
        }
        if (this.conversationAlreadyCreated) {
            n2 |= 0x1000000;
        }
        objectOutput.writeInt(n2);
        objectOutput.writeInt(this.qos);
        objectOutput.writeInt(this.destinationType);
        objectOutput.writeInt(this.transportType);
        objectOutput.writeUTF(this.conversationName);
        if (this.dynamicConversationName != null) {
            objectOutput.writeUTF(this.dynamicConversationName);
        }
        objectOutput.writeObject(this.sourceURL);
        objectOutput.writeUTF(this.destinationURL);
        objectOutput.writeLong(this.ttl);
        objectOutput.writeLong(this.maximumIdleTime);
        if (this.conversationTimeout != Long.MAX_VALUE) {
            objectOutput.writeLong(this.conversationTimeout);
        }
        if (this.remoteContext != null) {
            this.remoteContext.writeExternal(objectOutput);
        }
        if (this.conversationContext != null) {
            objectOutput.writeObject(this.conversationContext);
        }
        if (this.errorHandler != null) {
            this.errorHandler.writeExternal(objectOutput);
        }
        if (this.timestamp != 0L) {
            objectOutput.writeLong(this.timestamp);
        }
        objectOutput.writeInt(0);
        if (this.conversationOffer != null) {
            this.conversationOffer.writeExternal(objectOutput);
        }
        if (this.timeoutPolicy != 0) {
            objectOutput.writeInt(this.timeoutPolicy);
        }
        if (this.createConvMsgID != null) {
            objectOutput.writeUTF(this.createConvMsgID);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw Util.versionIOException(n2, 1, 1);
        }
        this.conversationType = (n & 0x10000) != 0 ? 2 : 1;
        this.qos = objectInput.readInt();
        this.destinationType = objectInput.readInt();
        this.transportType = objectInput.readInt();
        this.conversationName = objectInput.readUTF();
        if ((n & 0x20000) != 0) {
            this.dynamicConversationName = objectInput.readUTF();
        }
        this.sourceURL = (String)objectInput.readObject();
        this.destinationURL = objectInput.readUTF();
        this.ttl = objectInput.readLong();
        this.maximumIdleTime = objectInput.readLong();
        if ((n & 0x80000) != 0) {
            this.conversationTimeout = objectInput.readLong();
        }
        if ((n & 0x200) != 0) {
            this.remoteContext = new SAFRemoteContext();
            this.remoteContext.readExternal(objectInput);
        }
        if ((n & 0x40000) != 0) {
            this.conversationContext = (Externalizable)objectInput.readObject();
        }
        this.inorder = (n & 0x800) != 0;
        boolean bl = this.dynamic = (n & 0x8000) != 0;
        if ((n & 0x1000) != 0) {
            this.errorHandler = SAFManagerImpl.getManager().getEndpointManager(this.destinationType).createErrorHandlerInstance();
            if (this.errorHandler != null) {
                this.errorHandler.readExternal(objectInput);
            }
        }
        if ((n & 0x2000) != 0) {
            this.timestamp = objectInput.readLong();
        }
        objectInput.readInt();
        if ((n & 0x100000) != 0) {
            this.conversationOffer = new SAFConversationInfoImpl();
            this.conversationOffer.readExternal(objectInput);
        }
        if ((n & 0x200000) != 0) {
            this.timeoutPolicy = objectInput.readInt();
        }
        if ((n & 0x400000) != 0) {
            this.createConvMsgID = objectInput.readUTF();
        }
        this.conversationAlreadyCreated = (n & 0x1000000) != 0;
    }

    public void dump(SAFDiagnosticImageSource sAFDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        sAFDiagnosticImageSource.checkTimeout();
        xMLStreamWriter.writeStartElement("ConversationInfo");
        xMLStreamWriter.writeAttribute("qos", String.valueOf(this.qos));
        xMLStreamWriter.writeAttribute("sourceURL", this.sourceURL);
        xMLStreamWriter.writeAttribute("destinationType", String.valueOf(this.destinationType));
        xMLStreamWriter.writeAttribute("destinationURL", this.destinationURL);
        xMLStreamWriter.writeAttribute("name", this.conversationName);
        xMLStreamWriter.writeAttribute("transportType", String.valueOf(this.transportType));
        xMLStreamWriter.writeAttribute("isInorder", String.valueOf(this.inorder));
        xMLStreamWriter.writeAttribute("isDynamic", String.valueOf(this.dynamic));
        xMLStreamWriter.writeAttribute("ttl", String.valueOf(this.ttl));
        xMLStreamWriter.writeAttribute("maximumIdleTime", String.valueOf(this.maximumIdleTime));
        xMLStreamWriter.writeAttribute("timeout", String.valueOf(this.conversationTimeout));
        xMLStreamWriter.writeAttribute("timeoutPolicy", String.valueOf(this.timeoutPolicy));
        xMLStreamWriter.writeEndElement();
    }
}

