/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.messaging.saf.utils.Util;

public final class SAFRemoteContext
implements Externalizable {
    static final long serialVersionUID = 8077095725140746031L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private long retryDelayBase = -1L;
    private long retryDelayMaximum = -1L;
    private long retryDelayMultiplier = -1L;
    private static final int _HASRETRYDELAYPARAMATERS = 256;
    private static final int _HASPROPERTIES = 512;
    private static final int _HASDEFAULTCOMPRESSIONTHRESHOLD = 1024;

    public SAFRemoteContext(long l, long l2, long l3) {
        this.retryDelayBase = l;
        this.retryDelayMaximum = l2;
        this.retryDelayMultiplier = l3;
    }

    public SAFRemoteContext() {
    }

    public long getRetryDelayBase() {
        return this.retryDelayBase;
    }

    public long getRetryDelayMaximum() {
        return this.retryDelayMaximum;
    }

    public long getRetryDelayMultiplier() {
        return this.retryDelayMultiplier;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        if (this.retryDelayBase != 0L) {
            n |= 0x100;
        }
        objectOutput.writeInt(n);
        objectOutput.writeInt(2);
        objectOutput.writeUTF("");
        if (this.retryDelayBase != 0L) {
            objectOutput.writeLong(this.retryDelayBase);
            objectOutput.writeLong(this.retryDelayMaximum);
            objectOutput.writeLong(this.retryDelayMultiplier);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw Util.versionIOException(n2, 1, 1);
        }
        objectInput.readInt();
        objectInput.readUTF();
        if ((n & 0x100) != 0) {
            this.retryDelayBase = objectInput.readLong();
            this.retryDelayMaximum = objectInput.readLong();
            this.retryDelayMultiplier = objectInput.readLong();
        }
        if ((n & 0x400) != 0) {
            objectInput.readInt();
        }
    }
}

