/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Properties;
import weblogic.messaging.Message;
import weblogic.messaging.MessageID;
import weblogic.messaging.saf.SAFRequest;
import weblogic.messaging.saf.common.AgentDeliverRequest;
import weblogic.messaging.saf.common.SAFMessageID;
import weblogic.messaging.saf.utils.Util;

public final class SAFRequestImpl
implements SAFRequest,
Message,
Cloneable {
    static final long serialVersionUID = -8254052743194579406L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int _HASPAYLOAD = 131072;
    private static final int _ISLASTMESSAGE = 262144;
    private static final int _HASPAYLOADCONTEXT = 524288;
    private boolean isLastMessage;
    private int deliveryMode = 2;
    private String conversationName;
    private String messageId;
    private long timestamp;
    private long timeToLive;
    private long sequenceNumber;
    private Externalizable payload;
    private Externalizable payloadContext;
    private Properties properties;
    private long userdataSize = 40L;
    private long payloadSize;
    private AgentDeliverRequest agentRequest;

    public final String getMessageId() {
        return this.messageId;
    }

    public final void setMessageId(String string) {
        this.messageId = string;
        this.userdataSize += (long)string.length();
    }

    public final String getConversationName() {
        return this.conversationName;
    }

    public final void setConversationName(String string) {
        this.conversationName = string;
        this.userdataSize += (long)string.length();
    }

    public final long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public final void setSequenceNumber(long l) {
        this.sequenceNumber = l;
    }

    public final int getDeliveryMode() {
        return this.deliveryMode;
    }

    public final void setDeliveryMode(int n) {
        this.deliveryMode = n;
    }

    public final long getTimeToLive() {
        return this.timeToLive;
    }

    public final void setTimeToLive(long l) {
        this.timeToLive = l;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final void setTimestamp(long l) {
        this.timestamp = l;
    }

    public final boolean isEndOfConversation() {
        return this.isLastMessage;
    }

    public final void setEndOfConversation(boolean bl) {
        this.isLastMessage = bl;
    }

    public final Externalizable getPayload() {
        return this.payload;
    }

    public final void setPayload(Externalizable externalizable) {
        this.payload = externalizable;
    }

    public void setPayloadContext(Externalizable externalizable) {
        this.payloadContext = externalizable;
    }

    public Externalizable getPayloadContext() {
        return this.payloadContext;
    }

    public long getPayloadSize() {
        return this.payloadSize;
    }

    public void setPayloadSize(long l) {
        this.payloadSize = l;
    }

    public MessageID getMessageID() {
        return new SAFMessageID(this.messageId);
    }

    public long size() {
        return this.userdataSize + this.payloadSize;
    }

    public Message duplicate() {
        try {
            return (Message)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public Object getWorkContext() {
        return null;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n;
        int n2 = n = 1;
        if (this.payload != null) {
            n2 |= 0x20000;
            if (this.payloadContext != null) {
                n2 |= 0x80000;
            }
        }
        if (this.isLastMessage) {
            n2 |= 0x40000;
        }
        objectOutput.writeInt(n2);
        objectOutput.writeInt(this.deliveryMode);
        objectOutput.writeInt(0);
        objectOutput.writeUTF(this.messageId);
        objectOutput.writeUTF(this.conversationName);
        objectOutput.writeLong(this.sequenceNumber);
        objectOutput.writeLong(this.timeToLive);
        objectOutput.writeLong(this.timestamp);
        if (this.payload != null) {
            objectOutput.writeObject(this.payload);
            objectOutput.writeLong(this.payloadSize);
            if (this.payloadContext != null) {
                objectOutput.writeObject(this.payloadContext);
            }
        }
        if (this.properties != null && this.properties.size() > 0) {
            objectOutput.writeInt(this.properties.size());
            Enumeration<Object> enumeration = this.properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                objectOutput.writeObject(string);
                objectOutput.writeObject(this.properties.get(string));
            }
        } else {
            objectOutput.writeInt(0);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        int n2 = objectInput.readInt();
        int n3 = n2 & 0xFF;
        if (n3 != 1) {
            throw Util.versionIOException(n3, 1, 1);
        }
        this.deliveryMode = objectInput.readInt();
        objectInput.readInt();
        this.messageId = objectInput.readUTF();
        this.conversationName = objectInput.readUTF();
        this.sequenceNumber = objectInput.readLong();
        this.timeToLive = objectInput.readLong();
        this.timestamp = objectInput.readLong();
        if ((n2 & 0x40000) != 0) {
            this.isLastMessage = true;
        }
        if ((n2 & 0x20000) != 0) {
            this.payload = (Externalizable)objectInput.readObject();
            this.payloadSize = objectInput.readLong();
            if ((n2 & 0x80000) != 0) {
                this.payloadContext = (Externalizable)objectInput.readObject();
            }
        }
        if ((n = objectInput.readInt()) > 0) {
            this.properties = new Properties();
            for (int i = 0; i < n; ++i) {
                String string = (String)objectInput.readObject();
                this.properties.put(string, objectInput.readObject());
            }
        }
    }

    public void setAgentRequest(AgentDeliverRequest agentDeliverRequest) {
        this.agentRequest = agentDeliverRequest;
    }

    public AgentDeliverRequest getAgentRequest() {
        return this.agentRequest;
    }

    public synchronized boolean isExpired() {
        if (this.timeToLive == 0L) {
            return false;
        }
        return System.currentTimeMillis() - this.timestamp > this.timeToLive;
    }
}

