/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.health.HealthState;
import weblogic.management.configuration.SAFAgentMBean;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.common.SAFDebug;
import weblogic.messaging.saf.internal.Agent;
import weblogic.messaging.saf.internal.SAFAgentAdmin;
import weblogic.messaging.saf.internal.SAFDiagnosticImageSource;
import weblogic.messaging.saf.internal.SAFManagerImpl;
import weblogic.messaging.saf.store.SAFStore;
import weblogic.messaging.saf.store.SAFStoreException;
import weblogic.messaging.saf.utils.Util;
import weblogic.work.WorkManager;

public abstract class AgentImpl
implements Agent,
Externalizable {
    static final long serialVersionUID = -8897468130390722827L;
    private static final String AGENT_WM_NAME_PREFIX = "weblogic.saf.agent.";
    protected String name;
    protected SAFStore store;
    protected SAFAgentAdmin agentAdmin;
    private int agentType;
    private static final byte EXTVERSION1 = 1;
    protected static final int _SENDINGAGENTTYPE = 1;
    protected static final int _RECEIVINGAGENTTYPE = 2;
    protected static final int STATE_CLOSED = 1;
    protected static final int STATE_STARTING = 2;
    protected static final int STATE_STARTED = 4;
    protected static final int STATE_CLOSING = 8;
    protected static SAFManagerImpl safManager = (SAFManagerImpl)SAFManagerImpl.getManager();
    protected HashMap conversationInfosFromStore = new HashMap();
    protected int state;
    protected int waitersCount;
    protected boolean isPaused;
    private WorkManager workManager;
    protected HealthState healthState = new HealthState(0);
    private static final int _VERSIONMASK = 255;
    private static final int _AGENTTYPESHIFT = 8;
    private static final int _AGENTTYPEMASK = 65280;

    public AgentImpl() {
    }

    AgentImpl(String string, SAFAgentAdmin sAFAgentAdmin, SAFStore sAFStore, int n) throws SAFException {
        this.agentType = n;
        this.init(string, sAFAgentAdmin, sAFStore);
        this.addAgentToStore(sAFStore);
    }

    void init(String string, SAFAgentAdmin sAFAgentAdmin, SAFStore sAFStore) throws SAFException {
        this.name = string;
        this.agentAdmin = sAFAgentAdmin;
        this.store = sAFStore;
        this.init(sAFAgentAdmin.getMBean());
    }

    public void init(SAFAgentMBean sAFAgentMBean) throws SAFException {
        this.startInitialize(sAFAgentMBean);
        this.workManager = Util.findOrCreateWorkManager(AGENT_WM_NAME_PREFIX + sAFAgentMBean.getName() + (this.agentType == 1 ? "Sender" : "Receiver"), -1, 1, -1);
        try {
            this.start();
            this.advertise();
        }
        catch (SAFException sAFException) {
            this.printDebug(sAFException.getMessage());
            throw sAFException;
        }
    }

    protected abstract void addToAgentFactory();

    protected abstract void removeFromAgentFactory();

    protected final void advertise() {
        if (this.isPaused) {
            return;
        }
        this.addToAgentFactory();
    }

    protected final void unadvertise() {
        this.removeFromAgentFactory();
    }

    private void addAgentToStore(SAFStore sAFStore) throws SAFStoreException {
        sAFStore.addAgent(this);
        this.printDebug(" Agent = " + this.name + " has been added to SAFStore " + sAFStore);
    }

    public final String getName() {
        return this.name;
    }

    public final String getStoreName() {
        return this.store.getEffectiveStoreName();
    }

    public final SAFAgentAdmin getAgentAdmin() {
        return this.agentAdmin;
    }

    protected static final SAFManagerImpl getSAFManager() {
        return safManager;
    }

    protected abstract void start() throws SAFException;

    protected abstract void startInitialize(SAFAgentMBean var1) throws SAFException;

    protected void waitForState(int n) throws SAFException {
        while ((this.state & n) == 0) {
            Object var4_2;
            ++this.waitersCount;
            try {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new SAFException(interruptedException);
                }
                var4_2 = null;
                --this.waitersCount;
            }
            catch (Throwable throwable) {
                var4_2 = null;
                --this.waitersCount;
                throw throwable;
            }
        }
    }

    private void printDebug(String string) {
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && this.agentType == 1) {
            SAFDebug.SAFSendingAgent.debug(string);
        }
        if (SAFDebug.SAFReceivingAgent.isDebugEnabled() && this.agentType == 2) {
            SAFDebug.SAFReceivingAgent.debug(string);
        }
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 0;
        int n2 = 1;
        n |= n2;
        objectOutput.writeInt(n |= this.agentType << 8);
        objectOutput.writeUTF(this.name);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        this.agentType = (n & 0xFF00) >>> 8;
        byte by = (byte)(n & 0xFF);
        if (by != 1) {
            throw new IOException(" unknown version of the object");
        }
        this.name = objectInput.readUTF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeConversationInfo(SAFConversationInfo sAFConversationInfo) throws SAFStoreException {
        this.store.addConversationInfo(sAFConversationInfo);
        HashMap hashMap = this.conversationInfosFromStore;
        synchronized (hashMap) {
            this.conversationInfosFromStore.put(sAFConversationInfo.getConversationName(), sAFConversationInfo);
        }
    }

    static HealthState updateHealthState(HealthState healthState, int n, String string) {
        String[] stringArray = new String[]{string};
        return AgentImpl.updateHealthState(healthState, n, stringArray);
    }

    private static HealthState updateHealthState(HealthState healthState, int n, String[] stringArray) {
        HealthState healthState2;
        if (healthState.getState() == n) {
            int n2;
            String[] stringArray2 = healthState.getReasonCode();
            String[] stringArray3 = new String[stringArray2.length + 1];
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                stringArray3[n2] = stringArray2[n2];
            }
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                stringArray3[stringArray2.length + n2] = stringArray[n2];
            }
            healthState2 = new HealthState(n, stringArray3);
        } else {
            healthState2 = new HealthState(n, stringArray);
        }
        return healthState2;
    }

    public void dump(SAFDiagnosticImageSource sAFDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        sAFDiagnosticImageSource.checkTimeout();
        xMLStreamWriter.writeAttribute("name", this.name);
        String string = this.store.getStoreName();
        xMLStreamWriter.writeAttribute("storeName", string != null ? string : "");
        xMLStreamWriter.writeAttribute("conversationsCurrentCount", String.valueOf(this.agentAdmin.getConversationsCurrentCount()));
        xMLStreamWriter.writeAttribute("conversationsHighCount", String.valueOf(this.agentAdmin.getConversationsHighCount()));
        xMLStreamWriter.writeAttribute("conversationsTotalCount", String.valueOf(this.agentAdmin.getConversationsTotalCount()));
    }
}

