/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.internal;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.internal.MessageReference;
import weblogic.messaging.saf.internal.SAFDiagnosticImageSource;
import weblogic.messaging.saf.internal.SAFManagerImpl;
import weblogic.messaging.saf.store.SAFStore;

abstract class Conversation {
    protected boolean running;
    protected boolean poisoned;
    protected boolean ordered;
    protected SAFConversationInfo info;
    protected MessageReference firstMessage;
    protected MessageReference lastMessage;
    protected long timeToLive;
    private boolean seenLastMsg;
    private int msgCount;
    protected SAFStore store;
    protected SAFManagerImpl safManager;

    Conversation(SAFConversationInfo sAFConversationInfo, SAFStore sAFStore, SAFManagerImpl sAFManagerImpl) {
        this.info = sAFConversationInfo;
        this.store = sAFStore;
        this.safManager = sAFManagerImpl;
    }

    abstract void close() throws SAFException;

    protected void addMessageToList(MessageReference messageReference) {
        if (messageReference == null) {
            return;
        }
        if (this.firstMessage == null) {
            this.firstMessage = messageReference;
            this.lastMessage = messageReference;
        } else {
            this.lastMessage.setNext(messageReference);
            messageReference.setPrev(this.lastMessage);
            this.lastMessage = messageReference;
        }
        ++this.msgCount;
    }

    protected void addMessageToListInorder(MessageReference messageReference) {
        MessageReference messageReference2;
        if (messageReference == null) {
            return;
        }
        ++this.msgCount;
        if (this.firstMessage == null) {
            this.firstMessage = messageReference;
            this.lastMessage = messageReference;
            return;
        }
        for (messageReference2 = this.firstMessage; messageReference2 != null && messageReference2.getSequenceNumber() <= messageReference.getSequenceNumber(); messageReference2 = messageReference2.getNext()) {
            if (messageReference2.getSequenceNumber() != messageReference.getSequenceNumber()) continue;
            return;
        }
        if (messageReference2 == null) {
            this.lastMessage.setNext(messageReference);
            messageReference.setPrev(this.lastMessage);
            this.lastMessage = messageReference;
            return;
        }
        messageReference.setNext(messageReference2);
        messageReference.setPrev(messageReference2.getPrev());
        if (messageReference2.getPrev() != null) {
            messageReference2.getPrev().setNext(messageReference);
        }
        messageReference2.setPrev(messageReference);
        if (messageReference2 == this.firstMessage) {
            this.firstMessage = messageReference;
        }
    }

    protected void restoreMessages(MessageReference messageReference) {
        MessageReference messageReference2;
        do {
            messageReference2 = messageReference.getNext();
            messageReference.setNext(null);
            messageReference.setPrev(null);
            this.addMessageToListInorder(messageReference);
        } while ((messageReference = messageReference2) != null);
    }

    protected void removeMessageFromList(MessageReference messageReference) {
        if (messageReference == null) {
            return;
        }
        if (messageReference == this.firstMessage) {
            this.firstMessage = messageReference.getNext();
            if (this.firstMessage != null) {
                this.firstMessage.setPrev(null);
            }
            if (messageReference == this.lastMessage) {
                this.lastMessage = this.firstMessage;
            }
        } else {
            if (messageReference.getNext() != null) {
                messageReference.getNext().setPrev(messageReference.getPrev());
            }
            if (messageReference.getPrev() != null) {
                messageReference.getPrev().setNext(messageReference.getNext());
            }
        }
        --this.msgCount;
    }

    final boolean isDone() {
        return this.firstMessage == null && this.seenLastMsg;
    }

    public SAFConversationInfo getInfo() {
        return this.info;
    }

    public String getName() {
        return this.info.getConversationName();
    }

    synchronized void setSeenLastMsg(boolean bl) {
        this.seenLastMsg = bl;
    }

    synchronized boolean hasSeenLastMsg() {
        return this.seenLastMsg;
    }

    public String getConversationName() {
        return this.info.getConversationName();
    }

    protected static boolean isPoisoned(int n) {
        switch (n) {
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    public void dumpAttributes(SAFDiagnosticImageSource sAFDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        sAFDiagnosticImageSource.checkTimeout();
        xMLStreamWriter.writeAttribute("running", String.valueOf(this.running));
        xMLStreamWriter.writeAttribute("poisoned", String.valueOf(this.poisoned));
        xMLStreamWriter.writeAttribute("ordered", String.valueOf(this.ordered));
        xMLStreamWriter.writeAttribute("timeToLive", String.valueOf(this.timeToLive));
        xMLStreamWriter.writeAttribute("seenLastMessage", String.valueOf(this.seenLastMsg));
        xMLStreamWriter.writeAttribute("msgCount", String.valueOf(this.msgCount));
        xMLStreamWriter.writeAttribute("storeName", this.store != null ? this.store.getStoreName() : "");
    }
}

