/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.internal;

import java.io.Externalizable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.management.ManagementException;
import weblogic.messaging.common.SQLExpression;
import weblogic.messaging.kernel.Kernel;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.KernelRequest;
import weblogic.messaging.kernel.ListenRequest;
import weblogic.messaging.kernel.Listener;
import weblogic.messaging.kernel.MessageElement;
import weblogic.messaging.kernel.Queue;
import weblogic.messaging.kernel.Sequence;
import weblogic.messaging.kernel.Topic;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;
import weblogic.messaging.saf.SAFConversationHandle;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFEndpointManager;
import weblogic.messaging.saf.SAFErrorAwareEndpointManager;
import weblogic.messaging.saf.SAFErrorAwareTransport;
import weblogic.messaging.saf.SAFErrorHandler;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.SAFInvalidAcknowledgementsException;
import weblogic.messaging.saf.SAFLogger;
import weblogic.messaging.saf.SAFRequest;
import weblogic.messaging.saf.SAFTransport;
import weblogic.messaging.saf.SAFTransportException;
import weblogic.messaging.saf.common.SAFConversationInfoImpl;
import weblogic.messaging.saf.common.SAFDebug;
import weblogic.messaging.saf.common.SAFRemoteContext;
import weblogic.messaging.saf.common.SAFRequestImpl;
import weblogic.messaging.saf.internal.Conversation;
import weblogic.messaging.saf.internal.ConversationRuntimeDelegate;
import weblogic.messaging.saf.internal.MessageReference;
import weblogic.messaging.saf.internal.RemoteEndpointRuntimeDelegate;
import weblogic.messaging.saf.internal.RetryController;
import weblogic.messaging.saf.internal.SAFAgentAdmin;
import weblogic.messaging.saf.internal.SAFDiagnosticImageSource;
import weblogic.messaging.saf.internal.SendingAgentImpl;
import weblogic.messaging.saf.store.SAFStore;
import weblogic.messaging.saf.store.SAFStoreException;
import weblogic.messaging.util.DeliveryList;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;

public final class ConversationAssembler
extends Conversation
implements NakedTimerListener,
Runnable {
    private static final int STATE_INITIAL = 1;
    private static final int STATE_STARTING = 2;
    private static final int STATE_DESTROYED = 4;
    private static final int STATE_EXPIRED = 8;
    private static final int STATE_CREATING = 16;
    private static final int STATE_CREATED = 32;
    private static final int STATE_STARTED = 64;
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private long lastAckedSequenceNumber;
    private TimerManager timerManager;
    private Timer messageRetryTimer;
    private Timer transportRetryTimer;
    private RetryController retryController;
    private double retryDelayMultiplier;
    private long retryDelayBase;
    private long retryDelayMaximum;
    private boolean loggingEnabled;
    private SendingAgentImpl sendingAgent;
    private int windowSize;
    private final SAFTransport transport;
    private Timer timeOutTimer;
    private long timeToLive;
    private long idleTimeMaximum;
    private long absTTL;
    private long timeoutCurrent = Long.MAX_VALUE;
    private ConversationRuntimeDelegate runtimeDelegate;
    private int state = 1;
    private boolean needNotify;
    private RemoteEndpointRuntimeDelegate remoteEndpoint;
    private Queue subQueue;
    private MessageReader reader;
    private TransportRetryTimerListener transportRetryListener;
    private MessageRetryTimerListener messageRetryListener;
    private long lastMsgSequenceNumber = Long.MAX_VALUE;
    private Throwable lastSendError;

    ConversationAssembler(SendingAgentImpl sendingAgentImpl, SAFConversationInfo sAFConversationInfo, SAFStore sAFStore, boolean bl, int n) throws ManagementException, SAFException {
        super(sAFConversationInfo, sAFStore, sendingAgentImpl.getSAFManager());
        Object object;
        this.transport = this.safManager.getTransport(sAFConversationInfo.getTransportType());
        if (this.transport == null) {
            throw new SAFException("Internal Error: invalid transaport type " + sAFConversationInfo.getTransportType());
        }
        this.timeToLive = sAFConversationInfo.getTimeToLive();
        if (this.timeToLive == -1L) {
            this.timeToLive = sendingAgentImpl.getDefaultTimeToLive();
        }
        if (this.timeToLive == 0L) {
            this.timeToLive = Long.MAX_VALUE;
        }
        sAFConversationInfo.setTimeToLive(this.timeToLive);
        this.idleTimeMaximum = sAFConversationInfo.getMaximumIdleTime();
        if (this.idleTimeMaximum == -1L) {
            this.idleTimeMaximum = sendingAgentImpl.getDefaultMaximumIdleTime();
        }
        if (this.idleTimeMaximum == 0L) {
            this.idleTimeMaximum = Long.MAX_VALUE;
        }
        sAFConversationInfo.setMaximumIdleTime(this.idleTimeMaximum);
        this.loggingEnabled = bl;
        this.windowSize = n;
        this.ordered = sAFConversationInfo.isInorder();
        this.sendingAgent = sendingAgentImpl;
        TimerManagerFactory timerManagerFactory = TimerManagerFactory.getTimerManagerFactory();
        this.timerManager = timerManagerFactory.getTimerManager("SAFSENDER_" + this.sendingAgent.getName(), this.sendingAgent.getWorkManager());
        try {
            object = this;
            final SAFAgentAdmin sAFAgentAdmin = this.sendingAgent.getAgentAdmin();
            this.runtimeDelegate = (ConversationRuntimeDelegate)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedExceptionAction)new PrivilegedExceptionAction((ConversationAssembler)object){
                final /* synthetic */ ConversationAssembler val$thisFinal;
                {
                    this.val$thisFinal = conversationAssembler2;
                }

                public Object run() throws ManagementException {
                    return new ConversationRuntimeDelegate(sAFAgentAdmin, this.val$thisFinal);
                }
            });
            this.runtimeDelegate.registerMe();
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ManagementException)((Object)privilegedActionException.getException());
        }
        this.absTTL = ((SAFConversationInfoImpl)sAFConversationInfo).getTimestamp() + this.timeToLive;
        if (this.absTTL < 0L) {
            this.absTTL = Long.MAX_VALUE;
        }
        if (this.timeToLive != Long.MAX_VALUE) {
            long l = this.getTimeLeft();
            if (l <= 0L) {
                this.changeState(8);
            }
            this.timeOutTimer = this.timerManager.schedule((TimerListener)this, l == 0L ? 100L : l);
            this.timeoutCurrent = this.timeOutTimer.getTimeout();
        }
        this.retryDelayBase = (object = sAFConversationInfo.getRemoteContext()) != null && ((SAFRemoteContext)object).getRetryDelayBase() != -1L ? ((SAFRemoteContext)object).getRetryDelayBase() : this.sendingAgent.getDefaultRetryDelayBase();
        this.retryDelayMaximum = object != null && ((SAFRemoteContext)object).getRetryDelayMaximum() != -1L ? ((SAFRemoteContext)object).getRetryDelayMaximum() : this.sendingAgent.getDefaultRetryDelayMaximum();
        if (this.timeToLive != Long.MAX_VALUE && (double)this.retryDelayMaximum > (double)this.timeToLive * 0.5) {
            this.retryDelayMaximum = (long)((double)this.timeToLive * 0.5);
        }
        if (this.idleTimeMaximum != Long.MAX_VALUE && (double)this.retryDelayMaximum > (double)this.idleTimeMaximum * 0.5) {
            this.retryDelayMaximum = (long)((double)this.idleTimeMaximum * 0.5);
        }
        this.retryDelayMultiplier = object != null && ((SAFRemoteContext)object).getRetryDelayMultiplier() != -1L ? (double)((SAFRemoteContext)object).getRetryDelayMultiplier() : this.sendingAgent.getDefaultRetryDelayMultiplier();
        this.retryController = new RetryController(this.retryDelayBase, this.retryDelayMaximum, this.retryDelayMultiplier);
        this.transportRetryListener = new TransportRetryTimerListener();
        this.messageRetryListener = new MessageRetryTimerListener();
        if (!this.isExpired() && this.idleTimeMaximum != Long.MAX_VALUE) {
            long l = System.currentTimeMillis();
            this.rescheduleTimeoutTimer(l, l + this.idleTimeMaximum, true);
        }
        this.remoteEndpoint = this.sendingAgent.findOrCreateRemoteEndpointRuntime(sAFConversationInfo.getDestinationURL(), sAFConversationInfo.getDestinationType(), this.sendingAgent.getKernelTopic(sAFConversationInfo));
        this.remoteEndpoint.addConversation(this.runtimeDelegate);
    }

    public long getLastAssignedSequenceValue() {
        if (this.isClosed()) {
            return 0L;
        }
        Sequence sequence = this.subQueue.findSequence(this.info.getConversationName());
        return sequence.getLastAssignedValue();
    }

    public List getAllSequenceNumberRanges() {
        if (this.isClosed()) {
            return new ArrayList();
        }
        Sequence sequence = this.subQueue.findSequence(this.info.getConversationName());
        return sequence.getAllSequenceNumberRanges();
    }

    long getLastMsgSequenceNumber() {
        return this.lastMsgSequenceNumber;
    }

    void setLastMsgSequenceNumber(long l) {
        this.lastMsgSequenceNumber = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupSubscriptionQueue() throws SAFException {
        if (this.isClosed()) {
            return;
        }
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.sendingAgent.getName() + "': setting up subscription queue for conversation " + this.info.getConversationName());
        }
        Topic topic = this.sendingAgent.getKernelTopic(this.info);
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("Durable", new Boolean(true));
        try {
            Kernel kernel;
            Kernel kernel2 = kernel = this.sendingAgent.getKernel();
            synchronized (kernel2) {
                this.subQueue = kernel.findQueue(this.info.getConversationName());
                if (this.subQueue == null) {
                    this.subQueue = kernel.createQueue(this.info.getConversationName(), hashMap);
                }
            }
            this.subQueue.setProperty("DefaultAssignSequence", (Object)this.info.getConversationName());
            this.subQueue.setProperty("Quota", (Object)topic.getQuota());
            kernel2 = new KernelRequest();
            topic.subscribe(this.subQueue, (Object)new SQLExpression("SAFConversationName='" + this.info.getConversationName() + "'"), (KernelRequest)kernel2);
            kernel2.getResult();
            this.reader = new MessageReader();
            this.subQueue.resume(16384);
            if (this.sendingAgent.isPausedForForwarding() || this.remoteEndpoint.isPausedForForwarding()) {
                this.subQueue.suspend(2);
            }
            if (this.sendingAgent.isPausedForIncoming() || this.remoteEndpoint.isPausedForIncoming()) {
                this.subQueue.suspend(1);
            }
        }
        catch (KernelException kernelException) {
            throw new SAFException(kernelException);
        }
    }

    private boolean isDynamic() {
        return this.info.isDynamic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() throws SAFException {
        Object object;
        if (this.state == 1 && this.info.isConversationAlreadyCreated()) {
            this.changeState(32);
            if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                SAFDebug.SAFSendingAgent.debug("Recover CREATED state according to conversation info");
            }
        }
        Exception exception = null;
        if (this.isClosed()) {
            return;
        }
        ConversationAssembler conversationAssembler = this;
        synchronized (conversationAssembler) {
            if (this.isStarted()) {
                return;
            }
            if (this.state == 16) {
                return;
            }
            if (this.state == 2) {
                return;
            }
            if (!this.info.isDynamic() && !this.isCreated()) {
                if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                    SAFDebug.SAFSendingAgent.debug("Marking non-dynamic conversation '" + this.info.getConversationName() + " CREATED (won't wait for a handle to be returned)");
                }
                this.changeState(32);
            }
            if (!this.isCreated()) {
                this.changeState(16);
            } else {
                this.changeState(2);
            }
        }
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            if (!this.isCreated()) {
                SAFDebug.SAFSendingAgent.debug("Conversation '" + this.getName() + "' == start(): dyanmic conversation has not been created, creating ...");
            } else if (!this.isStarted()) {
                SAFDebug.SAFSendingAgent.debug("Conversation '" + this.getName() + "' == start(): starting the reader ...");
            }
        }
        boolean bl = false;
        try {
            if (!this.isCreated()) {
                Externalizable externalizable = this.transport.createSecurityToken(this.info);
                if (externalizable != null) {
                    object = null;
                    ConversationAssembler conversationAssembler2 = this;
                    synchronized (conversationAssembler2) {
                        object = this.info.getContext();
                        this.info.setContext(externalizable);
                    }
                    try {
                        this.sendingAgent.storeConversationInfo(this.info);
                    }
                    catch (SAFException sAFException) {
                        ConversationAssembler conversationAssembler3 = this;
                        synchronized (conversationAssembler3) {
                            this.info.setContext((Externalizable)object);
                        }
                        throw sAFException;
                    }
                }
                object = this.transport.createConversation(this.info);
                bl = this.processConversationHandle((SAFConversationHandle)object);
            }
            if (this.isCreated() && !this.isStarted()) {
                this.changeState(2);
                if (this.reader != null) {
                    this.reader.start();
                }
                this.cancelTransportRetryTimer();
                this.retryController.reset();
                this.changeState(64);
            }
        }
        catch (Exception exception2) {
            exception = exception2;
            this.resetToLastGoodState(exception2);
        }
        boolean bl2 = false;
        object = this;
        synchronized (object) {
            if (this.isCreated() && this.firstMessage != null && this.messageRetryTimer == null) {
                bl2 = true;
            }
        }
        if (bl2) {
            this.rescheduleMessageRetryTimer();
        }
        if (SAFDebug.SAFVerbose.isDebugEnabled() && SAFDebug.SAFSendingAgent.isDebugEnabled()) {
            if (this.isStarted()) {
                if (bl) {
                    SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.sendingAgent.getName() + "': successfully started conversation " + this);
                }
            } else if (exception != null) {
                SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.sendingAgent.getName() + "': failed to start conversation " + this.info.getConversationName() + " " + exception.toString() + ", will retry later");
                exception.printStackTrace();
            } else {
                SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.sendingAgent.getName() + "': waiting for create conversation callback for " + this.info.getConversationName());
            }
        }
        if (exception != null) {
            if (exception instanceof SAFException) {
                throw (SAFException)exception;
            }
            throw new SAFException("Failed to start conversation " + this.info.getConversationName(), exception);
        }
    }

    private synchronized void resetToLastGoodState(Throwable throwable) {
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Resetting to last 'good' state for conversation '" + this.info.getConversationName());
            if (throwable == null) {
                throwable = new Exception("Debug resetToLastGoodState");
            }
            throwable.printStackTrace();
        }
        if (this.state == 2 || this.state == 64) {
            this.changeState(32);
        } else if (this.state == 16) {
            this.changeState(1);
        } else if (this.state != 32 && this.state != 1) {
            this.changeState(1);
        }
    }

    private synchronized void changeState(int n) {
        boolean bl;
        this.logStateChange(this.state, n);
        this.state = n;
        boolean bl2 = bl = this.isCreated() && !this.info.isConversationAlreadyCreated() || !this.isCreated() && this.info.isConversationAlreadyCreated();
        if (bl) {
            this.info.setConversationAlreadyCreated(!this.info.isConversationAlreadyCreated());
            try {
                this.sendingAgent.storeConversationInfo(this.info);
            }
            catch (SAFStoreException sAFStoreException) {
                sAFStoreException.printStackTrace();
            }
        }
    }

    private void logStateChange(int n, int n2) {
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            String string = ConversationAssembler.getStateStr(n);
            String string2 = ConversationAssembler.getStateStr(n2);
            SAFDebug.SAFSendingAgent.debug("Conversation '" + this.getName() + "' setting state to " + string2 + " from state " + string);
        }
    }

    private static String getStateStr(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "STATE_INITIAL";
                break;
            }
            case 2: {
                string = "STATE_STARTING";
                break;
            }
            case 64: {
                string = "STATE_STARTED";
                break;
            }
            case 16: {
                string = "STATE_CREATING";
                break;
            }
            case 32: {
                string = "STATE_CREATED";
                break;
            }
            case 4: {
                string = "STATE_DESTROYED";
                break;
            }
            case 8: {
                string = "STATE_EXPIRED";
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        return string;
    }

    void startFromADiffThread() {
        if (!this.isStarted()) {
            this.transportRetryTimer = this.timerManager.schedule((TimerListener)this.transportRetryListener, 100L);
        }
    }

    private void processConversationTimeout(long l, SAFConversationHandle sAFConversationHandle) {
        long l2 = sAFConversationHandle.getConversationTimeout();
        long l3 = Long.MAX_VALUE;
        if (l2 != Long.MAX_VALUE && (l3 = l + l2) < 0L) {
            l3 = Long.MAX_VALUE;
        }
        this.timeToLive = l2;
        this.rescheduleTimeoutTimer(l, l3, true);
    }

    private void processConversationMaxIdleTime(long l, SAFConversationHandle sAFConversationHandle) {
        long l2 = sAFConversationHandle.getConversationMaxIdleTime();
        long l3 = Long.MAX_VALUE;
        if (this.idleTimeMaximum > l2) {
            if (l2 != Long.MAX_VALUE) {
                l3 = l + l2;
            }
            this.idleTimeMaximum = l2;
        } else if (this.idleTimeMaximum != Long.MAX_VALUE) {
            l3 = l + this.idleTimeMaximum;
        }
        if (l3 < 0L) {
            l3 = Long.MAX_VALUE;
        }
        this.rescheduleTimeoutTimer(l, l3, true);
    }

    void createAndRecordDynamicConversation(String string, String string2) {
        if (this.sendingAgent != null) {
            this.sendingAgent.addDynamicName(string, string2);
            this.safManager.recordDynamicName(string, string2);
        }
    }

    long getTimeLeft() {
        long l = System.currentTimeMillis();
        return this.getTimeLeft(l, this.absTTL);
    }

    private long getTimeLeft(long l, long l2) {
        if (l2 != 0L) {
            long l3 = l2 - l;
            if (l3 <= 0L) {
                return 0L;
            }
            return l3;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageReference addMessage(MessageElement messageElement) {
        if (this.isClosed()) {
            return null;
        }
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.sendingAgent.getName() + "': message reader is about to add message: " + ((SAFRequest)messageElement.getMessage()).getMessageId() + "' sequence number: " + messageElement.getSequenceNum() + " to the conversation " + ((SAFRequest)messageElement.getMessage()).getConversationName());
        }
        SAFRequestImpl sAFRequestImpl = (SAFRequestImpl)messageElement.getMessage();
        sAFRequestImpl.setSequenceNumber(messageElement.getSequenceNum());
        MessageReference messageReference = new MessageReference(messageElement, this.retryDelayMultiplier, this.retryDelayBase, this.retryDelayMaximum);
        if (this.isNotAvail()) {
            this.rejectOneMessage(messageReference, 5, null, true);
            return messageReference;
        }
        ConversationAssembler conversationAssembler = this;
        synchronized (conversationAssembler) {
            this.addMessageToList(messageReference);
        }
        if (this.idleTimeMaximum != 0L && this.idleTimeMaximum != Long.MAX_VALUE) {
            this.rescheduleTimeoutTimer(System.currentTimeMillis() + this.idleTimeMaximum);
        }
        if (sAFRequestImpl.isEndOfConversation()) {
            this.setSeenLastMsg(true);
            this.setLastMsgSequenceNumber(sAFRequestImpl.getSequenceNumber());
        }
        return messageReference;
    }

    private void removeMessage(MessageReference messageReference) {
        this.removeMessage(messageReference, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMessage(MessageReference messageReference, boolean bl) {
        if (this.isClosed()) {
            return;
        }
        Object object = this;
        synchronized (object) {
            this.removeMessageFromList(messageReference);
            if (this.firstMessage == null) {
                this.cancelMessageRetryTimer();
            }
        }
        if (bl) {
            try {
                object = new ArrayList(1);
                ((ArrayList)object).add(messageReference.getElement());
                KernelRequest kernelRequest = this.subQueue.acknowledge((List)object);
                if (kernelRequest != null) {
                    kernelRequest.getResult();
                }
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }
        if (!this.isExpired() && this.idleTimeMaximum != 0L && this.idleTimeMaximum != Long.MAX_VALUE) {
            this.rescheduleTimeoutTimer(System.currentTimeMillis() + this.idleTimeMaximum);
        }
    }

    private void rejectOneMessage(MessageReference messageReference, int n, Throwable throwable, boolean bl) {
        messageReference.setFaultCode(n);
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        if (throwable != null) {
            arrayList.add(throwable);
        }
        this.rejectOneMessage(messageReference.getMessage(), messageReference.getFaultCodes(), arrayList, bl);
    }

    private void rejectOneMessage(SAFRequest sAFRequest, ArrayList arrayList, ArrayList arrayList2, boolean bl) {
        Object object;
        if (this.isClosed()) {
            return;
        }
        if (SAFDebug.SAFSendingAgent.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "': rejecting message " + sAFRequest.getSequenceNumber());
        }
        SAFEndpointManager sAFEndpointManager = this.safManager.getEndpointManager(this.info.getDestinationType());
        SAFErrorHandler sAFErrorHandler = this.info.getErrorHandler();
        if (sAFErrorHandler == null) {
            sAFErrorHandler = sAFEndpointManager.getErrorHandler(this.info.getDestinationURL());
        }
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "': Errorhandler =  " + sAFErrorHandler);
        }
        boolean bl2 = false;
        if (sAFErrorHandler != null) {
            if (sAFErrorHandler.isAlwaysForward() && bl) {
                bl2 = true;
            } else if (sAFEndpointManager instanceof SAFErrorAwareEndpointManager) {
                object = (SAFErrorAwareEndpointManager)sAFEndpointManager;
                object.handleFailure(sAFErrorHandler, sAFRequest, arrayList, arrayList2);
            } else {
                sAFEndpointManager.handleFailure(sAFErrorHandler, sAFRequest, arrayList);
            }
        } else {
            bl2 = true;
        }
        if (bl2 && this.loggingEnabled) {
            SAFLogger.logExpiredMessage((String)("'" + sAFRequest.getMessageId() + "'"));
        }
        object = this.sendingAgent.getRemoteEndpoint(this.info.getDestinationURL());
        ((RemoteEndpointRuntimeDelegate)object).increaseFailedMessagesCount();
        this.sendingAgent.increaseFailedMessagesCount();
    }

    private synchronized boolean isNotAvail() {
        return this.state == 8 || this.state == 4 || this.isClosed();
    }

    public synchronized boolean isNotAvailAndClosed() {
        boolean bl = this.state == 8 || this.state == 4 || this.hasSeenLastMsg();
        return bl;
    }

    private synchronized boolean isExpired() {
        return this.state == 8;
    }

    final void close() {
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "' is to be closed");
        }
        this.closeInternal(false);
    }

    final synchronized void delete() {
        if (this.isClosed()) {
            return;
        }
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "' is to be destroyed.");
        }
        boolean bl = true;
        this.safManager.notifyPreConversationClose(true, bl, this.info);
        try {
            this.closeInternal(bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.sendingAgent.removeConversation(this.getName(), true);
            if (this.info.getDynamicConversationName() != null) {
                this.sendingAgent.removeConversation(this.info.getDynamicConversationName(), false);
            }
            this.sendingAgent = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeInternal(boolean bl) {
        if (this.isClosed()) {
            return;
        }
        this.cancelAllTimers();
        if (this.reader != null) {
            this.reader.stop();
        }
        this.reader = null;
        if (bl) {
            block16: {
                try {
                    if (this.isCreated() && this.needNotify) {
                        this.transport.terminateConversation(this.info);
                    }
                }
                catch (SAFException sAFException) {
                    // empty catch block
                }
                try {
                    if (this.sendingAgent == null || this.subQueue == null) break block16;
                    Topic topic = this.sendingAgent.getKernelTopic(this.info);
                    Queue queue = this.subQueue;
                    synchronized (queue) {
                        if (topic != null) {
                            topic.unsubscribe(this.subQueue, new KernelRequest());
                        }
                        this.subQueue.delete(new KernelRequest());
                    }
                }
                catch (KernelException kernelException) {
                    kernelException.printStackTrace();
                }
            }
            this.subQueue = null;
            this.remoteEndpoint = null;
        }
        try {
            if (this.runtimeDelegate != null) {
                this.runtimeDelegate.unregister();
                this.runtimeDelegate = null;
            }
        }
        catch (ManagementException managementException) {
            // empty catch block
        }
        if (this.running) {
            this.running = false;
        }
        this.lastMessage = null;
        this.firstMessage = null;
    }

    private final void complete() {
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "' ==complete(): all acknowledgements are back, " + "we cleanup the conversation and notify receiving side");
        }
        this.needNotify = true;
        this.cancelAllTimers();
        this.delete();
    }

    private synchronized void cancelAllTimers() {
        this.cancelTimeOutTimer();
        this.cancelTransportRetryTimer();
        this.cancelMessageRetryTimer();
    }

    private synchronized boolean isDestroyed() {
        return this.state == 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void expireAllMessages(int n, Throwable throwable) throws KernelException {
        if (this.isClosed()) {
            return;
        }
        this.cancelAllTimers();
        MessageReference messageReference = null;
        ConversationAssembler conversationAssembler = this;
        synchronized (conversationAssembler) {
            messageReference = this.firstMessage;
        }
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "': expiring all messages left in the conversation" + " firstMessage = " + messageReference);
        }
        while (messageReference != null) {
            this.destroyOneMessage(messageReference, n, throwable);
            conversationAssembler = this;
            synchronized (conversationAssembler) {
                messageReference = this.firstMessage;
            }
        }
        conversationAssembler = null;
        try {
            if (this.subQueue != null) {
                conversationAssembler = this.subQueue.createCursor(true, null, -1);
            }
        }
        catch (KernelException kernelException) {
            if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                kernelException.printStackTrace();
            }
            throw kernelException;
        }
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "': expiring " + conversationAssembler.size() + " messages left in the queue");
        }
        if (conversationAssembler != null) {
            MessageElement messageElement;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(new Integer(n));
            ArrayList<Throwable> arrayList2 = new ArrayList<Throwable>();
            if (throwable != null) {
                arrayList2.add(throwable);
            }
            if (this.lastSendError != null) {
                arrayList2.add(this.lastSendError);
            }
            while ((messageElement = conversationAssembler.next()) != null) {
                SAFRequest sAFRequest = (SAFRequest)messageElement.getMessage();
                this.rejectOneMessage(sAFRequest, arrayList, arrayList2, true);
                KernelRequest kernelRequest = this.subQueue.delete(messageElement);
                if (kernelRequest == null) continue;
                kernelRequest.getResult();
            }
        }
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "': expired all messages");
        }
    }

    public void destroy() {
        this.needNotify = true;
        this.destroyInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyInternal() {
        ConversationAssembler conversationAssembler = this;
        synchronized (conversationAssembler) {
            if (!this.isExpired()) {
                this.changeState(4);
            }
        }
        this.destroyAllMessages();
        this.delete();
    }

    private void destroyAllMessages() {
        if (this.isClosed()) {
            return;
        }
        KernelRequest kernelRequest = new KernelRequest();
        try {
            this.subQueue.empty(kernelRequest);
            kernelRequest.getResult();
        }
        catch (KernelException kernelException) {
            // empty catch block
        }
    }

    private void disconnected(Exception exception) {
        if (this.isClosed()) {
            return;
        }
        this.remoteEndpoint.disconnected(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processConversationHandle(SAFConversationHandle sAFConversationHandle) throws SAFException {
        if (sAFConversationHandle != null) {
            if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                SAFDebug.SAFSendingAgent.debug("Processing handle for conversation '" + this.info.getConversationName() + "' in state " + ConversationAssembler.getStateStr(this.state));
            }
            long l = System.currentTimeMillis();
            String string = null;
            String string2 = sAFConversationHandle.getDynamicConversationName();
            boolean bl = false;
            SAFConversationInfo sAFConversationInfo = sAFConversationHandle.getOffer();
            Externalizable externalizable = sAFConversationHandle.getConversationContext();
            ConversationAssembler conversationAssembler = this;
            synchronized (conversationAssembler) {
                if (this.info.getDynamicConversationName() != null) {
                    if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                        SAFDebug.SAFSendingAgent.debug("Handle already processed for conversation '" + this.info.getConversationName() + "' in state " + ConversationAssembler.getStateStr(this.state) + ". Ignoring this handle");
                    }
                    return false;
                }
                this.info.setTimeToLive(this.timeToLive);
                this.info.setMaximumIdleTime(this.idleTimeMaximum);
                this.info.setConversationOffer(sAFConversationHandle.getOffer());
                if (externalizable != null) {
                    this.info.setContext(externalizable);
                }
                string = this.info.getConversationName();
                this.info.setDynamicConversationName(string2);
                if (string2 != null && !string2.equals(this.info.getConversationName())) {
                    bl = true;
                }
                try {
                    if (sAFConversationInfo != null) {
                        this.safManager.registerConversationOnReceivingSide(sAFConversationInfo, null, null);
                    }
                    this.sendingAgent.storeConversationInfo(this.info);
                }
                catch (SAFException sAFException) {
                    ConversationAssembler conversationAssembler2 = this;
                    synchronized (conversationAssembler2) {
                        this.info.setDynamicConversationName(null);
                    }
                    throw sAFException;
                }
                if (bl) {
                    this.createAndRecordDynamicConversation(string, string2);
                }
                this.processConversationTimeout(l, sAFConversationHandle);
                this.processConversationMaxIdleTime(l, sAFConversationHandle);
                this.changeState(32);
            }
            return true;
        }
        if (!this.info.isDynamic()) {
            this.changeState(32);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCreateConversationSucceed(SAFConversationHandle sAFConversationHandle) {
        ConversationAssembler conversationAssembler;
        if (SAFDebug.SAFVerbose.isDebugEnabled() && SAFDebug.SAFSendingAgent.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.sendingAgent.getName() + "': onCreateConversationSucceed " + this.info.getConversationName() + " processing async/dynamic handle");
        }
        ConversationAssembler conversationAssembler2 = this;
        synchronized (conversationAssembler2) {
            if (this.isClosed()) {
                return;
            }
            if (this.state != 16) {
                throw new IllegalStateException("Ouch. We haven't started creating conversation '" + this.info.getConversationName() + "' but yet we just got an async conversation handle. Cannot proceed");
            }
        }
        this.cancelTransportRetryTimer();
        boolean bl = false;
        Throwable throwable = null;
        try {
            this.processConversationHandle(sAFConversationHandle);
        }
        catch (SAFException sAFException) {
            ConversationAssembler conversationAssembler3 = this;
            synchronized (conversationAssembler3) {
                this.resetToLastGoodState(sAFException);
            }
            this.rescheduleTransportRetryTimer();
            if (SAFDebug.SAFVerbose.isDebugEnabled() && SAFDebug.SAFSendingAgent.isDebugEnabled()) {
                SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.sendingAgent.getName() + "': failed to start conversation " + this.info.getConversationName() + " " + throwable.getMessage() + ", will retry later");
            }
            return;
        }
        try {
            if (this.isCreated() && !this.isStarted()) {
                this.changeState(2);
                if (this.reader != null) {
                    this.reader.start();
                }
                this.changeState(64);
                this.retryController.reset();
            }
        }
        catch (SAFException sAFException) {
            conversationAssembler = this;
            synchronized (conversationAssembler) {
                this.resetToLastGoodState(sAFException);
            }
        }
        if (!this.isStarted()) {
            this.rescheduleTransportRetryTimer();
        }
        boolean bl2 = false;
        conversationAssembler = this;
        synchronized (conversationAssembler) {
            if (this.isCreated() && this.firstMessage != null && this.messageRetryTimer == null) {
                bl2 = true;
            }
        }
        if (bl2) {
            this.rescheduleMessageRetryTimer();
        }
        if (SAFDebug.SAFVerbose.isDebugEnabled() && SAFDebug.SAFSendingAgent.isDebugEnabled()) {
            if (this.isStarted()) {
                SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.sendingAgent.getName() + "' onCreateConversationSucceeded():" + " successfully started conversation " + this.info + ", retryDelaybase = " + this.retryDelayBase + ", retryDelayMaximum = " + this.retryDelayMaximum + ", retryDelayMultiplier = " + this.retryDelayMultiplier);
            } else {
                SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.sendingAgent.getName() + "' onCreateConversationSucceeded():" + " couldn't start conversation " + this.info);
            }
        }
    }

    private static void cancelTimer(Timer timer) {
        if (timer != null) {
            timer.cancel();
        }
    }

    private void cancelTimeOutTimer() {
        ConversationAssembler.cancelTimer(this.timeOutTimer);
        this.timeOutTimer = null;
    }

    private void rescheduleTimeoutTimer(long l) {
        this.rescheduleTimeoutTimer(System.currentTimeMillis(), l, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescheduleTimeoutTimer(long l, long l2, boolean bl) {
        ConversationAssembler conversationAssembler = this;
        synchronized (conversationAssembler) {
            if (l2 < 0L && l < this.absTTL) {
                l2 = this.absTTL;
            }
            if (bl && l2 >= this.timeoutCurrent || l2 == Long.MAX_VALUE || l2 < 0L) {
                return;
            }
            if (this.absTTL < l2) {
                l2 = this.absTTL;
            }
            ConversationAssembler.cancelTimer(this.timeOutTimer);
            this.timeOutTimer = this.timerManager.schedule((TimerListener)this, new Date(l2));
            this.timeoutCurrent = l2;
        }
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "': reschedule timeout timer: old  = " + this.timeoutCurrent + " new = " + l2 + " currentTime = " + l + " isConversationSetup = " + bl);
        }
    }

    private void cancelMessageRetryTimer() {
        ConversationAssembler.cancelTimer(this.messageRetryTimer);
        this.messageRetryTimer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescheduleMessageRetryTimer() {
        long l = -1L;
        ConversationAssembler conversationAssembler = this;
        synchronized (conversationAssembler) {
            if (this.firstMessage == null) {
                return;
            }
            this.cancelMessageRetryTimer();
            l = this.firstMessage.getNextRetryDelay();
            this.messageRetryTimer = this.timerManager.schedule((TimerListener)this.messageRetryListener, l);
        }
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "': reschedule message retry timer: delay = " + l);
        }
    }

    private void rescheduleTransportRetryTimer() {
        this.rescheduleTransportRetryTimer(this.retryController.getNextRetry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescheduleTransportRetryTimer(long l) {
        ConversationAssembler conversationAssembler = this;
        synchronized (conversationAssembler) {
            if (this.transportRetryTimer != null) {
                return;
            }
            if (this.isStarted()) {
                return;
            }
            this.transportRetryTimer = this.timerManager.schedule((TimerListener)this.transportRetryListener, l);
        }
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "': reschedule transport retry timer: delay = " + l);
        }
    }

    private synchronized void cancelTransportRetryTimer() {
        ConversationAssembler.cancelTimer(this.transportRetryTimer);
        this.transportRetryTimer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acknowledge(long l, long l2) throws SAFException {
        MessageReference messageReference;
        int n;
        block24: {
            if (this.isClosed()) {
                return;
            }
            if (SAFDebug.SAFSendingAgent.isDebugEnabled()) {
                SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "': acknowledging  low=" + l + " high=" + l2);
            }
            this.safManager.notifyAckConversation(this.info, l, l2);
            n = 0;
            ArrayList<MessageElement> arrayList = new ArrayList<MessageElement>();
            Object object = null;
            messageReference = null;
            Object object2 = this;
            synchronized (object2) {
                object = this.firstMessage;
                messageReference = this.firstMessage;
            }
            while (object != null && ((MessageReference)object).getSequenceNumber() <= l2) {
                object2 = ((MessageReference)object).getNext();
                if (((MessageReference)object).getSequenceNumber() >= l) {
                    if (((MessageReference)object).getElement() != null) {
                        arrayList.add(((MessageReference)object).getElement());
                    }
                    this.removeMessage((MessageReference)object, false);
                    if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                        SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "' ==acknowledge(): removed " + ((MessageReference)object).getSequenceNumber() + " from the conversation");
                    }
                }
                object = object2;
            }
            if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "' ==acknowledge(): number of messages to be acknowledged = " + arrayList.size());
            }
            if ((n = arrayList.size()) > 0) {
                try {
                    Object object3 = object2 = this.subQueue != null ? this.subQueue.acknowledge(arrayList) : null;
                    if (object2 != null) {
                        object2.getResult();
                    }
                }
                catch (KernelException kernelException) {
                    if (!SAFDebug.SAFSendingAgent.isDebugEnabled() || !SAFDebug.SAFVerbose.isDebugEnabled()) break block24;
                    SAFDebug.SAFSendingAgent.debug("Sending Agent '" + this.sendingAgent.getName() + "': acknowledging to kernel: failed ");
                    kernelException.printStackTrace();
                }
            }
        }
        int n2 = 0;
        boolean bl = false;
        ConversationAssembler conversationAssembler = this;
        synchronized (conversationAssembler) {
            if (messageReference != this.firstMessage) {
                bl = true;
            }
            this.lastAckedSequenceNumber = l2;
            this.windowSize += n;
            n2 = this.windowSize;
        }
        if (this.reader != null) {
            this.reader.incrementWindow(n);
        }
        if (bl) {
            this.rescheduleMessageRetryTimer();
        }
        Object object = conversationAssembler = this.subQueue != null ? this.subQueue.findSequence(this.info.getConversationName()) : null;
        if (conversationAssembler != null) {
            long l3 = conversationAssembler.getLastAssignedValue() + 1L;
            long l4 = 0L;
            long l5 = 0L;
            boolean bl2 = false;
            if (l2 >= l3) {
                bl2 = true;
                l5 = l2;
                l4 = l >= l3 ? l : l3;
            }
            if (bl2) {
                throw new SAFInvalidAcknowledgementsException("Conversation '" + this.getName() + " got acknowledgements for " + " messages that have not been sent " + l4 + ":" + l5);
            }
        }
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "': acknowledge(): windowSize = " + n2);
        }
        this.checkCompleted();
    }

    synchronized void checkCompleted() {
        if (this.isClosed()) {
            return;
        }
        boolean bl = false;
        if (this.lastAckedSequenceNumber == this.lastMsgSequenceNumber && this.isDone()) {
            bl = true;
        }
        if (bl) {
            this.sendingAgent.getWorkManager().schedule((Runnable)new WorkAdapter(){

                public void run() {
                    ConversationAssembler.this.complete();
                }
            });
            return;
        }
    }

    private int getAvailableSlots() {
        return this.windowSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean sendOneMessage(MessageReference messageReference) throws SAFException {
        if (!this.isCreated()) {
            throw new SAFException("Conversation Not started");
        }
        if (this.isClosed()) {
            return false;
        }
        if (SAFDebug.SAFSendingAgent.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "' ==sendOneMessage(): sequence number =" + messageReference.getSequenceNumber());
        }
        if (messageReference.isExpired() && !this.expireOneMessage(messageReference, 11, !this.transport.isGapsAllowed())) {
            return false;
        }
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "' ==sendOneMessage(): sending message:" + messageReference.getSequenceNumber() + " to transport");
        }
        try {
            Externalizable externalizable = this.transport.send(this.info, messageReference.getMessage());
            if (externalizable != null) {
                Externalizable externalizable2 = null;
                try {
                    SAFConversationInfo sAFConversationInfo = this.info;
                    synchronized (sAFConversationInfo) {
                        externalizable2 = this.info.getContext();
                        this.info.setContext(externalizable);
                    }
                    if (this.sendingAgent != null) {
                        this.sendingAgent.storeConversationInfo(this.info);
                    }
                }
                catch (SAFException sAFException) {
                    SAFConversationInfo sAFConversationInfo = this.info;
                    synchronized (sAFConversationInfo) {
                        this.info.setContext(externalizable2);
                    }
                }
            }
            if (this.remoteEndpoint != null) {
                this.remoteEndpoint.connected();
            }
        }
        catch (SAFTransportException sAFTransportException) {
            if (this.remoteEndpoint != null) {
                this.remoteEndpoint.disconnected(sAFTransportException);
            }
            throw sAFTransportException;
        }
        return true;
    }

    private void destroyOneMessage(MessageReference messageReference, int n, Throwable throwable) {
        if (SAFDebug.SAFSendingAgent.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "' has been destroyed either because timeout or" + " destroyed by the administrator");
        }
        if (!messageReference.hasBeenHandled()) {
            this.rejectOneMessage(messageReference, n, throwable, true);
        }
        this.removeMessage(messageReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean expireOneMessage(MessageReference messageReference, int n, boolean bl) {
        if (this.info.getErrorHandler() != null && this.info.getErrorHandler().isAlwaysForward()) {
            if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "' ==expireOneMessage(): " + messageReference.getMessage().getSequenceNumber() + " has expired, but will still be forwarded.");
            }
            return true;
        }
        if (SAFDebug.SAFSendingAgent.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "': message " + messageReference.getMessage().getSequenceNumber() + " has expired");
        }
        if (!messageReference.hasBeenHandled()) {
            this.rejectOneMessage(messageReference, n, null, false);
        }
        boolean bl2 = false;
        if (!bl) {
            ConversationAssembler conversationAssembler = this;
            synchronized (conversationAssembler) {
                if (messageReference == this.firstMessage) {
                    bl2 = true;
                }
            }
            this.removeMessage(messageReference);
            if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "': firstMessage = " + this.firstMessage + " lastMessage = " + this.lastMessage + " hasSeenLastMsg " + this.hasSeenLastMsg());
                if (this.firstMessage != null) {
                    SAFDebug.SAFSendingAgent.debug("first sequence number = " + this.firstMessage.getMessage().getSequenceNumber());
                }
            }
            boolean bl3 = false;
            ConversationAssembler conversationAssembler2 = this;
            synchronized (conversationAssembler2) {
                if (this.hasSeenLastMsg() && this.firstMessage == this.lastMessage && this.firstMessage != null && this.firstMessage.getMessage().getPayload() == null) {
                    this.removeMessage(this.firstMessage);
                    bl3 = true;
                    bl2 = false;
                }
            }
            if (bl3) {
                this.complete();
            }
        } else {
            MessageReference messageReference2 = messageReference;
            synchronized (messageReference2) {
                SAFRequest sAFRequest = messageReference.getMessage();
                sAFRequest.setPayload(null);
            }
        }
        if (bl2) {
            this.rescheduleMessageRetryTimer();
        }
        return bl;
    }

    ConversationRuntimeDelegate getRuntimeDelegate() {
        return this.runtimeDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerExpired(Timer timer) {
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "': timed out");
        }
        ConversationAssembler conversationAssembler = this;
        synchronized (conversationAssembler) {
            this.changeState(8);
            this.needNotify = false;
        }
        try {
            this.expireAllMessages(8, null);
            this.destroyInternal();
        }
        catch (KernelException kernelException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() {
        if (this.isClosed()) {
            return;
        }
        ConversationAssembler conversationAssembler = this;
        synchronized (conversationAssembler) {
            if (this.running) {
                return;
            }
            this.running = true;
        }
        this.sendingAgent.getWorkManager().schedule((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        ConversationAssembler conversationAssembler;
        Object object = null;
        Object object2 = this;
        synchronized (object2) {
            if (this.firstMessage == null) {
                this.running = false;
                return;
            }
            object = this.firstMessage;
        }
        while (object != null && !this.isDestroyed()) {
            try {
                object2 = ((MessageReference)object).getNext();
                if (!this.sendOneMessage((MessageReference)object)) {
                    conversationAssembler = this;
                    synchronized (conversationAssembler) {
                        ++this.windowSize;
                    }
                }
                if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                    SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "' ==retry(): successfully sent " + " message: " + ((MessageReference)object).getSequenceNumber() + " to the transport");
                }
                object = object2;
                this.lastSendError = null;
            }
            catch (SAFException sAFException) {
                this.disconnected(sAFException);
                this.handleExceptionFromSendingMessage(sAFException, (MessageReference)object);
                break;
            }
        }
        boolean bl = false;
        conversationAssembler = this;
        synchronized (conversationAssembler) {
            if (this.firstMessage != null) {
                bl = true;
            }
            this.running = false;
        }
        if (bl) {
            this.rescheduleMessageRetryTimer();
        }
    }

    private void handleExceptionFromSendingMessage(Exception exception, MessageReference messageReference) {
        if (this.transport instanceof SAFErrorAwareTransport) {
            SAFErrorAwareTransport sAFErrorAwareTransport = (SAFErrorAwareTransport)this.transport;
            if (sAFErrorAwareTransport.isPermanentError(exception)) {
                this.rejectOneMessage(messageReference, 20, exception, true);
                this.removeMessage(messageReference);
                return;
            }
            this.lastSendError = exception;
        } else {
            this.lastSendError = exception;
        }
    }

    private synchronized boolean isStarted() {
        return this.isCreated() && this.reader != null && this.reader.isStarted();
    }

    private synchronized boolean isCreated() {
        return this.state != 1 && this.state != 16;
    }

    private synchronized boolean isClosed() {
        return this.sendingAgent == null || this.runtimeDelegate == null || this.remoteEndpoint == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureStarted() {
        boolean bl = true;
        Object var2_2 = null;
        try {
            this.start();
            this.lastSendError = null;
        }
        catch (SAFException sAFException) {
            bl = this.handleSAFExceptionFromStartingConversation(sAFException);
        }
        if (bl) {
            ConversationAssembler conversationAssembler = this;
            synchronized (conversationAssembler) {
                if (!this.isStarted()) {
                    this.rescheduleTransportRetryTimer();
                } else {
                    this.cancelTransportRetryTimer();
                }
            }
        }
    }

    private boolean handleSAFExceptionFromStartingConversation(Exception exception) {
        boolean bl = true;
        if (this.transport instanceof SAFErrorAwareTransport) {
            SAFErrorAwareTransport sAFErrorAwareTransport = (SAFErrorAwareTransport)this.transport;
            if (sAFErrorAwareTransport.isPermanentError(exception)) {
                bl = false;
                try {
                    this.expireAllMessages(20, exception);
                }
                catch (KernelException kernelException) {}
            } else {
                this.lastSendError = exception;
            }
        } else {
            this.lastSendError = exception;
        }
        return bl;
    }

    public String toString() {
        return this.info + "," + " retryMultiplier = " + this.retryDelayMultiplier + "," + " retryDelayBase = " + this.retryDelayBase + "," + " retryDelayMaximum = " + this.retryDelayMaximum;
    }

    Queue getSubscriptionQueue() {
        return this.subQueue;
    }

    void resumeReader() throws KernelException {
        if (this.isClosed()) {
            return;
        }
        this.subQueue.resume(2);
    }

    void pauseReader() throws KernelException {
        if (this.isClosed()) {
            return;
        }
        this.subQueue.suspend(2);
    }

    public void dump(SAFDiagnosticImageSource sAFDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        sAFDiagnosticImageSource.checkTimeout();
        xMLStreamWriter.writeStartElement("ConversationAssembler");
        super.dumpAttributes(sAFDiagnosticImageSource, xMLStreamWriter);
        xMLStreamWriter.writeAttribute("lastAckedSequenceNumber", String.valueOf(this.lastAckedSequenceNumber));
        xMLStreamWriter.writeAttribute("retryDelayMultiplier", String.valueOf(this.retryDelayMultiplier));
        xMLStreamWriter.writeAttribute("retryDelayBase", String.valueOf(this.retryDelayBase));
        xMLStreamWriter.writeAttribute("retryDelayMaximum", String.valueOf(this.retryDelayMaximum));
        xMLStreamWriter.writeAttribute("loggingEnabled", String.valueOf(this.loggingEnabled));
        xMLStreamWriter.writeAttribute("windowSize", String.valueOf(this.windowSize));
        xMLStreamWriter.writeAttribute("state", String.valueOf(this.state));
        xMLStreamWriter.writeAttribute("needNotify", String.valueOf(this.needNotify));
        ((SAFConversationInfoImpl)this.getInfo()).dump(sAFDiagnosticImageSource, xMLStreamWriter);
        xMLStreamWriter.writeEndElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleAsyncFault(String string, Exception exception) throws SAFException {
        if (this.isClosed()) {
            return;
        }
        if (SAFDebug.SAFSendingAgent.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("Conversation '" + this.info.getConversationName() + "': handling fault related to message =" + string + " Exception=" + exception.getMessage());
        }
        if (string.equals("-1")) {
            this.handleSAFExceptionFromStartingConversation(exception);
            return;
        }
        MessageReference messageReference = null;
        ConversationAssembler conversationAssembler = this;
        synchronized (conversationAssembler) {
        }
        for (messageReference = this.firstMessage; messageReference != null && !string.equals(messageReference.getMessage().getMessageId()); messageReference = messageReference.getNext()) {
        }
        if (messageReference == null) {
            return;
        }
        this.handleExceptionFromSendingMessage(exception, messageReference);
    }

    private final class MessageRetryTimerListener
    implements NakedTimerListener {
        private MessageRetryTimerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timerExpired(Timer timer) {
            ConversationAssembler conversationAssembler = ConversationAssembler.this;
            synchronized (conversationAssembler) {
                ConversationAssembler.this.messageRetryTimer = null;
                if (ConversationAssembler.this.isNotAvail()) {
                    return;
                }
            }
            if (SAFDebug.SAFSendingAgent.isDebugEnabled()) {
                SAFDebug.SAFSendingAgent.debug("Conversation '" + ConversationAssembler.this.info.getConversationName() + "': message retry timer expired");
            }
            ConversationAssembler.this.doRun();
        }
    }

    private final class TransportRetryTimerListener
    implements NakedTimerListener {
        private TransportRetryTimerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timerExpired(Timer timer) {
            ConversationAssembler conversationAssembler = ConversationAssembler.this;
            synchronized (conversationAssembler) {
                ConversationAssembler.this.transportRetryTimer = null;
                if (ConversationAssembler.this.isNotAvail()) {
                    return;
                }
            }
            if (SAFDebug.SAFSendingAgent.isDebugEnabled()) {
                SAFDebug.SAFSendingAgent.debug("Conversation '" + ConversationAssembler.this.info.getConversationName() + "': transport retry timer expired");
            }
            ConversationAssembler.this.ensureStarted();
        }
    }

    private final class MessageReader
    extends DeliveryList
    implements Listener {
        private ListenRequest queueConsumer;
        private final KernelRequest completion = new KernelRequest();

        MessageReader() {
            this.setWorkManager(ConversationAssembler.this.sendingAgent.getWorkManager());
            this.initDeliveryList(ConversationAssembler.this.windowSize, 25, 0, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void start() throws SAFException {
            if (ConversationAssembler.this.isClosed()) {
                return;
            }
            ConversationAssembler conversationAssembler = ConversationAssembler.this;
            synchronized (conversationAssembler) {
                int n = ConversationAssembler.this.getAvailableSlots();
                if (this.queueConsumer != null || n == 0) {
                    return;
                }
                try {
                    this.queueConsumer = ConversationAssembler.this.subQueue.listen(null, n, false, (Object)ConversationAssembler.this, (Listener)this, ConversationAssembler.this.getConversationName(), WorkManagerFactory.getInstance().getSystem());
                }
                catch (KernelException kernelException) {
                    throw new SAFException("Error creating consumer on kernel queue", kernelException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void incrementWindow(int n) {
            if (ConversationAssembler.this.isClosed()) {
                return;
            }
            if (n == 0) {
                return;
            }
            boolean bl = false;
            ConversationAssembler conversationAssembler = ConversationAssembler.this;
            synchronized (conversationAssembler) {
                try {
                    if (this.queueConsumer != null) {
                        this.queueConsumer.incrementCount(n);
                        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                            SAFDebug.SAFSendingAgent.debug("Sending Agent '" + ConversationAssembler.this.sendingAgent.getName() + "': message reader for " + ConversationAssembler.this.subQueue.getName() + " has incrmeneted its window by " + n);
                        }
                    }
                }
                catch (KernelException kernelException) {
                    bl = true;
                    this.queueConsumer.stopAndWait();
                    this.queueConsumer = null;
                }
            }
            if (bl) {
                this.negativeAckAll(new ArrayList());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isStarted() {
            ConversationAssembler conversationAssembler = ConversationAssembler.this;
            synchronized (conversationAssembler) {
                return this.queueConsumer != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void pushMessages(List list) {
            boolean bl;
            Iterator iterator = list.iterator();
            ArrayList<MessageElement> arrayList = new ArrayList<MessageElement>();
            boolean bl2 = bl = !this.isStarted();
            while (iterator.hasNext()) {
                if (bl) {
                    arrayList.add((MessageElement)iterator.next());
                }
                while (!bl && iterator.hasNext()) {
                    MessageElement messageElement = (MessageElement)iterator.next();
                    MessageReference messageReference = null;
                    boolean bl3 = false;
                    try {
                        messageReference = ConversationAssembler.this.addMessage(messageElement);
                        if (ConversationAssembler.this.sendOneMessage(messageReference)) {
                            ConversationAssembler conversationAssembler = ConversationAssembler.this;
                            synchronized (conversationAssembler) {
                                if (messageReference == ConversationAssembler.this.firstMessage) {
                                    bl3 = true;
                                }
                                ConversationAssembler.this.windowSize--;
                            }
                            if (bl3) {
                                ConversationAssembler.this.rescheduleMessageRetryTimer();
                            }
                        }
                        ConversationAssembler.this.retryController.reset();
                        ConversationAssembler.this.lastSendError = null;
                    }
                    catch (SAFException sAFException) {
                        if (SAFDebug.SAFSendingAgent.isDebugEnabled()) {
                            SAFDebug.SAFSendingAgent.debug("Conversation '" + ConversationAssembler.this.getName() + "' failed to send message " + ((SAFRequest)messageElement.getMessage()).getSequenceNumber() + " because of " + sAFException.getMessage());
                        }
                        Object object = ConversationAssembler.this;
                        synchronized (object) {
                            bl = true;
                            if (this.queueConsumer != null) {
                                this.queueConsumer.stopAndWait();
                                this.queueConsumer = null;
                            }
                        }
                        if (ConversationAssembler.this.transport instanceof SAFErrorAwareTransport) {
                            object = (SAFErrorAwareTransport)ConversationAssembler.this.transport;
                            if (object.isPermanentError(sAFException)) {
                                ConversationAssembler.this.rejectOneMessage(messageReference, 20, sAFException, true);
                                ConversationAssembler.this.removeMessage(messageReference, false);
                                continue;
                            }
                            ConversationAssembler.this.lastSendError = sAFException;
                            ConversationAssembler.this.removeMessage(messageReference, false);
                            arrayList.add(messageElement);
                            continue;
                        }
                        ConversationAssembler.this.lastSendError = sAFException;
                    }
                }
            }
            if (bl) {
                this.negativeAckAll(arrayList);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void negativeAckAll(ArrayList arrayList) {
            block6: {
                arrayList.addAll(this.getPendingMessages());
                if (arrayList.size() != 0) {
                    this.negativeAck(arrayList, 0L, this.completion);
                }
                try {
                    this.completion.getResult();
                }
                catch (KernelException kernelException) {
                    if (!SAFDebug.SAFSendingAgent.isDebugEnabled()) break block6;
                    SAFDebug.SAFSendingAgent.debug("Conversation '" + ConversationAssembler.this.info.getConversationName() + "': error NACKing kernel messages: " + (Object)((Object)kernelException), (Throwable)kernelException);
                }
            }
            ConversationAssembler conversationAssembler = ConversationAssembler.this;
            synchronized (conversationAssembler) {
                ConversationAssembler.this.resetToLastGoodState(null);
            }
            ConversationAssembler.this.rescheduleTransportRetryTimer();
        }

        private void negativeAck(List list, long l, KernelRequest kernelRequest) {
            if (ConversationAssembler.this.isClosed()) {
                return;
            }
            kernelRequest.reset();
            try {
                ConversationAssembler.this.subQueue.negativeAcknowledge(list, l, kernelRequest);
                kernelRequest.getResult();
            }
            catch (KernelException kernelException) {
                kernelException.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stop() {
            ArrayList arrayList = new ArrayList();
            ConversationAssembler conversationAssembler = ConversationAssembler.this;
            synchronized (conversationAssembler) {
                if (this.queueConsumer != null) {
                    this.queueConsumer.stopAndWait();
                    this.queueConsumer = null;
                }
            }
            arrayList.addAll(this.getPendingMessages());
            if (arrayList.size() != 0) {
                this.negativeAck(arrayList, 0L, this.completion);
            }
        }
    }
}

