/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.internal;

import java.io.Externalizable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.server.SequenceData;
import weblogic.messaging.kernel.Destination;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.Sequence;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFConversationNotAvailException;
import weblogic.messaging.saf.SAFEndpoint;
import weblogic.messaging.saf.SAFEndpointManager;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.SAFRequest;
import weblogic.messaging.saf.SAFTransport;
import weblogic.messaging.saf.SAFTransportType;
import weblogic.messaging.saf.common.SAFConversationInfoImpl;
import weblogic.messaging.saf.common.SAFDebug;
import weblogic.messaging.saf.internal.AgentImpl;
import weblogic.messaging.saf.internal.Conversation;
import weblogic.messaging.saf.internal.MessageReference;
import weblogic.messaging.saf.internal.QOSHandler;
import weblogic.messaging.saf.internal.ReceivingAgentImpl;
import weblogic.messaging.saf.internal.SAFDiagnosticImageSource;
import weblogic.messaging.saf.internal.SAFSequenceData;
import weblogic.messaging.saf.store.SAFStore;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConversationReassembler
extends Conversation
implements NakedTimerListener {
    private SAFEndpoint destination;
    private int windowSize;
    private final ReceivingAgentImpl receivingAgent;
    private final SAFTransport transport;
    private final QOSHandler qosHandler;
    private long ackInterval;
    private long lastAckTime;
    private final int origWindowSize;
    private int qos;
    private QOSWorkRequest workRequest;
    private final SAFEndpointManager safEndpointManager;
    private boolean endpointIsDown = true;
    private long idleTimeMaximum;
    private final TimerManager timerManager;
    private Timer timeOutTimer;
    private long timeoutCurrent = Long.MAX_VALUE;
    private boolean expired = false;
    private boolean closed;
    private long absTTL;
    private boolean establishSAConnection;
    private long lastMsgSequenceNumber = Long.MAX_VALUE;
    private Destination kernelDestination;
    private Sequence sequence;
    private Object operationLock = new Object();
    private boolean firstRun = true;

    ConversationReassembler(ReceivingAgentImpl receivingAgentImpl, int n, SAFEndpoint sAFEndpoint, SAFConversationInfo sAFConversationInfo, SAFStore sAFStore, boolean bl) throws SAFException {
        super(sAFConversationInfo, sAFStore, AgentImpl.getSAFManager());
        this.safEndpointManager = this.safManager.getEndpointManager(sAFConversationInfo.getDestinationType());
        this.windowSize = this.origWindowSize = receivingAgentImpl.getWindowSize();
        this.transport = this.safManager.getTransport(n);
        this.receivingAgent = receivingAgentImpl;
        this.destination = sAFEndpoint;
        this.qosHandler = QOSHandler.getQOSHandler(sAFConversationInfo, this.transport, this.windowSize);
        this.initQOS(sAFConversationInfo);
        this.initAckInterval();
        TimerManagerFactory timerManagerFactory = TimerManagerFactory.getTimerManagerFactory();
        this.timerManager = timerManagerFactory.getTimerManager("SAFRECEIVER_" + receivingAgentImpl.getName(), receivingAgentImpl.getWorkManager());
        this.initTimeToLive();
        this.absTTL = ((SAFConversationInfoImpl)sAFConversationInfo).getTimestamp() + this.timeToLive;
        if (this.absTTL < 0L) {
            this.absTTL = Long.MAX_VALUE;
        }
        this.initIdleTimeMaximum();
        this.initTimeoutTimer();
        this.establishSAConnection = SAFTransportType.isConnectionless(sAFConversationInfo.getTransportType()) ? true : bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void ensureStarted() throws SAFException {
        if (this.kernelDestination != null) {
            return;
        }
        BEDestinationImpl bEDestinationImpl = JMSServerUtilities.findBEDestinationByJNDIName(this.destination.getTargetQueue());
        if (bEDestinationImpl == null) {
            throw new SAFException("SAF conversation " + this.getName() + " is not ready. BEDestination not found for JNDI name: " + this.destination.getTargetQueue());
        }
        this.kernelDestination = bEDestinationImpl.getKernelDestination();
        if (this.kernelDestination == null) {
            throw new SAFException("SAF conversation " + this.getName() + " is not ready. BEDestination at JNDI name " + this.destination.getTargetQueue() + " didn't have a kernel destination");
        }
        try {
            Object object = this.kernelDestination;
            synchronized (object) {
                this.sequence = this.kernelDestination.findSequence(this.getName());
                if (this.sequence == null) {
                    this.sequence = this.kernelDestination.createSequence(this.getName(), 4);
                    this.sequence.setPassthru(true);
                }
            }
            object = (SequenceData)this.sequence.getUserData();
            if (object != null) {
                this.lastMsgSequenceNumber = ((SAFSequenceData)object).getLastMsgSequenceNumber();
            } else {
                this.sequence.setUserData((Object)new SAFSequenceData(this.info));
            }
            this.qosHandler.setSequence(this.sequence);
        }
        catch (KernelException kernelException) {
            throw new SAFException("Failed to setup conversation " + this.getName(), kernelException);
        }
    }

    private void initTimeoutTimer() {
        long l = System.currentTimeMillis();
        if (this.timeToLive != 0L) {
            if (this.timeToLive != Long.MAX_VALUE) {
                this.timeOutTimer = this.timerManager.schedule((TimerListener)this, this.timeToLive);
                this.timeoutCurrent = this.timeOutTimer.getTimeout();
            }
        } else {
            this.expired = true;
            this.timeoutCurrent = l;
            this.info.setConversationTimeout(0L);
            return;
        }
        this.info.setConversationTimeout(this.timeToLive);
        if (this.idleTimeMaximum != Long.MAX_VALUE) {
            this.rescheduleTimeoutTimer(l, l + this.idleTimeMaximum, false);
        }
    }

    private void initIdleTimeMaximum() {
        long l = this.info.getMaximumIdleTime();
        this.idleTimeMaximum = l == 0L ? this.receivingAgent.getConversationIdleTimeMaximum() : l;
        this.info.setMaximumIdleTime(this.idleTimeMaximum);
    }

    private void initTimeToLive() {
        long l = this.info.getTimeToLive();
        this.timeToLive = l == 0L ? Long.MAX_VALUE : l;
        long l2 = this.receivingAgent.getDefaultTimeToLive();
        boolean bl = (this.info.getTimeoutPolicy() & 1) != 0;
        boolean bl2 = (this.info.getTimeoutPolicy() & 2) != 0;
        long l3 = this.info.getConversationTimeout();
        if (bl2) {
            l3 = l2;
        }
        if (bl) {
            this.timeToLive = l3;
        } else if (this.timeToLive > l3) {
            this.timeToLive = l3;
        }
        this.info.setTimeToLive(this.timeToLive);
    }

    private void initQOS(SAFConversationInfo sAFConversationInfo) {
        this.qos = sAFConversationInfo.getQOS();
        switch (this.qos) {
            case 1: {
                this.workRequest = new ExactlyOnceQOSWorkRequest();
                break;
            }
            case 2: {
                this.workRequest = new AtLeastOnceQOSWorkRequest();
                break;
            }
            case 3: {
                this.workRequest = new AtmostOnceQOSWorkRequest();
                break;
            }
            default: {
                throw new Error(" Unknown QOS. Contact BEA Support");
            }
        }
    }

    private void initAckInterval() {
        this.ackInterval = this.receivingAgent.getAckInterval();
        if (this.qos == 1 && this.ackInterval == -1L) {
            this.ackInterval = Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescheduleTimeoutTimer(long l, long l2, boolean bl) {
        if (SAFDebug.SAFReceivingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFReceivingAgent.debug("Conversation '" + this.info.getConversationName() + "' == rescheduleTimeoutTimer(): old  = " + this.timeoutCurrent + " new = " + l2 + " absTTL = " + this.absTTL);
        }
        ConversationReassembler conversationReassembler = this;
        synchronized (conversationReassembler) {
            if (l2 < 0L && l < this.absTTL) {
                l2 = this.absTTL;
            }
            if (!bl && l2 >= this.timeoutCurrent || l2 == Long.MAX_VALUE || l2 < 0L) {
                return;
            }
            if (this.absTTL < l2) {
                l2 = this.absTTL;
            }
            ConversationReassembler.cancelTimer(this.timeOutTimer);
            this.timeOutTimer = this.timerManager.schedule((TimerListener)this, new Date(l2));
            this.timeoutCurrent = l2;
        }
    }

    private static void cancelTimer(Timer timer) {
        if (timer != null) {
            timer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerExpired(Timer timer) {
        block6: {
            if (SAFDebug.SAFReceivingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                SAFDebug.SAFReceivingAgent.debug("Conversation '" + this.info.getConversationName() + "': timed out");
            }
            try {
                ConversationReassembler conversationReassembler = this;
                synchronized (conversationReassembler) {
                    this.expired = true;
                }
                this.receivingAgent.removeConversation(this.info);
            }
            catch (SAFException sAFException) {
                if (!SAFDebug.SAFReceivingAgent.isDebugEnabled() || !SAFDebug.SAFVerbose.isDebugEnabled()) break block6;
                SAFDebug.SAFReceivingAgent.debug("Conversation '" + this.info.getConversationName() + "': failed to expire " + sAFException.getStackTrace());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(SAFRequest sAFRequest) throws SAFException {
        if (SAFDebug.SAFVerbose.isDebugEnabled() && SAFDebug.SAFReceivingAgent.isDebugEnabled()) {
            SAFDebug.SAFReceivingAgent.debug("Conversation '" + this.info.getConversationName() + "' == addMessage(): " + sAFRequest.getSequenceNumber());
        }
        this.ensureStarted();
        boolean bl = false;
        long l = -1L;
        Object object = this;
        synchronized (object) {
            if (sAFRequest.getSequenceNumber() > this.lastMsgSequenceNumber) {
                throw new SAFException("Cannot send more messages after a message that is marked as last message in the conversation/sequence", 19);
            }
            if (sAFRequest.isEndOfConversation() && !this.hasSeenLastMsg()) {
                this.lastMsgSequenceNumber = sAFRequest.getSequenceNumber();
                bl = true;
                l = this.lastMsgSequenceNumber;
            }
        }
        if (bl) {
            object = (SAFSequenceData)this.sequence.getUserData();
            ((SAFSequenceData)object).setLastMsgSequenceNumber(l);
            try {
                this.sequence.setUserData(object);
            }
            catch (KernelException kernelException) {
                throw new SAFException(kernelException.getMessage(), kernelException);
            }
            this.setSeenLastMsg(true);
        }
        object = new MessageReference(sAFRequest);
        ConversationReassembler conversationReassembler = this;
        synchronized (conversationReassembler) {
            this.addMessageToListInorder((MessageReference)object);
        }
        if (this.idleTimeMaximum != Long.MAX_VALUE) {
            long l2 = System.currentTimeMillis();
            this.rescheduleTimeoutTimer(l2, l2 + this.idleTimeMaximum, true);
        }
        this.scheduleWorkRequestRun();
    }

    long getLastMsgSequenceNumber() {
        return this.lastMsgSequenceNumber;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    @Override
    public final void close() throws SAFException {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close(boolean bl) throws SAFException {
        if (SAFDebug.SAFVerbose.isDebugEnabled() && SAFDebug.SAFReceivingAgent.isDebugEnabled()) {
            SAFDebug.SAFReceivingAgent.debug("Conversation '" + this.info.getConversationName() + "' == close(): destroy = " + bl);
        }
        Object object = this.operationLock;
        synchronized (object) {
            ConversationReassembler.cancelTimer(this.timeOutTimer);
            this.safManager.notifyPreConversationClose(false, bl, this.info);
            this.safManager.closeRAConversation(this.info);
            Sequence sequence = null;
            ConversationReassembler conversationReassembler = this;
            synchronized (conversationReassembler) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                sequence = this.sequence;
                if (this.running) {
                    this.running = false;
                }
                this.lastMessage = null;
                this.firstMessage = null;
                this.establishSAConnection = false;
                this.kernelDestination = null;
                this.sequence = null;
                this.timeOutTimer = null;
                this.workRequest = null;
            }
            if (bl) {
                this.removeConversationInfo();
                try {
                    if (sequence != null) {
                        sequence.delete(false);
                    }
                }
                catch (Exception exception) {
                    throw new SAFException(exception.toString(), exception);
                }
            }
        }
    }

    public void finishConversation() throws SAFException {
        this.close(true);
    }

    void removeConversationInfo() throws SAFException {
        this.store.removeConversationInfo(this.info);
    }

    public final long getLastAcked() throws SAFException {
        this.ensureStarted();
        return this.sequence == null ? 0L : this.sequence.getLastValue();
    }

    public final synchronized void setAgentConnectionEstablished() {
        this.establishSAConnection = true;
    }

    private boolean refreshDestination() {
        SAFEndpoint sAFEndpoint = this.safEndpointManager.getEndpoint(this.info.getDestinationURL());
        if (sAFEndpoint == null) {
            this.endpointIsDown = true;
            return true;
        }
        boolean bl = this.endpointIsDown = !sAFEndpoint.isAvailable();
        if (this.endpointIsDown) {
            this.safEndpointManager.removeEndpoint(this.info.getDestinationURL());
            return this.endpointIsDown;
        }
        this.safEndpointManager.addEndpoint(this.info.getDestinationURL(), sAFEndpoint);
        this.destination = sAFEndpoint;
        return this.endpointIsDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleWorkRequestRun() {
        boolean bl;
        if (this.isClosed() || this.workRequest.isScheduled()) {
            return;
        }
        Object object = this;
        synchronized (object) {
            bl = this.endpointIsDown && !this.firstRun;
            this.firstRun = false;
            if (this.isConversationNotRunnable()) {
                return;
            }
            this.running = true;
        }
        if (bl) {
            object = this.workRequest.scheduledMonitor;
            synchronized (object) {
                if (this.workRequest.setScheduled()) {
                    this.timerManager.schedule((TimerListener)new DelayedScheduleTimerListener(), 10000L);
                }
            }
        }
        object = this.workRequest.scheduledMonitor;
        synchronized (object) {
            if (this.workRequest.setScheduled()) {
                this.receivingAgent.getWorkManager().schedule((Runnable)((Object)this.workRequest));
            }
        }
    }

    private boolean isConversationNotRunnable() {
        boolean bl = !this.establishSAConnection || this.endpointIsDown && (this.endpointIsDown = this.refreshDestination()) || this.running || this.expired;
        return bl;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public List<Long> getAllSequenceNumberRanges() {
        if (this.sequence != null) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (Object e : this.sequence.getAllSequenceNumberRanges()) {
                arrayList.add((Long)e);
            }
            return arrayList;
        }
        return new ArrayList<Long>();
    }

    public String toString() {
        return this.info.toString();
    }

    public void dump(SAFDiagnosticImageSource sAFDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        sAFDiagnosticImageSource.checkTimeout();
        xMLStreamWriter.writeStartElement("ConversationReassembler");
        super.dumpAttributes(sAFDiagnosticImageSource, xMLStreamWriter);
        xMLStreamWriter.writeAttribute("destination", this.destination.toString());
        xMLStreamWriter.writeAttribute("windowSize", String.valueOf(this.windowSize));
        xMLStreamWriter.writeAttribute("ackInterval", String.valueOf(this.ackInterval));
        xMLStreamWriter.writeAttribute("lastAckTime", String.valueOf(this.lastAckTime));
        xMLStreamWriter.writeAttribute("endpointIsDown", String.valueOf(this.endpointIsDown));
        ((SAFConversationInfoImpl)this.getInfo()).dump(sAFDiagnosticImageSource, xMLStreamWriter);
        xMLStreamWriter.writeEndElement();
    }

    private final class AtmostOnceQOSWorkRequest
    extends QOSWorkRequest {
        private AtmostOnceQOSWorkRequest() {
        }

        protected final boolean processRequestBeforeAck(MessageReference messageReference) {
            this.updateQOSHandler(messageReference, 0);
            return false;
        }

        protected final boolean processRequestsAfterAck(MessageReference messageReference, MessageReference messageReference2) {
            MessageReference messageReference3 = messageReference;
            boolean bl = false;
            do {
                if (!(bl = this.processRequest(messageReference3, true))) continue;
                return bl;
            } while (messageReference3 != messageReference2 && (messageReference3 = messageReference3.getNext()) != null);
            return false;
        }
    }

    private final class AtLeastOnceQOSWorkRequest
    extends QOSWorkRequest {
        private AtLeastOnceQOSWorkRequest() {
        }
    }

    private final class ExactlyOnceQOSWorkRequest
    extends QOSWorkRequest {
        private ExactlyOnceQOSWorkRequest() {
        }
    }

    private class QOSWorkRequest
    extends WorkAdapter {
        private final Object scheduledMonitor = "ScheduledMonitor";
        private boolean scheduled;

        private QOSWorkRequest() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean setScheduled() {
            Object object = this.scheduledMonitor;
            synchronized (object) {
                if (this.scheduled) {
                    return false;
                }
                this.scheduled = true;
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isScheduled() {
            Object object = this.scheduledMonitor;
            synchronized (object) {
                return this.scheduled;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void run() {
            MessageReference messageReference = null;
            MessageReference messageReference2 = null;
            MessageReference messageReference3 = null;
            boolean bl = false;
            try {
                block43: {
                    Object object;
                    boolean bl2;
                    try {
                        while (true) {
                            ConversationReassembler conversationReassembler = ConversationReassembler.this;
                            synchronized (conversationReassembler) {
                                if (!ConversationReassembler.this.running) {
                                    // MONITOREXIT @DISABLED, blocks:[0, 1, 41, 9, 26] lbl11 : MonitorExitStatement: MONITOREXIT : var5_6
                                    Object var13_12 = null;
                                    bl2 = false;
                                    object = ConversationReassembler.this;
                                    break;
                                }
                                ConversationReassembler.this.endpointIsDown = bl;
                                if (ConversationReassembler.this.firstMessage == null || ConversationReassembler.this.endpointIsDown || ConversationReassembler.this.windowSize < 1 || ConversationReassembler.this.poisoned) {
                                    this.stopRunning();
                                    break block43;
                                }
                                messageReference = this.getOrderedListWithNoGap(ConversationReassembler.this.firstMessage);
                            }
                            boolean bl3 = false;
                            this.preProcessSAFRequests(messageReference);
                            messageReference2 = messageReference;
                            int n = 0;
                            do {
                                ConversationReassembler conversationReassembler2;
                                boolean bl4;
                                ConversationReassembler.this.qosHandler.setCurrentSAFRequest(messageReference.getMessage());
                                if (SAFDebug.SAFVerbose.isDebugEnabled() && SAFDebug.SAFReceivingAgent.isDebugEnabled()) {
                                    this.debugProcessingSplitList(messageReference);
                                }
                                if (bl4 = this.checkIfSequenceNumberBiggerThanLastMsgOfConv(messageReference)) {
                                    this.handleInvalidMessage(new SAFException("Cannot send more messages after a message that is marked as last message in the conversation/sequence", 19), messageReference);
                                    conversationReassembler2 = ConversationReassembler.this;
                                    synchronized (conversationReassembler2) {
                                        messageReference = messageReference.getNext();
                                        ConversationReassembler.this.removeMessageFromList(messageReference);
                                        ConversationReassembler.this.windowSize--;
                                    }
                                    ++n;
                                    break;
                                }
                                bl3 = this.processRequestBeforeAck(messageReference);
                                if (bl3) {
                                    conversationReassembler2 = ConversationReassembler.this;
                                    synchronized (conversationReassembler2) {
                                        ConversationReassembler.this.endpointIsDown = true;
                                        break;
                                    }
                                }
                                conversationReassembler2 = ConversationReassembler.this;
                                synchronized (conversationReassembler2) {
                                    ConversationReassembler.this.windowSize--;
                                }
                                ++n;
                                messageReference3 = messageReference;
                                messageReference = messageReference.getNext();
                            } while (!this.mustAck() && messageReference != null);
                            if (messageReference3 == null) {
                                this.postProcessSAFRequests(n, messageReference, bl3);
                            } else {
                                this.postProcessSAFRequests(n, messageReference3.getNext(), bl3);
                            }
                            bl = this.processRequestsAfterAck(messageReference2, messageReference3);
                        }
                    }
                    catch (SAFException sAFException) {
                        if (messageReference3 == null) {
                            this.handleSAFException(sAFException, messageReference);
                        } else {
                            this.handleSAFException(sAFException, messageReference3);
                        }
                        Object var13_14 = null;
                        boolean bl5 = false;
                        Object object2 = ConversationReassembler.this;
                        synchronized (object2) {
                            ConversationReassembler.this.running = false;
                            if (ConversationReassembler.this.firstMessage != null) {
                                bl5 = true;
                            }
                        }
                        object2 = this.scheduledMonitor;
                        synchronized (object2) {
                            this.scheduled = false;
                            if (!bl5) return;
                            ConversationReassembler.this.scheduleWorkRequestRun();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        Object var13_15 = null;
                        boolean bl6 = false;
                        Object object3 = ConversationReassembler.this;
                        synchronized (object3) {
                            ConversationReassembler.this.running = false;
                            if (ConversationReassembler.this.firstMessage != null) {
                                bl6 = true;
                            }
                        }
                        object3 = this.scheduledMonitor;
                        synchronized (object3) {
                            this.scheduled = false;
                            if (!bl6) return;
                            ConversationReassembler.this.scheduleWorkRequestRun();
                            return;
                        }
                    }
                    synchronized (object) {
                        ConversationReassembler.this.running = false;
                        if (ConversationReassembler.this.firstMessage != null) {
                            bl2 = true;
                        }
                    }
                    object = this.scheduledMonitor;
                    synchronized (object) {
                        this.scheduled = false;
                        if (!bl2) return;
                        ConversationReassembler.this.scheduleWorkRequestRun();
                        return;
                    }
                }
                Object var13_13 = null;
                boolean bl7 = false;
                Object object = ConversationReassembler.this;
                synchronized (object) {
                    ConversationReassembler.this.running = false;
                    if (ConversationReassembler.this.firstMessage != null) {
                        bl7 = true;
                    }
                }
                object = this.scheduledMonitor;
                synchronized (object) {
                    this.scheduled = false;
                    if (!bl7) return;
                    ConversationReassembler.this.scheduleWorkRequestRun();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                boolean bl8 = false;
                Object object = ConversationReassembler.this;
                synchronized (object) {
                    ConversationReassembler.this.running = false;
                    if (ConversationReassembler.this.firstMessage != null) {
                        bl8 = true;
                    }
                }
                object = this.scheduledMonitor;
                synchronized (object) {
                    this.scheduled = false;
                    if (!bl8) throw throwable;
                    ConversationReassembler.this.scheduleWorkRequestRun();
                    throw throwable;
                }
            }
        }

        private void stopRunning() throws SAFException {
            ConversationReassembler.this.running = false;
            if (ConversationReassembler.this.windowSize < 1) {
                throw new SAFException(" Sending Side not honoring the windowSize");
            }
            if (ConversationReassembler.this.poisoned) {
                throw new SAFException("Conversation poisoned for Conversation = " + ConversationReassembler.this.info);
            }
        }

        private void handleInvalidMessage(SAFException sAFException, MessageReference messageReference) {
            int n = sAFException.getResultCode();
            ConversationReassembler.this.qosHandler.setSAFException(sAFException);
            ConversationReassembler.this.qosHandler.update(messageReference, n);
            ConversationReassembler.this.qosHandler.sendNack();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleSAFException(SAFException sAFException, MessageReference messageReference) {
            int n = sAFException.getResultCode();
            ConversationReassembler.this.qosHandler.setSAFException(sAFException);
            ConversationReassembler.this.qosHandler.update(messageReference, n);
            ConversationReassembler.this.qosHandler.sendNack();
            boolean bl = Conversation.isPoisoned(n);
            ConversationReassembler conversationReassembler = ConversationReassembler.this;
            synchronized (conversationReassembler) {
                ConversationReassembler.this.poisoned = bl;
                if (!ConversationReassembler.this.poisoned && messageReference != null) {
                    ConversationReassembler.this.restoreMessages(messageReference);
                }
                ConversationReassembler.this.running = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendAck(int n, MessageReference messageReference) {
            ConversationReassembler conversationReassembler = ConversationReassembler.this;
            synchronized (conversationReassembler) {
                ConversationReassembler.this.windowSize += n;
                if (messageReference != null) {
                    ConversationReassembler.this.restoreMessages(messageReference);
                }
            }
            if (SAFDebug.SAFVerbose.isDebugEnabled() && SAFDebug.SAFReceivingAgent.isDebugEnabled()) {
                SAFDebug.SAFReceivingAgent.debug("Conversation '" + ConversationReassembler.this.info.getConversationName() + "' == sendAck(): windowSize = " + ConversationReassembler.this.windowSize);
            }
            ConversationReassembler.this.qosHandler.sendAck();
        }

        private void debugProcessingSplitList(MessageReference messageReference) {
            SAFDebug.SAFReceivingAgent.debug("###################################################");
            SAFDebug.SAFReceivingAgent.debug("Conversation '" + ConversationReassembler.this.info.getConversationName() + "' == execute(): current sequence= " + messageReference.getSequenceNumber() + " first message = " + (ConversationReassembler.this.firstMessage == null ? -1L : ConversationReassembler.this.firstMessage.getSequenceNumber()));
            SAFDebug.SAFReceivingAgent.debug("###################################################");
        }

        private MessageReference getOrderedListWithNoGap(MessageReference messageReference) {
            long l;
            MessageReference messageReference2 = messageReference;
            long l2 = 0L;
            do {
                l = messageReference2.getSequenceNumber();
                while ((messageReference2 = messageReference2.getNext()) != null && l == (l2 = messageReference2.getSequenceNumber())) {
                }
            } while (messageReference2 != null && l2 == l + 1L);
            ConversationReassembler.this.firstMessage = messageReference2;
            if (messageReference2 != null) {
                messageReference2.getPrev().setNext(null);
                messageReference2.setPrev(null);
            } else {
                ConversationReassembler.this.lastMessage = messageReference2;
            }
            return messageReference;
        }

        private boolean mustAck() {
            long l = System.currentTimeMillis();
            if (l - ConversationReassembler.this.lastAckTime >= ConversationReassembler.this.ackInterval || ConversationReassembler.this.windowSize == ConversationReassembler.this.origWindowSize / 2) {
                ConversationReassembler.this.lastAckTime = l;
                return true;
            }
            return false;
        }

        protected void preProcessSAFRequests(MessageReference messageReference) {
            ConversationReassembler.this.qosHandler.preProcess(messageReference);
        }

        protected boolean postProcessSAFRequests(int n, MessageReference messageReference, boolean bl) throws SAFException {
            if (!bl) {
                this.sendAck(n, messageReference);
                return true;
            }
            SAFException sAFException = new SAFException(" Failed to deliver message to the Endpoint for Conversation = " + ConversationReassembler.this.info, ConversationReassembler.this.qosHandler.getResult().getSAFException(), ConversationReassembler.this.qosHandler.getResult().getResultCode());
            throw sAFException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkIfSequenceNumberBiggerThanLastMsgOfConv(MessageReference messageReference) {
            ConversationReassembler conversationReassembler = ConversationReassembler.this;
            synchronized (conversationReassembler) {
                if (messageReference == null || messageReference.getMessage() == null) {
                    return false;
                }
                return messageReference.getMessage().getSequenceNumber() > ConversationReassembler.this.lastMsgSequenceNumber;
            }
        }

        protected boolean processRequestBeforeAck(MessageReference messageReference) {
            return this.processRequest(messageReference, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean processRequestsAfterAck(MessageReference messageReference, MessageReference messageReference2) {
            ConversationReassembler conversationReassembler = ConversationReassembler.this;
            synchronized (conversationReassembler) {
                if (ConversationReassembler.this.endpointIsDown) {
                    return true;
                }
            }
            return false;
        }

        protected final boolean processRequest(MessageReference messageReference, boolean bl) {
            Externalizable externalizable;
            int n = 0;
            int n2 = 0;
            SAFRequest sAFRequest = messageReference.getMessage();
            if (SAFDebug.SAFVerbose.isDebugEnabled() && SAFDebug.SAFReceivingAgent.isDebugEnabled()) {
                SAFDebug.SAFReceivingAgent.debug("Conversation '" + ConversationReassembler.this.info.getConversationName() + "' == processRequest(): conversation: " + sAFRequest.getConversationName() + " request: " + sAFRequest.getSequenceNumber());
            }
            if ((externalizable = sAFRequest.getPayload()) == null) {
                if (SAFDebug.SAFVerbose.isDebugEnabled() && SAFDebug.SAFReceivingAgent.isDebugEnabled()) {
                    SAFDebug.SAFReceivingAgent.debug("Conversation '" + ConversationReassembler.this.info.getConversationName() + "' == processRequest(): request: " + sAFRequest.getSequenceNumber() + " is the close conversation request" + " or gap message");
                }
                ++n2;
            } else {
                try {
                    this.deliverToEndpoint(sAFRequest);
                    ++n2;
                }
                catch (SAFException sAFException) {
                    n = ConversationReassembler.this.qosHandler.handleEndpointDeliveryFailure(sAFException, sAFRequest);
                }
            }
            int n3 = n = n == 0 ? this.checkNumMessagesAcked(n2, 1, sAFRequest) : n;
            if (!bl) {
                this.updateQOSHandler(messageReference, n);
            }
            return n != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deliverToEndpoint(SAFRequest sAFRequest) throws SAFException {
            if (SAFDebug.SAFVerbose.isDebugEnabled() && SAFDebug.SAFReceivingAgent.isDebugEnabled()) {
                SAFDebug.SAFReceivingAgent.debug("Conversation '" + ConversationReassembler.this.info.getConversationName() + "' == processRequest(): request: " + sAFRequest.getSequenceNumber());
            }
            Object object = ConversationReassembler.this.operationLock;
            synchronized (object) {
                if (ConversationReassembler.this.isClosed()) {
                    throw new SAFConversationNotAvailException("Failed to send a message: conversation " + sAFRequest.getConversationName() + " has completed, expired or terminated," + " or has been destroyed administratively");
                }
                ConversationReassembler.this.destination.deliver(ConversationReassembler.this.info, sAFRequest);
            }
            if (SAFDebug.SAFVerbose.isDebugEnabled() && SAFDebug.SAFReceivingAgent.isDebugEnabled()) {
                SAFDebug.SAFReceivingAgent.debug("Conversation '" + ConversationReassembler.this.info.getConversationName() + "' == processRequest(): request: " + sAFRequest.getSequenceNumber() + " has been delivered to the endpoint");
            }
        }

        protected final boolean updateQOSHandler(MessageReference messageReference, int n) {
            ConversationReassembler.this.qosHandler.update(messageReference, n);
            return n == 0;
        }

        private int checkNumMessagesAcked(int n, int n2, SAFRequest sAFRequest) {
            if (n == 0 || n != n2) {
                String string = " Number of Messages acknowledged is not equal to number of messages processed acknowlegdedCount = " + n + " numRequests = " + n2;
                SAFException sAFException = new SAFException(string);
                return ConversationReassembler.this.qosHandler.handleEndpointDeliveryFailure(sAFException, sAFRequest);
            }
            return 0;
        }
    }

    public class DelayedScheduleTimerListener
    implements NakedTimerListener {
        public void timerExpired(Timer timer) {
            if (ConversationReassembler.this.isClosed()) {
                return;
            }
            ConversationReassembler.this.receivingAgent.getWorkManager().schedule((Runnable)((Object)ConversationReassembler.this.workRequest));
        }
    }
}

