/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.internal;

import java.util.ArrayList;
import weblogic.messaging.kernel.MessageElement;
import weblogic.messaging.saf.SAFRequest;
import weblogic.messaging.saf.common.SAFRequestImpl;
import weblogic.messaging.saf.internal.RetryController;

public final class MessageReference {
    private final SAFRequest message;
    private MessageElement element;
    private final ArrayList faultCodes = new ArrayList();
    private RetryController retryController;
    private MessageReference prev;
    private MessageReference next;

    MessageReference(MessageElement messageElement, double d, long l, long l2) {
        this.element = messageElement;
        this.message = (SAFRequestImpl)messageElement.getMessage();
        this.retryController = new RetryController(l, l2, d);
    }

    MessageReference(SAFRequest sAFRequest) {
        this.message = sAFRequest;
    }

    SAFRequest getMessage() {
        return this.message;
    }

    MessageElement getElement() {
        return this.element;
    }

    long getSequenceNumber() {
        return this.message.getSequenceNumber();
    }

    long getNextRetryDelay() {
        return this.retryController.getNextRetry();
    }

    void setFaultCode(int n) {
        this.faultCodes.add(new Integer(n));
    }

    ArrayList getFaultCodes() {
        return this.faultCodes;
    }

    boolean isExpired() {
        return ((SAFRequestImpl)this.message).isExpired();
    }

    synchronized boolean hasBeenHandled() {
        return this.message.getPayload() == null;
    }

    void setPrev(MessageReference messageReference) {
        this.prev = messageReference;
    }

    MessageReference getPrev() {
        return this.prev;
    }

    void setNext(MessageReference messageReference) {
        this.next = messageReference;
    }

    MessageReference getNext() {
        return this.next;
    }
}

