/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.messaging.kernel.Sequence;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFConversationNotAvailException;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.SAFRequest;
import weblogic.messaging.saf.SAFResult;
import weblogic.messaging.saf.SAFTransport;
import weblogic.messaging.saf.common.SAFDebug;
import weblogic.messaging.saf.common.SAFResultImpl;
import weblogic.messaging.saf.internal.MessageReference;
import weblogic.messaging.saf.internal.WSQOSHandler;

public abstract class QOSHandler {
    protected long sequenceNumberLow = 1L;
    protected long sequenceNumberHigh = 1L;
    protected MessageReference sequenceNumberLowMRef;
    protected MessageReference sequenceNumberHighMRef;
    protected SAFResultImpl result = new SAFResultImpl();
    protected SAFRequest currentSAFRequest;
    protected SAFTransport transport;
    protected SAFConversationInfo conversationInfo;
    protected Sequence sequence;

    public QOSHandler(SAFConversationInfo sAFConversationInfo, SAFTransport sAFTransport) {
        this.conversationInfo = sAFConversationInfo;
        this.transport = sAFTransport;
    }

    void preProcess(MessageReference messageReference) {
        this.result = new SAFResultImpl();
        this.currentSAFRequest = messageReference.getMessage();
        this.sequenceNumberHigh = messageReference.getSequenceNumber();
        this.sequenceNumberLow = messageReference.getSequenceNumber();
    }

    void setCurrentSAFRequest(SAFRequest sAFRequest) {
        this.currentSAFRequest = sAFRequest;
    }

    void setSAFException(SAFException sAFException) {
        this.result.setSAFException(sAFException);
    }

    static QOSHandler getQOSHandler(SAFConversationInfo sAFConversationInfo, SAFTransport sAFTransport, long l) {
        switch (sAFConversationInfo.getDestinationType()) {
            default: 
        }
        return new WSQOSHandler(sAFConversationInfo, sAFTransport, l);
    }

    void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    protected abstract void update(MessageReference var1, int var2);

    protected abstract void sendAck();

    protected abstract void sendNack();

    protected final void sendAckInternal() {
        this.sendResult();
        if (SAFDebug.SAFVerbose.isDebugEnabled()) {
            List list = this.result.getSequenceNumbers();
            String string = null;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                long l2 = (Long)iterator.next();
                string = string + "< sequenceNumberLow=" + l + " sequenceNumberHigh=" + l2 + "> ";
            }
            SAFDebug.SAFVerbose.debug("$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$");
            SAFDebug.SAFVerbose.debug(" == execute() sendResult: Successfully sent  ack conversationInfo" + this.conversationInfo + string);
            SAFDebug.SAFVerbose.debug("$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$");
        }
    }

    protected void sendResult() {
        this.setResult();
        this.transport.sendResult(this.result);
    }

    protected final SAFResult getResult() {
        return this.result;
    }

    protected void setResult() {
        if (this.result.getResultCode() == 0) {
            this.result.setSequenceNumbers(this.sequence.getAllSequenceNumberRanges());
        } else {
            long l = this.currentSAFRequest.getSequenceNumber();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            Long l2 = new Long(l);
            arrayList.add(l2);
            arrayList.add(l2);
            this.result.setSequenceNumbers(arrayList);
        }
        this.result.setConversationInfo(this.conversationInfo);
    }

    public int handleEndpointDeliveryFailure(Throwable throwable, SAFRequest sAFRequest) {
        SAFException sAFException = null;
        if (throwable instanceof SAFException) {
            sAFException = (SAFException)throwable;
            if (throwable instanceof SAFConversationNotAvailException) {
                this.result.setResultCode(5);
            } else {
                this.result.setResultCode(3);
            }
        } else {
            this.result.setResultCode(12);
            sAFException = new SAFException(throwable.getMessage(), throwable);
        }
        this.result.setSAFException(sAFException);
        if (SAFDebug.SAFVerbose.isDebugEnabled()) {
            throwable.printStackTrace();
        }
        return this.result.getResultCode();
    }
}

