/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.internal;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import javax.naming.NamingException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.health.HealthState;
import weblogic.management.configuration.SAFAgentMBean;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFEndpoint;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.SAFManager;
import weblogic.messaging.saf.SAFServiceNotAvailException;
import weblogic.messaging.saf.common.AgentDeliverRequest;
import weblogic.messaging.saf.common.AgentDeliverResponse;
import weblogic.messaging.saf.common.SAFConversationInfoImpl;
import weblogic.messaging.saf.common.SAFDebug;
import weblogic.messaging.saf.internal.AgentImpl;
import weblogic.messaging.saf.internal.ConversationReassembler;
import weblogic.messaging.saf.internal.ReceivingAgent;
import weblogic.messaging.saf.internal.SAFAgentAdmin;
import weblogic.messaging.saf.internal.SAFAgentFactoryInternal;
import weblogic.messaging.saf.internal.SAFDiagnosticImageSource;
import weblogic.messaging.saf.internal.SAFManagerImpl;
import weblogic.messaging.saf.store.SAFStore;

public final class ReceivingAgentImpl
extends AgentImpl
implements ReceivingAgent,
Externalizable {
    static final long serialVersionUID = -5246833642083492445L;
    private final HashMap conversations = new HashMap();
    private int windowSize;
    private long defaultTimeToLive = Long.MAX_VALUE;
    private long conversationIdleTimeMaximum = Long.MAX_VALUE;
    private boolean started;
    private boolean isPausedForReceiving;
    private long ackInterval;
    private static final SAFAgentFactoryInternal agentFactoryInternal = new SAFAgentFactoryInternal();
    private static final SAFManager manager = SAFManagerImpl.getManager();

    public ReceivingAgentImpl() {
    }

    ReceivingAgentImpl(String string, SAFAgentAdmin sAFAgentAdmin, SAFStore sAFStore) throws NamingException, SAFException {
        super(string, sAFAgentAdmin, sAFStore, 2);
        if (SAFDebug.SAFReceivingAgent.isDebugEnabled()) {
            SAFDebug.SAFReceivingAgent.debug("Receiving Agent '" + string + "':" + " TimeToLive=" + this.defaultTimeToLive + ", ConversationIdleTimeMaximum=" + this.conversationIdleTimeMaximum + ", WindowSize=" + this.windowSize);
        }
    }

    protected void startInitialize(SAFAgentMBean sAFAgentMBean) {
        this.defaultTimeToLive = sAFAgentMBean.getDefaultTimeToLive();
        this.conversationIdleTimeMaximum = sAFAgentMBean.getConversationIdleTimeMaximum();
        if (this.defaultTimeToLive == 0L) {
            this.defaultTimeToLive = Long.MAX_VALUE;
        }
        if (this.conversationIdleTimeMaximum == 0L) {
            this.conversationIdleTimeMaximum = Long.MAX_VALUE;
        }
        this.windowSize = sAFAgentMBean.getWindowSize();
        this.ackInterval = sAFAgentMBean.getAcknowledgeInterval();
        this.isPaused = this.isPausedForReceiving = sAFAgentMBean.isReceivingPausedAtStartup();
    }

    protected void addToAgentFactory() {
        safManager.addLocalReceivingAgent(this);
        agentFactoryInternal.addAgent(this);
    }

    protected void removeFromAgentFactory() {
        agentFactoryInternal.removeAgent(this);
        safManager.removeLocalReceivingAgent(this);
    }

    static SAFAgentFactoryInternal getAgentFactory() {
        return agentFactoryInternal;
    }

    public void setConversationInfosFromStore(HashMap hashMap) {
        this.conversationInfosFromStore = hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() throws SAFException {
        Iterator iterator;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.started) {
                return;
            }
        }
        serializable = this.conversationInfosFromStore;
        synchronized (serializable) {
            iterator = ((HashMap)this.conversationInfosFromStore.clone()).values().iterator();
        }
        if (SAFDebug.SAFReceivingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFReceivingAgent.debug("Receiving anget '" + this.getName() + "' recovered " + this.conversationInfosFromStore.size() + " conversations from the store");
        }
        while (iterator.hasNext()) {
            serializable = (SAFConversationInfo)iterator.next();
            try {
                this.createConversation((SAFConversationInfo)serializable);
            }
            catch (SAFException sAFException) {
                this.healthState = ReceivingAgentImpl.updateHealthState(this.healthState, 3, sAFException.getMessage());
                throw sAFException;
            }
        }
        serializable = this;
        synchronized (serializable) {
            this.started = true;
        }
    }

    int getWindowSize() {
        return this.windowSize;
    }

    long getAckInterval() {
        return this.ackInterval;
    }

    public AgentDeliverResponse deliver(AgentDeliverRequest agentDeliverRequest) throws SAFException {
        if (this.isPausedForReceiving()) {
            if (SAFDebug.SAFReceivingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                SAFDebug.SAFReceivingAgent.debug(" [ReceivingAgent.deliver()]: the agent is paused.");
            }
            throw new SAFServiceNotAvailException("ReceivingAgent " + this + " is paused.");
        }
        return agentDeliverRequest.finishDeliver(this);
    }

    public void suspend(boolean bl) {
        this.close(false);
    }

    public void resume() throws SAFException {
        this.start();
    }

    public synchronized void close(boolean bl) {
        this.closeInternal(bl);
    }

    private void closeInternal(boolean bl) {
        this.unadvertise();
        Iterator iterator = this.conversations.values().iterator();
        while (iterator.hasNext()) {
            try {
                ((ConversationReassembler)iterator.next()).close(bl);
            }
            catch (SAFException sAFException) {
                if (!SAFDebug.SAFReceivingAgent.isDebugEnabled()) continue;
                sAFException.printStackTrace();
            }
        }
        this.conversations.clear();
        this.store.close();
    }

    public long getDefaultTimeToLive() {
        return this.defaultTimeToLive;
    }

    private void createConversation(SAFConversationInfo sAFConversationInfo) throws SAFException {
        this.createConversation(sAFConversationInfo, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConversationReassembler createConversation(SAFConversationInfo sAFConversationInfo, boolean bl) throws SAFException {
        ConversationReassembler conversationReassembler;
        if (SAFDebug.SAFReceivingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFReceivingAgent.debug("Receiving Agent '" + this.name + "': about to create conversation " + sAFConversationInfo);
        }
        if (sAFConversationInfo == null) {
            return null;
        }
        boolean bl2 = false;
        SAFConversationInfo sAFConversationInfo2 = null;
        ReceivingAgentImpl receivingAgentImpl = this;
        synchronized (receivingAgentImpl) {
            conversationReassembler = this.getConversation(sAFConversationInfo);
            if (conversationReassembler == null) {
                SAFEndpoint sAFEndpoint = safManager.getEndpointManager(sAFConversationInfo.getDestinationType()).getEndpoint(sAFConversationInfo.getDestinationURL());
                ((SAFConversationInfoImpl)sAFConversationInfo).setTimestamp(System.currentTimeMillis());
                safManager.addConversationInfoOnReceivingSide(sAFConversationInfo);
                conversationReassembler = new ConversationReassembler(this, sAFConversationInfo.getTransportType(), sAFEndpoint, sAFConversationInfo, this.store, bl);
                if (bl && (sAFConversationInfo2 = sAFConversationInfo.getConversationOffer()) != null) {
                    bl2 = true;
                }
                this.conversations.put(sAFConversationInfo, conversationReassembler);
                this.storeConversationInfo(sAFConversationInfo);
                if (SAFDebug.SAFReceivingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                    SAFDebug.SAFReceivingAgent.debug("Receiving Agent '" + this.name + "' after created conversation = " + conversationReassembler);
                }
            }
        }
        if (bl2) {
            manager.registerConversationOnSendingSide(sAFConversationInfo2, null);
        }
        return conversationReassembler;
    }

    public synchronized ConversationReassembler getConversation(SAFConversationInfo sAFConversationInfo) {
        return (ConversationReassembler)this.conversations.get(sAFConversationInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConversation(SAFConversationInfo sAFConversationInfo) throws SAFException {
        ConversationReassembler conversationReassembler;
        ReceivingAgentImpl receivingAgentImpl = this;
        synchronized (receivingAgentImpl) {
            conversationReassembler = this.getConversation(sAFConversationInfo);
        }
        if (conversationReassembler != null) {
            conversationReassembler.finishConversation();
        }
        receivingAgentImpl = this;
        synchronized (receivingAgentImpl) {
            this.conversations.remove(sAFConversationInfo);
            this.conversationInfosFromStore.remove(sAFConversationInfo.getConversationName());
        }
        if (conversationReassembler == null) {
            throw new SAFException("ConversationReassembler Not Found for conversation: " + sAFConversationInfo.getConversationName());
        }
    }

    public synchronized void pauseReceiving() {
        if (this.isPausedForReceiving) {
            return;
        }
        this.isPausedForReceiving = true;
        this.isPaused = true;
        this.unadvertise();
    }

    public synchronized void resumeReceiving() {
        if (!this.isPausedForReceiving) {
            return;
        }
        this.isPausedForReceiving = false;
        this.isPaused = false;
        this.advertise();
    }

    public synchronized boolean isPausedForReceiving() {
        return this.isPausedForReceiving;
    }

    void setWindowSize(int n) {
        this.windowSize = n;
    }

    synchronized void setDefaultTimeToLive(long l) {
        this.defaultTimeToLive = this.defaultTimeToLive == 0L ? Long.MAX_VALUE : l;
    }

    synchronized void setAcknowledgementInterval(long l) {
        this.ackInterval = l;
    }

    synchronized void setConversationIdleTimeMaximum(long l) {
        this.conversationIdleTimeMaximum = this.conversationIdleTimeMaximum == 0L ? Long.MAX_VALUE : l;
    }

    synchronized long getConversationIdleTimeMaximum() {
        return this.conversationIdleTimeMaximum;
    }

    HealthState getHealthState() {
        return this.healthState;
    }

    public void dump(SAFDiagnosticImageSource sAFDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        sAFDiagnosticImageSource.checkTimeout();
        xMLStreamWriter.writeStartElement("ReceivingAgent");
        super.dump(sAFDiagnosticImageSource, xMLStreamWriter);
        xMLStreamWriter.writeAttribute("windowSize", String.valueOf(this.windowSize));
        xMLStreamWriter.writeAttribute("defaultTimeToLive", String.valueOf(this.defaultTimeToLive));
        xMLStreamWriter.writeAttribute("conversationIdleTimeMaximum", String.valueOf(this.conversationIdleTimeMaximum));
        xMLStreamWriter.writeAttribute("started", String.valueOf(this.started));
        xMLStreamWriter.writeAttribute("isPausedForReceiving", String.valueOf(this.isPausedForReceiving));
        xMLStreamWriter.writeAttribute("ackInterval", String.valueOf(this.ackInterval));
        xMLStreamWriter.writeAttribute("idleTimeMaximum", String.valueOf(this.conversationIdleTimeMaximum));
        SAFDiagnosticImageSource.dumpHealthStateElement(xMLStreamWriter, this.getAgentAdmin().getHealthState());
        xMLStreamWriter.writeStartElement("ConversationReassemblers");
        Object[] objectArray = this.conversations.values().toArray();
        xMLStreamWriter.writeAttribute("count", String.valueOf(objectArray.length));
        for (int i = 0; i < objectArray.length; ++i) {
            ConversationReassembler conversationReassembler = (ConversationReassembler)objectArray[i];
            conversationReassembler.dump(sAFDiagnosticImageSource, xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }
}

