/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.internal;

import java.util.Date;
import weblogic.messaging.saf.OperationState;

public final class RemoteEndpointRuntimeCommonAddition {
    private long downtimeHigh;
    private long downtimeTotal;
    private long uptimeHigh;
    private long uptimeTotal;
    private long lastTimeDisconnected;
    private long lastTimeConnected;
    private boolean connected;
    private Exception lastException;
    private OperationState expireAllState;

    public RemoteEndpointRuntimeCommonAddition() {
        long l;
        this.lastTimeConnected = l = System.currentTimeMillis();
        this.lastTimeDisconnected = l - 1L;
        this.connected = true;
        this.expireAllState = OperationState.COMPLETED;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void updateLastTimeConnected(long l) {
        if (this.lastTimeConnected == 0L) {
            this.lastTimeConnected = l;
            return;
        }
        if (this.lastTimeConnected <= this.lastTimeDisconnected) {
            this.lastTimeConnected = l;
        }
    }

    public synchronized void updateLastTimeDisconnected(long l, Exception exception) {
        this.lastException = exception;
        if (this.lastTimeDisconnected == 0L) {
            this.lastTimeDisconnected = l;
            return;
        }
        if (this.lastTimeDisconnected <= this.lastTimeConnected) {
            this.lastTimeDisconnected = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connected() {
        long l = System.currentTimeMillis();
        RemoteEndpointRuntimeCommonAddition remoteEndpointRuntimeCommonAddition = this;
        synchronized (remoteEndpointRuntimeCommonAddition) {
            if (this.connected) {
                return;
            }
            this.lastException = null;
            this.connected = true;
            this.updateLastTimeConnected(l);
            if (this.downtimeHigh < this.lastTimeConnected - this.lastTimeDisconnected) {
                this.downtimeHigh = this.lastTimeConnected - this.lastTimeDisconnected;
            }
            this.downtimeTotal += this.lastTimeConnected - this.lastTimeDisconnected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected(Exception exception) {
        long l = System.currentTimeMillis();
        RemoteEndpointRuntimeCommonAddition remoteEndpointRuntimeCommonAddition = this;
        synchronized (remoteEndpointRuntimeCommonAddition) {
            if (!this.connected) {
                return;
            }
            this.connected = false;
            this.updateLastTimeDisconnected(l, exception);
            if (this.uptimeHigh < this.lastTimeDisconnected - this.lastTimeConnected) {
                this.uptimeHigh = this.lastTimeDisconnected - this.lastTimeConnected;
            }
            this.uptimeTotal += this.lastTimeDisconnected - this.lastTimeConnected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDowntimeHigh() {
        long l = System.currentTimeMillis();
        RemoteEndpointRuntimeCommonAddition remoteEndpointRuntimeCommonAddition = this;
        synchronized (remoteEndpointRuntimeCommonAddition) {
            if (!this.connected && this.downtimeHigh < l - this.lastTimeDisconnected) {
                return (l - this.lastTimeDisconnected) / 1000L;
            }
            return this.downtimeHigh / 1000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDowntimeTotal() {
        long l = System.currentTimeMillis();
        RemoteEndpointRuntimeCommonAddition remoteEndpointRuntimeCommonAddition = this;
        synchronized (remoteEndpointRuntimeCommonAddition) {
            if (!this.connected) {
                return (this.downtimeTotal + l - this.lastTimeDisconnected) / 1000L;
            }
            return this.downtimeTotal / 1000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUptimeHigh() {
        long l = System.currentTimeMillis();
        RemoteEndpointRuntimeCommonAddition remoteEndpointRuntimeCommonAddition = this;
        synchronized (remoteEndpointRuntimeCommonAddition) {
            if (this.connected && this.uptimeHigh < l - this.lastTimeConnected) {
                return (l - this.lastTimeConnected) / 1000L;
            }
            return this.uptimeHigh / 1000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUptimeTotal() {
        long l = System.currentTimeMillis();
        RemoteEndpointRuntimeCommonAddition remoteEndpointRuntimeCommonAddition = this;
        synchronized (remoteEndpointRuntimeCommonAddition) {
            if (this.connected) {
                return (this.uptimeTotal + l - this.lastTimeConnected) / 1000L;
            }
            return this.uptimeTotal / 1000L;
        }
    }

    public synchronized Date getLastTimeConnected() {
        return new Date(this.lastTimeConnected);
    }

    public synchronized Date getLastTimeFailedToConnect() {
        return new Date(this.lastTimeDisconnected);
    }

    public synchronized Exception getLastException() {
        return this.lastException;
    }

    public OperationState getOperationState() {
        return this.expireAllState;
    }

    public void setOperationState(OperationState operationState) {
        this.expireAllState = operationState;
    }
}

