/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.internal;

import java.security.AccessController;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.management.openmbean.CompositeData;
import weblogic.jms.saf.SAFRemoteEndpointCustomizer;
import weblogic.management.ManagementException;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.SAFConversationRuntimeMBean;
import weblogic.management.runtime.WSRMRemoteEndpointRuntimeMBean;
import weblogic.messaging.ID;
import weblogic.messaging.common.PrivilegedActionUtilities;
import weblogic.messaging.common.SQLExpression;
import weblogic.messaging.kernel.Cursor;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.Queue;
import weblogic.messaging.kernel.Topic;
import weblogic.messaging.saf.OperationState;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.SAFLogger;
import weblogic.messaging.saf.common.SAFDebug;
import weblogic.messaging.saf.internal.ConversationAssembler;
import weblogic.messaging.saf.internal.ConversationRuntimeDelegate;
import weblogic.messaging.saf.internal.RemoteEndpointRuntimeCommonAddition;
import weblogic.messaging.saf.internal.SAFAgentAdmin;
import weblogic.messaging.saf.internal.SAFMessageCursorDelegate;
import weblogic.messaging.saf.internal.SAFMessageOpenDataConverter;
import weblogic.messaging.saf.internal.SAFStatisticsCommonMBeanImpl;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.StackTraceUtils;
import weblogic.work.WorkManagerFactory;

public final class RemoteEndpointRuntimeDelegate
extends SAFStatisticsCommonMBeanImpl
implements WSRMRemoteEndpointRuntimeMBean,
Runnable {
    static final long serialVersionUID = 8592927712725625160L;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    public static final String ENDPOINT_NAME_PREFIX = "SAFEndpoint";
    private String url;
    private int endpointType;
    private boolean isPausedForIncoming;
    private boolean isPausedForForwarding;
    private HashMap conversations;
    private long conversationsCurrentCount;
    private long conversationsHighCount;
    private long conversationsTotalCount;
    private long failedMessagesTotal;
    private Topic kernelTopic;
    private SAFMessageOpenDataConverter openDataConverter;
    private final SAFRemoteEndpointCustomizer delegate;
    private RemoteEndpointRuntimeCommonAddition addition;

    public RemoteEndpointRuntimeDelegate(SAFAgentAdmin sAFAgentAdmin, ID iD, String string, int n, Topic topic) throws ManagementException {
        super(ENDPOINT_NAME_PREFIX + iD.toString(), null, true);
        this.delegate = new SAFRemoteEndpointCustomizer(ENDPOINT_NAME_PREFIX + iD.toString(), sAFAgentAdmin, this);
        this.url = string;
        this.endpointType = n;
        this.kernelTopic = topic;
        this.conversations = new HashMap();
        this.openDataConverter = new SAFMessageOpenDataConverter(this);
        this.addition = new RemoteEndpointRuntimeCommonAddition();
    }

    synchronized void addConversation(ConversationRuntimeDelegate conversationRuntimeDelegate) {
        if (this.conversations.get(conversationRuntimeDelegate.getConversationName()) == null) {
            ++this.conversationsCurrentCount;
            ++this.conversationsTotalCount;
            if (this.conversationsCurrentCount > this.conversationsHighCount) {
                this.conversationsHighCount = this.conversationsCurrentCount;
            }
            this.conversations.put(conversationRuntimeDelegate.getConversationName(), conversationRuntimeDelegate);
        }
    }

    synchronized void removeConversation(String string) {
        if (this.conversations.remove(string) != null) {
            --this.conversationsCurrentCount;
        }
    }

    public String getURL() {
        return this.url;
    }

    synchronized void increaseFailedMessagesCount() {
        ++this.failedMessagesTotal;
    }

    public CompositeData getMessage(String string) throws ManagementException {
        try {
            Cursor cursor = this.createCursor("SAFMessageID = '" + string + "'");
            if (cursor.size() == 0) {
                return null;
            }
            if (cursor.size() > 1) {
                throw new ManagementException("Multiple messages exist for messageID " + string);
            }
            return this.openDataConverter.createCompositeData(cursor.next());
        }
        catch (Exception exception) {
            throw new ManagementException("Error creating message cursor.", (Throwable)exception);
        }
    }

    public String getEndpointType() {
        switch (this.endpointType) {
            case 2: {
                return "WebServices";
            }
            case 3: {
                return "JaxwsWebServices";
            }
        }
        return new String("Unknown type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseIncoming() throws SAFException {
        if (SAFDebug.SAFAdmin.isDebugEnabled()) {
            SAFDebug.SAFAdmin.debug("Pause Incoming for endpoint " + this.url);
        }
        RemoteEndpointRuntimeDelegate remoteEndpointRuntimeDelegate = this;
        synchronized (remoteEndpointRuntimeDelegate) {
            if (this.isPausedForIncoming) {
                return;
            }
            this.isPausedForIncoming = true;
            this.suspendKernelQueues(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeIncoming() throws SAFException {
        if (SAFDebug.SAFAdmin.isDebugEnabled()) {
            SAFDebug.SAFAdmin.debug("Resume Incoming for endpoint " + this.url);
        }
        RemoteEndpointRuntimeDelegate remoteEndpointRuntimeDelegate = this;
        synchronized (remoteEndpointRuntimeDelegate) {
            if (!this.isPausedForIncoming) {
                return;
            }
            this.isPausedForIncoming = false;
            this.resumeKernelQueues(1);
        }
    }

    public synchronized boolean isPausedForIncoming() {
        return this.isPausedForIncoming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseForwarding() throws SAFException {
        if (SAFDebug.SAFAdmin.isDebugEnabled()) {
            SAFDebug.SAFAdmin.debug("Pause Forwarding for endpoint " + this.url);
        }
        RemoteEndpointRuntimeDelegate remoteEndpointRuntimeDelegate = this;
        synchronized (remoteEndpointRuntimeDelegate) {
            if (this.isPausedForForwarding) {
                return;
            }
            this.isPausedForForwarding = true;
            this.suspendKernelQueues(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeForwarding() throws SAFException {
        if (SAFDebug.SAFAdmin.isDebugEnabled()) {
            SAFDebug.SAFAdmin.debug("Resume Forwarding for endpoint " + this.url);
        }
        RemoteEndpointRuntimeDelegate remoteEndpointRuntimeDelegate = this;
        synchronized (remoteEndpointRuntimeDelegate) {
            if (!this.isPausedForForwarding) {
                return;
            }
            this.isPausedForForwarding = false;
            this.resumeKernelQueues(2);
        }
    }

    public synchronized boolean isPausedForForwarding() {
        return this.isPausedForForwarding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConversations(String string) throws SAFException {
        Iterator iterator = null;
        RuntimeMBean runtimeMBean = this;
        synchronized (runtimeMBean) {
            iterator = ((HashMap)this.conversations.clone()).values().iterator();
        }
        while (iterator.hasNext()) {
            runtimeMBean = (SAFConversationRuntimeMBean)iterator.next();
            if (runtimeMBean.getName().indexOf(string) == -1) continue;
            this.removeConversation(runtimeMBean.getConversationName());
            runtimeMBean.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireAll() {
        RemoteEndpointRuntimeDelegate remoteEndpointRuntimeDelegate = this;
        synchronized (remoteEndpointRuntimeDelegate) {
            if (this.addition.getOperationState() == OperationState.RUNNING) {
                return;
            }
        }
        WorkManagerFactory.getInstance().getSystem().schedule((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Iterator iterator = null;
        RemoteEndpointRuntimeDelegate remoteEndpointRuntimeDelegate = this;
        synchronized (remoteEndpointRuntimeDelegate) {
            if (this.addition.getOperationState() == OperationState.RUNNING) {
                return;
            }
            this.addition.setOperationState(OperationState.RUNNING);
            iterator = ((HashMap)this.conversations.clone()).values().iterator();
            this.conversations.clear();
        }
        while (iterator.hasNext()) {
            try {
                ((ConversationRuntimeDelegate)iterator.next()).getConversation().expireAllMessages(9, null);
            }
            catch (KernelException kernelException) {
                this.addition.setOperationState(OperationState.STOPPED);
                return;
            }
        }
        remoteEndpointRuntimeDelegate = this;
        synchronized (remoteEndpointRuntimeDelegate) {
            this.addition.setOperationState(OperationState.COMPLETED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cursor createCursor(String string) throws KernelException {
        Iterator iterator = null;
        Object object = this;
        synchronized (object) {
            iterator = this.conversations.values().iterator();
        }
        object = new HashSet();
        while (iterator.hasNext()) {
            Queue queue = ((ConversationRuntimeDelegate)iterator.next()).getConversation().getSubscriptionQueue();
            ((HashSet)object).add(queue);
        }
        return this.kernelTopic.getKernel().createCursor((Collection)object, this.kernelTopic.getFilter().createExpression((Object)new SQLExpression(string)), Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() throws SAFException {
        Iterator iterator = null;
        RemoteEndpointRuntimeDelegate remoteEndpointRuntimeDelegate = this;
        synchronized (remoteEndpointRuntimeDelegate) {
            iterator = ((HashMap)this.conversations.clone()).values().iterator();
            this.conversations.clear();
        }
        while (iterator.hasNext()) {
            ((SAFConversationRuntimeMBean)iterator.next()).destroy();
        }
    }

    public synchronized SAFConversationRuntimeMBean[] getConversations() {
        return this.conversations.values().toArray(new SAFConversationRuntimeMBean[this.conversations.size()]);
    }

    public long getConversationsCurrentCount() {
        return this.conversationsCurrentCount;
    }

    public long getConversationsHighCount() {
        return this.conversationsHighCount;
    }

    public long getConversationsTotalCount() {
        return this.conversationsTotalCount;
    }

    public synchronized long getMessagesCurrentCount() {
        return this.kernelTopic.getStatistics().getMessagesCurrent() - this.kernelTopic.getStatistics().getMessagesPending();
    }

    public long getMessagesPendingCount() {
        return this.kernelTopic.getStatistics().getMessagesPending();
    }

    public long getMessagesHighCount() {
        return this.kernelTopic.getStatistics().getMessagesHigh();
    }

    public long getMessagesReceivedCount() {
        return this.kernelTopic.getStatistics().getMessagesReceived();
    }

    public synchronized long getBytesCurrentCount() {
        return this.kernelTopic.getStatistics().getBytesCurrent() - this.kernelTopic.getStatistics().getBytesPending();
    }

    public long getBytesPendingCount() {
        return this.kernelTopic.getStatistics().getBytesPending();
    }

    public long getBytesHighCount() {
        return this.kernelTopic.getStatistics().getBytesHigh();
    }

    public long getBytesReceivedCount() {
        return this.kernelTopic.getStatistics().getBytesReceived();
    }

    public synchronized long getFailedMessagesTotal() {
        return this.failedMessagesTotal;
    }

    public String getMessages(String string, Integer n) throws ManagementException {
        if (SAFDebug.SAFAdmin.isDebugEnabled()) {
            SAFDebug.SAFAdmin.debug("getMessages() is called on " + this.getName());
        }
        Cursor cursor = null;
        try {
            cursor = this.createCursor(string);
            if (SAFDebug.SAFAdmin.isDebugEnabled()) {
                SAFDebug.SAFAdmin.debug("getMessages(): found " + cursor.size() + " messages");
            }
        }
        catch (KernelException kernelException) {
            kernelException.printStackTrace();
            throw new ManagementException(kernelException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ManagementException(exception.getMessage());
        }
        SAFMessageCursorDelegate sAFMessageCursorDelegate = new SAFMessageCursorDelegate(this, this.openDataConverter, cursor, this.openDataConverter, n);
        this.addCursorDelegate(sAFMessageCursorDelegate);
        return sAFMessageCursorDelegate.getHandle();
    }

    public boolean isConnected() {
        return this.addition.isConnected();
    }

    public void connected() {
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && !this.isConnected()) {
            SAFLogger.logSAFConnected((String)this.url);
        }
        this.addition.connected();
    }

    public void disconnected(Exception exception) {
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && this.isConnected()) {
            SAFLogger.logSAFDisconnected((String)this.url, (String)StackTraceUtils.throwable2StackTrace((Throwable)exception));
        }
        this.addition.disconnected(exception);
    }

    public long getDowntimeHigh() {
        return this.addition.getDowntimeHigh();
    }

    public long getDowntimeTotal() {
        return this.addition.getDowntimeTotal();
    }

    public long getUptimeHigh() {
        return this.addition.getUptimeHigh();
    }

    public long getUptimeTotal() {
        return this.addition.getUptimeTotal();
    }

    public synchronized Date getLastTimeConnected() {
        return this.addition.getLastTimeConnected();
    }

    public synchronized Date getLastTimeFailedToConnect() {
        return this.addition.getLastTimeFailedToConnect();
    }

    public synchronized Exception getLastException() {
        return this.addition.getLastException();
    }

    public synchronized String getOperationState() {
        return this.addition.getOperationState().toString();
    }

    void close() {
        try {
            PrivilegedActionUtilities.unregister(this.delegate, kernelId);
        }
        catch (ManagementException managementException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendKernelQueues(int n) throws SAFException {
        Iterator iterator = null;
        KernelException kernelException = null;
        RuntimeMBeanDelegate runtimeMBeanDelegate = this;
        synchronized (runtimeMBeanDelegate) {
            iterator = ((HashMap)this.conversations.clone()).values().iterator();
        }
        while (iterator.hasNext()) {
            runtimeMBeanDelegate = (ConversationRuntimeDelegate)iterator.next();
            ConversationAssembler conversationAssembler = runtimeMBeanDelegate.getConversation();
            try {
                conversationAssembler.getSubscriptionQueue().suspend(n);
            }
            catch (KernelException kernelException2) {
                if (kernelException != null) continue;
                kernelException = kernelException2;
            }
        }
        if (kernelException != null) {
            throw new SAFException(kernelException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeKernelQueues(int n) throws SAFException {
        Iterator iterator = null;
        KernelException kernelException = null;
        RuntimeMBeanDelegate runtimeMBeanDelegate = this;
        synchronized (runtimeMBeanDelegate) {
            iterator = ((HashMap)this.conversations.clone()).values().iterator();
        }
        while (iterator.hasNext()) {
            runtimeMBeanDelegate = (ConversationRuntimeDelegate)iterator.next();
            ConversationAssembler conversationAssembler = runtimeMBeanDelegate.getConversation();
            try {
                conversationAssembler.getSubscriptionQueue().resume(n);
            }
            catch (KernelException kernelException2) {
                if (kernelException != null) continue;
                kernelException = kernelException2;
            }
        }
        if (kernelException != null) {
            throw new SAFException(kernelException);
        }
    }
}

