/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.internal;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import weblogic.descriptor.DescriptorBean;
import weblogic.health.HealthState;
import weblogic.jms.saf.SAFAgentRuntimeMBeanAggregator;
import weblogic.jms.saf.SAFService;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.PersistentStoreMBean;
import weblogic.management.configuration.SAFAgentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.SAFAgentRuntimeMBean;
import weblogic.management.runtime.SAFConversationRuntimeMBean;
import weblogic.management.runtime.SAFRemoteEndpointRuntimeMBean;
import weblogic.management.utils.GenericBeanListener;
import weblogic.messaging.ID;
import weblogic.messaging.kernel.Topic;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.common.SAFDebug;
import weblogic.messaging.saf.internal.Agent;
import weblogic.messaging.saf.internal.ReceivingAgentImpl;
import weblogic.messaging.saf.internal.RemoteEndpointRuntimeDelegate;
import weblogic.messaging.saf.internal.SAFServiceAdmin;
import weblogic.messaging.saf.internal.SAFStatisticsCommonMBeanImpl;
import weblogic.messaging.saf.internal.SendingAgentImpl;
import weblogic.messaging.saf.store.SAFStore;
import weblogic.messaging.saf.store.SAFStoreManager;
import weblogic.messaging.saf.utils.Util;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

public final class SAFAgentAdmin
extends SAFStatisticsCommonMBeanImpl
implements SAFAgentRuntimeMBean {
    static final long serialVersionUID = 4301254277290100353L;
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    public static final int SENDING_ONLY = 1;
    public static final int RECEIVING_ONLY = 2;
    public static final int BOTH = 3;
    private SAFServiceAdmin safServiceAdmin;
    private SAFAgentMBean mbean;
    private PersistentStoreMBean storeMBean;
    private SendingAgentImpl sendingAgent;
    private ReceivingAgentImpl receivingAgent;
    private int agentType;
    private HashMap remoteEndpoints;
    private int remoteEndpointsCurrentCount;
    private int remoteEndpointsHighCount;
    private int remoteEndpointsTotalCount;
    private GenericBeanListener changeListener;
    private static final HashMap agentBeanAttributes = new HashMap();
    private String agentName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SAFAgentAdmin(SAFServiceAdmin sAFServiceAdmin, SAFAgentMBean sAFAgentMBean) throws ManagementException {
        super(sAFAgentMBean.getName(), null, false);
        Object object;
        SAFService.getSAFService().getRuntimeMBean().getAgent(sAFAgentMBean.getName()).setDelegate2(this);
        this.safServiceAdmin = sAFServiceAdmin;
        this.mbean = sAFAgentMBean;
        this.storeMBean = sAFAgentMBean.getStore();
        this.remoteEndpoints = new HashMap();
        SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID);
        String string = null;
        try {
            object = ManagementService.getRuntimeAccess(KERNEL_ID);
            string = object.getServerName();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
            throw throwable;
        }
        SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
        object = string;
        if (this.isMigratable(sAFAgentMBean)) {
            object = sAFAgentMBean.getTargets()[0].getName();
        }
        this.agentName = sAFAgentMBean.getName() + "@" + (String)object;
        this.checkTargets();
        this.changeListener = new GenericBeanListener((DescriptorBean)sAFAgentMBean, (Object)this, (Map)agentBeanAttributes, null);
    }

    SAFServiceAdmin getSAFServiceAdmin() {
        return this.safServiceAdmin;
    }

    int getAgentType() {
        return this.agentType;
    }

    public SAFAgentMBean getMBean() {
        return this.mbean;
    }

    private void checkTargets() throws DeploymentException {
        TargetMBean[] targetMBeanArray = this.mbean.getTargets();
        PersistentStoreMBean persistentStoreMBean = this.mbean.getStore();
        if (persistentStoreMBean == null) {
            return;
        }
        TargetMBean[] targetMBeanArray2 = persistentStoreMBean.getTargets();
        if (targetMBeanArray2.length > 1) {
            DeploymentException deploymentException = new DeploymentException("SAF Agent = " + this.mbean.getName() + " has a Persistent Store = " + persistentStoreMBean.getName() + " which has multiple targets");
            throw deploymentException;
        }
        if (targetMBeanArray2.length == 0) {
            DeploymentException deploymentException = new DeploymentException("SAF Agent= " + this.mbean.getName() + " has a Persistent Store " + persistentStoreMBean.getName() + " which is not targetted");
            throw deploymentException;
        }
        if (targetMBeanArray.length > 1) {
            DeploymentException deploymentException = new DeploymentException("SAF Agent = " + this.mbean.getName() + " has multiple Tragets");
            throw deploymentException;
        }
        if (!targetMBeanArray[0].getName().equals(targetMBeanArray2[0].getName())) {
            DeploymentException deploymentException = new DeploymentException("SAF Agent = " + this.mbean.getName() + " Target = " + targetMBeanArray[0].getName() + " is not the same as Targets of the " + "Persistent Store = " + persistentStoreMBean.getName() + " Targets = " + targetMBeanArray2[0].getName());
            throw deploymentException;
        }
    }

    void start() throws NamingException, SAFException {
        String string = this.mbean.getServiceType();
        if ("Sending-only".equals(string)) {
            this.findOrCreateSendingAgentImpl(this.agentName);
            this.agentType = 1;
        } else if ("Receiving-only".equals(string)) {
            this.findOrCreateReceivingAgentImpl(this.agentName);
            this.agentType = 2;
        } else if ("Both".equals(string)) {
            this.findOrCreateSendingAgentImpl(this.agentName);
            this.findOrCreateReceivingAgentImpl(this.agentName);
            this.agentType = 3;
        }
    }

    private SAFStore createSAFStore(String string, boolean bl) throws SAFException {
        return SAFStoreManager.getManager().createSAFStore(this.storeMBean, string, bl);
    }

    private void findOrCreateSendingAgentImpl(String string) throws NamingException, SAFException {
        SAFStore sAFStore = this.createSAFStore(string, false);
        this.sendingAgent = (SendingAgentImpl)sAFStore.getSendingAgent();
        if (this.sendingAgent == null) {
            this.sendingAgent = new SendingAgentImpl(string, this, sAFStore);
        } else {
            this.sendingAgent.init(string, this, sAFStore);
        }
    }

    private void findOrCreateReceivingAgentImpl(String string) throws NamingException, SAFException {
        SAFStore sAFStore = this.createSAFStore(string, true);
        this.receivingAgent = (ReceivingAgentImpl)sAFStore.getReceivingAgent();
        if (this.receivingAgent == null) {
            this.receivingAgent = new ReceivingAgentImpl(string, this, sAFStore);
        } else {
            this.receivingAgent.init(string, this, sAFStore);
        }
    }

    Agent getSendingAgentImpl() {
        return this.sendingAgent;
    }

    Agent getReceivingAgentImpl() {
        return this.receivingAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        SAFAgentRuntimeMBeanAggregator sAFAgentRuntimeMBeanAggregator = SAFService.getSAFService().getRuntimeMBean().getAgent(this.name);
        if (sAFAgentRuntimeMBeanAggregator != null) {
            sAFAgentRuntimeMBeanAggregator.setDelegate2(null);
        }
        if (this.changeListener != null) {
            this.changeListener.close();
            this.changeListener = null;
        }
        try {
            if (this.sendingAgent != null) {
                this.sendingAgent.close(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.receivingAgent != null) {
                this.receivingAgent.close(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Iterator iterator = null;
        SAFStatisticsCommonMBeanImpl sAFStatisticsCommonMBeanImpl = this;
        synchronized (sAFStatisticsCommonMBeanImpl) {
            iterator = ((HashMap)this.remoteEndpoints.clone()).values().iterator();
            this.remoteEndpoints.clear();
        }
        while (iterator.hasNext()) {
            try {
                sAFStatisticsCommonMBeanImpl = (RemoteEndpointRuntimeDelegate)iterator.next();
                ((RemoteEndpointRuntimeDelegate)sAFStatisticsCommonMBeanImpl).close();
            }
            catch (Exception exception) {}
        }
    }

    void suspend(boolean bl) {
        if (this.sendingAgent != null) {
            this.sendingAgent.suspend(bl);
        }
        if (this.receivingAgent != null) {
            this.receivingAgent.suspend(bl);
        }
    }

    void resume() throws SAFException {
        if (this.sendingAgent != null) {
            this.sendingAgent.resume();
        }
        if (this.receivingAgent != null) {
            this.receivingAgent.resume();
        }
    }

    synchronized RemoteEndpointRuntimeDelegate findOrCreateRemoteEndpointRuntime(String string, int n, final Topic topic) throws ManagementException {
        RemoteEndpointRuntimeDelegate remoteEndpointRuntimeDelegate = (RemoteEndpointRuntimeDelegate)this.remoteEndpoints.get(string);
        if (remoteEndpointRuntimeDelegate != null) {
            return remoteEndpointRuntimeDelegate;
        }
        final String string2 = string;
        final int n2 = n;
        final ID iD = Util.generateID();
        final SAFAgentAdmin sAFAgentAdmin = this;
        try {
            remoteEndpointRuntimeDelegate = (RemoteEndpointRuntimeDelegate)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ManagementException {
                    return new RemoteEndpointRuntimeDelegate(sAFAgentAdmin, iD, string2, n2, topic);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ManagementException)((Object)privilegedActionException.getException());
        }
        ++this.remoteEndpointsCurrentCount;
        ++this.remoteEndpointsTotalCount;
        if (this.remoteEndpointsCurrentCount > this.remoteEndpointsHighCount) {
            this.remoteEndpointsHighCount = this.remoteEndpointsCurrentCount;
        }
        this.remoteEndpoints.put(string, remoteEndpointRuntimeDelegate);
        return remoteEndpointRuntimeDelegate;
    }

    synchronized RemoteEndpointRuntimeDelegate getRemoteEndpoint(String string) {
        return (RemoteEndpointRuntimeDelegate)this.remoteEndpoints.get(string);
    }

    synchronized void removeRemoteEndpoint(RemoteEndpointRuntimeDelegate remoteEndpointRuntimeDelegate) {
        RemoteEndpointRuntimeDelegate remoteEndpointRuntimeDelegate2 = (RemoteEndpointRuntimeDelegate)this.remoteEndpoints.remove(remoteEndpointRuntimeDelegate.getURL());
        if (remoteEndpointRuntimeDelegate2 != null) {
            --this.remoteEndpointsCurrentCount;
            remoteEndpointRuntimeDelegate2.close();
        }
    }

    public HealthState getHealthState() {
        HealthState healthState = null;
        HealthState healthState2 = null;
        if (this.sendingAgent != null) {
            healthState = this.sendingAgent.getHealthState();
        }
        if (this.receivingAgent != null) {
            healthState = this.receivingAgent.getHealthState();
        }
        return this.combineState(healthState, healthState2);
    }

    public synchronized SAFRemoteEndpointRuntimeMBean[] getRemoteEndpoints() {
        SAFRemoteEndpointRuntimeMBean[] sAFRemoteEndpointRuntimeMBeanArray = new RemoteEndpointRuntimeDelegate[this.remoteEndpoints.size()];
        this.remoteEndpoints.values().toArray(sAFRemoteEndpointRuntimeMBeanArray);
        return sAFRemoteEndpointRuntimeMBeanArray;
    }

    public synchronized long getRemoteEndpointsCurrentCount() {
        return this.remoteEndpointsCurrentCount;
    }

    public synchronized long getRemoteEndpointsHighCount() {
        return this.remoteEndpointsHighCount;
    }

    public synchronized long getRemoteEndpointsTotalCount() {
        return this.remoteEndpointsTotalCount;
    }

    public void pauseIncoming() throws SAFException {
        if (this.sendingAgent != null) {
            if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                SAFDebug.SAFAdmin.debug("Pausing sending agent " + this.getName() + " for incoming");
            }
            this.sendingAgent.pauseIncoming();
        }
    }

    public void resumeIncoming() throws SAFException {
        if (this.sendingAgent != null) {
            if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                SAFDebug.SAFAdmin.debug("Resuming sending agent " + this.getName() + " for incoming");
            }
            this.sendingAgent.resumeIncoming();
        }
    }

    public boolean isPausedForIncoming() {
        if (this.sendingAgent != null) {
            return this.sendingAgent.isPausedForIncoming();
        }
        return false;
    }

    public void pauseForwarding() throws SAFException {
        if (this.sendingAgent != null) {
            if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                SAFDebug.SAFAdmin.debug("Pausing sending agent " + this.getName() + " for forwarding");
            }
            this.sendingAgent.pauseForwarding();
        }
    }

    public void resumeForwarding() throws SAFException {
        if (this.sendingAgent != null) {
            if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                SAFDebug.SAFAdmin.debug("Resuming sending agent " + this.getName() + " for forwarding");
            }
            this.sendingAgent.resumeForwarding();
        }
    }

    public boolean isPausedForForwarding() {
        if (this.sendingAgent != null) {
            return this.sendingAgent.isPausedForForwarding();
        }
        return false;
    }

    public void pauseReceiving() throws SAFException {
        if (this.receivingAgent != null) {
            if (SAFDebug.SAFReceivingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                SAFDebug.SAFAdmin.debug("Pausing receiving agent " + this.getName() + " for receiving");
            }
            this.receivingAgent.pauseReceiving();
        }
    }

    public void resumeReceiving() throws SAFException {
        if (this.receivingAgent != null) {
            if (SAFDebug.SAFReceivingAgent.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                SAFDebug.SAFAdmin.debug("Resuming receiving agent " + this.getName() + " for receiving");
            }
            this.receivingAgent.resumeReceiving();
        }
    }

    public boolean isPausedForReceiving() {
        if (this.receivingAgent != null) {
            return this.receivingAgent.isPausedForReceiving();
        }
        return false;
    }

    public SAFConversationRuntimeMBean[] getConversations() {
        if (this.sendingAgent != null) {
            return this.sendingAgent.getConversationRuntimeDelegates();
        }
        return new SAFConversationRuntimeMBean[0];
    }

    public long getConversationsCurrentCount() {
        if (this.sendingAgent != null) {
            return this.sendingAgent.getConversationsCurrentCount();
        }
        return 0L;
    }

    public long getConversationsHighCount() {
        if (this.sendingAgent != null) {
            return this.sendingAgent.getConversationsHighCount();
        }
        return 0L;
    }

    public long getConversationsTotalCount() {
        if (this.sendingAgent != null) {
            return this.sendingAgent.getConversationsTotalCount();
        }
        return 0L;
    }

    public long getMessagesCurrentCount() {
        return 0L;
    }

    public long getMessagesPendingCount() {
        return 0L;
    }

    public long getMessagesHighCount() {
        return 0L;
    }

    public long getMessagesReceivedCount() {
        return 0L;
    }

    public long getMessagesThresholdTime() {
        return 0L;
    }

    public long getBytesCurrentCount() {
        return 0L;
    }

    public long getBytesPendingCount() {
        return 0L;
    }

    public long getBytesHighCount() {
        return 0L;
    }

    public long getBytesReceivedCount() {
        return 0L;
    }

    public long getBytesThresholdTime() {
        return 0L;
    }

    public long getFailedMessagesTotal() {
        if (this.sendingAgent != null) {
            return this.sendingAgent.getFailedMessagesTotal();
        }
        return 0L;
    }

    public long getDefaultRetryDelayBase() {
        return this.mbean.getDefaultRetryDelayBase();
    }

    public long getDefaultRetryDelayMaximum() {
        return this.mbean.getDefaultRetryDelayMaximum();
    }

    public double getDefaultRetryDelayMultiplier() {
        return this.mbean.getDefaultRetryDelayMultiplier();
    }

    public long getDefaultTimeToLive() {
        return this.mbean.getDefaultTimeToLive();
    }

    public long getMessageBufferSize() {
        return this.mbean.getMessageBufferSize();
    }

    public long getConversationIdleTimeMaximum() {
        return this.mbean.getConversationIdleTimeMaximum();
    }

    public long getBytesMaximum() {
        return this.mbean.getBytesMaximum();
    }

    public long getBytesThresholdHigh() {
        return this.mbean.getBytesThresholdHigh();
    }

    public long getBytesThresholdLow() {
        return this.mbean.getBytesThresholdLow();
    }

    public long getMessagesMaximum() {
        return this.mbean.getMessagesMaximum();
    }

    public long getMessagesThresholdHigh() {
        return this.mbean.getMessagesThresholdHigh();
    }

    public long getMessagesThresholdLow() {
        return this.mbean.getMessagesThresholdLow();
    }

    public int getMaximumMessageSize() {
        return this.mbean.getMaximumMessageSize();
    }

    public boolean isLoggingEnabled() {
        return this.mbean.isLoggingEnabled();
    }

    public int getWindowSize() {
        return this.mbean.getWindowSize();
    }

    public long getAcknowledgeInterval() {
        return this.mbean.getAcknowledgeInterval();
    }

    public void setDefaultRetryDelayBase(long l) {
        if (this.sendingAgent != null) {
            this.sendingAgent.setDefaultRetryDelayBase(l);
        }
    }

    public void setDefaultRetryDelayMaximum(long l) {
        if (this.sendingAgent != null) {
            this.sendingAgent.setDefaultRetryDelayMaximum(l);
        }
    }

    public void setDefaultRetryDelayMultiplier(double d) {
        if (this.sendingAgent != null) {
            this.sendingAgent.setDefaultRetryDelayMultiplier(d);
        }
    }

    public void setDefaultTimeToLive(long l) {
        if (this.sendingAgent != null) {
            this.sendingAgent.setDefaultTimeToLive(l);
        }
        if (this.receivingAgent != null) {
            this.receivingAgent.setDefaultTimeToLive(l);
        }
    }

    public void setMessageBufferSize(long l) {
    }

    public void setConversationIdleTimeMaximum(long l) {
        if (this.sendingAgent != null) {
            this.sendingAgent.setConversationIdleTimeMaximum(l);
        }
        if (this.receivingAgent != null) {
            this.receivingAgent.setConversationIdleTimeMaximum(l);
        }
    }

    public void setBytesMaximum(long l) {
    }

    public void setBytesThresholdHigh(long l) {
    }

    public void setBytesThresholdLow(long l) {
    }

    public void setMessagesMaximum(long l) {
    }

    public void setMessagesThresholdHigh(long l) {
    }

    public void setMessagesThresholdLow(long l) {
    }

    public void setMaximumMessageSize(int n) {
    }

    public void setLoggingEnabled(boolean bl) {
        if (this.sendingAgent != null) {
            this.sendingAgent.setLoggingEnabled(bl);
        }
    }

    public void setWindowSize(int n) {
        if (this.sendingAgent != null) {
            this.sendingAgent.setWindowSize(n);
        }
        if (this.receivingAgent != null) {
            this.receivingAgent.setWindowSize(n);
        }
    }

    public void setAcknowledgeInterval(long l) {
        if (this.receivingAgent != null) {
            this.receivingAgent.setAcknowledgementInterval(l);
        }
    }

    private HealthState combineState(HealthState healthState, HealthState healthState2) {
        if (healthState == null) {
            return healthState2;
        }
        if (healthState2 == null) {
            return healthState;
        }
        if (healthState.getState() <= healthState2.getState()) {
            return healthState2;
        }
        return healthState;
    }

    boolean isActiveForWSRM() {
        SAFConversationRuntimeMBean[] sAFConversationRuntimeMBeanArray = this.getConversations();
        if (sAFConversationRuntimeMBeanArray == null || sAFConversationRuntimeMBeanArray.length == 0) {
            if (this.sendingAgent != null) {
                this.sendingAgent.pauseIncoming();
            }
            if (this.receivingAgent != null) {
                this.receivingAgent.pauseReceiving();
            }
            return false;
        }
        return true;
    }

    private boolean isMigratable(SAFAgentMBean sAFAgentMBean) {
        TargetMBean[] targetMBeanArray = sAFAgentMBean.getTargets();
        if (targetMBeanArray == null || targetMBeanArray.length == 0) {
            return false;
        }
        return targetMBeanArray[0] instanceof MigratableTargetMBean;
    }

    static {
        agentBeanAttributes.put("AcknowledgeInterval", Long.TYPE);
        agentBeanAttributes.put("BytesMaximum", Long.TYPE);
        agentBeanAttributes.put("BytesThresholdHigh", Long.TYPE);
        agentBeanAttributes.put("BytesThresholdLow", Long.TYPE);
        agentBeanAttributes.put("ConversationIdleTimeMaximum", Long.TYPE);
        agentBeanAttributes.put("DefaultRetryDelayBase", Long.TYPE);
        agentBeanAttributes.put("DefaultRetryDelayMaximum", Long.TYPE);
        agentBeanAttributes.put("DefaultRetryDelayMultiplier", Double.TYPE);
        agentBeanAttributes.put("DefaultTimeToLive", Long.TYPE);
        agentBeanAttributes.put("LoggingEnabled", Boolean.TYPE);
        agentBeanAttributes.put("MaximumMessageSize", Integer.TYPE);
        agentBeanAttributes.put("MessagesMaximum", Long.TYPE);
        agentBeanAttributes.put("MessagesThresholdHigh", Long.TYPE);
        agentBeanAttributes.put("MessagesThresholdLow", Long.TYPE);
        agentBeanAttributes.put("MessageBufferSize", Long.TYPE);
        agentBeanAttributes.put("WindowSize", Integer.TYPE);
    }
}

