/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import weblogic.messaging.saf.common.SAFDebug;
import weblogic.messaging.saf.internal.AgentImpl;

public final class SAFAgentFactoryInternal {
    private final List agentList = new ArrayList();
    private final Random random = new Random();
    private int agentIndx = -2;

    public synchronized void addAgent(AgentImpl agentImpl) {
        if (!this.agentList.contains(agentImpl)) {
            this.agentList.add(agentImpl);
        }
    }

    public synchronized void removeAgent(AgentImpl agentImpl) {
        int n = this.agentList.indexOf(agentImpl);
        if (n == -1) {
            return;
        }
        this.agentList.remove(agentImpl);
        if (this.agentIndx >= n) {
            --this.agentIndx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentImpl getAgentImpl(String string) {
        AgentImpl agentImpl = null;
        SAFAgentFactoryInternal sAFAgentFactoryInternal = this;
        synchronized (sAFAgentFactoryInternal) {
            int n;
            ArrayList<AgentImpl> arrayList;
            if (string != null) {
                arrayList = new ArrayList<AgentImpl>();
                for (Object e : this.agentList) {
                    AgentImpl agentImpl2 = (AgentImpl)e;
                    if (!agentImpl2.getStoreName().equals(string)) continue;
                    arrayList.add(agentImpl2);
                }
            } else {
                arrayList = this.agentList;
            }
            if ((n = arrayList.size()) == 0) {
                return null;
            }
            this.agentIndx = this.agentIndx == -2 ? this.random.nextInt(n) : ++this.agentIndx;
            this.agentIndx %= n;
            if (this.agentIndx > n - 1) {
                this.agentIndx = n - 1;
            }
            agentImpl = (AgentImpl)arrayList.get(this.agentIndx);
        }
        if (SAFDebug.SAFSendingAgent.isDebugEnabled() && SAFDebug.SAFReceivingAgent.isDebugEnabled()) {
            SAFDebug.SAFSendingAgent.debug("SAFAgentFactory.getSAFAgent = " + agentImpl);
        }
        return agentImpl;
    }

    synchronized boolean haveSendingAgentAvailable() {
        return this.agentList.size() != 0;
    }
}

