/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.internal;

import weblogic.messaging.kernel.MessageElement;
import weblogic.messaging.saf.SAFRequest;

public class SAFCursorKey {
    private static final int KEY_TYPE_SAF_CONVERSATIONNAME = 0;
    private static final int KEY_TYPE_SAF_SEQUENCENUMBER = 1;
    private static final int KEY_TYPE_SAF_TIMETOLIVE = 2;
    private static final int KEY_TYPE_SAF_MESSAGEID = 3;
    private static final String PROP_NAME_CONVERSATIONNAME = "ConversationName";
    private static final String PROP_NAME_SEQUENCENUMBER = "SequenceNumber";
    private static final String PROP_NAME_TIMETOLIVE = "TimeToLive";
    private static final String PROP_NAME_MESSAGEID = "MessageId";
    private final boolean asending;
    private int keyType;

    public SAFCursorKey(String string, boolean bl) {
        this.asending = bl;
        if (string.equalsIgnoreCase(PROP_NAME_CONVERSATIONNAME)) {
            this.keyType = 0;
        } else if (string.equalsIgnoreCase(PROP_NAME_SEQUENCENUMBER)) {
            this.keyType = 1;
        } else if (string.equalsIgnoreCase(PROP_NAME_TIMETOLIVE)) {
            this.keyType = 2;
        } else if (string.equalsIgnoreCase(PROP_NAME_MESSAGEID)) {
            this.keyType = 3;
        }
    }

    long compareKey(MessageElement messageElement, MessageElement messageElement2) {
        long l = 0L;
        SAFRequest sAFRequest = (SAFRequest)messageElement.getMessage();
        SAFRequest sAFRequest2 = (SAFRequest)messageElement2.getMessage();
        switch (this.keyType) {
            case 0: {
                if (sAFRequest.getConversationName() != null && sAFRequest2.getConversationName() != null) {
                    l = sAFRequest.getConversationName().compareTo(sAFRequest2.getConversationName());
                    break;
                }
                if (sAFRequest.getConversationName() != null) {
                    l = 1L;
                    break;
                }
                if (sAFRequest2.getConversationName() != null) {
                    l = -1L;
                    break;
                }
                l = 0L;
                break;
            }
            case 3: {
                if (sAFRequest.getMessageId() != null && sAFRequest2.getMessageId() != null) {
                    l = sAFRequest.getMessageId().compareTo(sAFRequest2.getMessageId());
                    break;
                }
                if (sAFRequest.getMessageId() != null) {
                    l = 1L;
                    break;
                }
                if (sAFRequest2.getMessageId() != null) {
                    l = -1L;
                    break;
                }
                l = 0L;
                break;
            }
            case 1: {
                if (sAFRequest.getConversationName() == null || sAFRequest2.getConversationName() == null) break;
                l = sAFRequest.getSequenceNumber() - sAFRequest2.getSequenceNumber();
                break;
            }
            case 2: {
                l = sAFRequest.getSequenceNumber() - sAFRequest2.getSequenceNumber();
                break;
            }
            default: {
                l = 0L;
            }
        }
        if (this.asending) {
            return l;
        }
        return -l;
    }
}

