/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.diagnostics.image.ImageSourceCreationException;
import weblogic.health.HealthState;
import weblogic.messaging.kernel.runtime.MessagingKernelDiagnosticImageSource;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;
import weblogic.messaging.saf.internal.SAFManagerImpl;
import weblogic.xml.stax.util.XMLPrettyPrinter;

public final class SAFDiagnosticImageSource
extends MessagingKernelDiagnosticImageSource {
    public void createDiagnosticImage(OutputStream outputStream) throws ImageSourceCreationException {
        try {
            XMLPrettyPrinter xMLPrettyPrinter = new XMLPrettyPrinter((Writer)new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8")), 2);
            xMLPrettyPrinter.writeStartDocument();
            try {
                ((SAFManagerImpl)SAFManagerImpl.getManager()).dump(this, (XMLStreamWriter)xMLPrettyPrinter);
            }
            catch (DiagnosticImageTimeoutException diagnosticImageTimeoutException) {
                this.dumpTimeoutComment((XMLStreamWriter)xMLPrettyPrinter);
                return;
            }
            xMLPrettyPrinter.writeEndDocument();
            xMLPrettyPrinter.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ImageSourceCreationException("SAF image creation failed.", (Throwable)xMLStreamException);
        }
        catch (IOException iOException) {
            throw new ImageSourceCreationException("SAF image creation failed.", (Throwable)iOException);
        }
    }

    public static void dumpHealthStateElement(XMLStreamWriter xMLStreamWriter, HealthState healthState) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("Health");
        xMLStreamWriter.writeAttribute("state", HealthState.mapToString(healthState.getState()));
        String[] stringArray = healthState.getReasonCode();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                xMLStreamWriter.writeStartElement("Reason");
                xMLStreamWriter.writeCharacters(stringArray[i]);
                xMLStreamWriter.writeEndElement();
            }
        }
        xMLStreamWriter.writeEndElement();
    }
}

