/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.internal;

import java.io.Externalizable;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.health.HealthState;
import weblogic.jms.saf.SAFService;
import weblogic.management.provider.ManagementService;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;
import weblogic.messaging.saf.SAFConversationHandle;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFConversationNotAvailException;
import weblogic.messaging.saf.SAFEndpointManager;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.SAFManager;
import weblogic.messaging.saf.SAFRequest;
import weblogic.messaging.saf.SAFResult;
import weblogic.messaging.saf.SAFServiceNotAvailException;
import weblogic.messaging.saf.SAFTransport;
import weblogic.messaging.saf.common.AgentDeliverRequest;
import weblogic.messaging.saf.common.AgentDeliverResponse;
import weblogic.messaging.saf.common.SAFConversationHandleImpl;
import weblogic.messaging.saf.common.SAFDebug;
import weblogic.messaging.saf.common.SAFRemoteContext;
import weblogic.messaging.saf.internal.AgentImpl;
import weblogic.messaging.saf.internal.ConversationAssembler;
import weblogic.messaging.saf.internal.ConversationReassembler;
import weblogic.messaging.saf.internal.ReceivingAgentImpl;
import weblogic.messaging.saf.internal.SAFAgentFactoryInternal;
import weblogic.messaging.saf.internal.SAFDiagnosticImageSource;
import weblogic.messaging.saf.internal.SAFServerService;
import weblogic.messaging.saf.internal.SendingAgentImpl;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServiceFailureException;
import weblogic.transaction.TransactionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SAFManagerImpl
implements SAFManager {
    private static final SAFManagerImpl manager = new SAFManagerImpl();
    private final Map endpointManagers = Collections.synchronizedMap(new HashMap());
    private final Map transports = Collections.synchronizedMap(new HashMap());
    private final HashMap conversationInfosOnSendingSide = new HashMap();
    private final HashMap conversationInfosOnReceivingSide = new HashMap();
    private final List localSendingAgents = Collections.synchronizedList(new ArrayList());
    private final Map localSendingAgentIdsByConversationName = Collections.synchronizedMap(new HashMap());
    private final List localReceivingAgents = Collections.synchronizedList(new ArrayList());
    private List<SAFManager.ConversationLifecycleListener> conversationLifecycleListeners = Collections.synchronizedList(new ArrayList());

    private SAFManagerImpl() {
    }

    public static synchronized SAFManager getManager() {
        return manager;
    }

    @Override
    public void send(SAFRequest sAFRequest) throws SAFException {
        SAFConversationInfo sAFConversationInfo;
        SAFManagerImpl.checkShutdown();
        if (SAFDebug.SAFManager.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("send(): conversationName= " + sAFRequest.getConversationName() + " MessageId = " + sAFRequest.getMessageId() + " transaction = " + TransactionHelper.getTransactionHelper().getTransaction());
        }
        if ((sAFConversationInfo = this.getCachedConversationInfoOnSendingSide(sAFRequest.getConversationName())) == null) {
            throw new SAFConversationNotAvailException("Cannot send a message to an unknow conversation");
        }
        SendingAgentImpl sendingAgentImpl = this.getSendingAgent(sAFConversationInfo, null);
        sendingAgentImpl.send(sAFRequest);
    }

    @Override
    public void deliver(SAFConversationInfo sAFConversationInfo, SAFRequest sAFRequest) throws SAFException {
        SAFManagerImpl.checkShutdown();
        if (SAFDebug.SAFManager.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("deliver(): " + sAFRequest.getSequenceNumber());
        }
        AgentDeliverRequest agentDeliverRequest = new AgentDeliverRequest(sAFConversationInfo, sAFRequest, false);
        this.deliverInternal(agentDeliverRequest);
    }

    @Override
    public SAFResult deliverSync(SAFConversationInfo sAFConversationInfo, SAFRequest sAFRequest) throws SAFException {
        SAFManagerImpl.checkShutdown();
        if (SAFDebug.SAFManager.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("deliverSync(): " + sAFRequest.getSequenceNumber());
        }
        AgentDeliverRequest agentDeliverRequest = new AgentDeliverRequest(sAFConversationInfo, sAFRequest, true);
        AgentDeliverResponse agentDeliverResponse = this.deliverInternal(agentDeliverRequest);
        return agentDeliverResponse.getResult();
    }

    private AgentDeliverResponse deliverInternal(AgentDeliverRequest agentDeliverRequest) throws SAFException {
        SAFConversationInfo sAFConversationInfo = agentDeliverRequest.getConversationInfo();
        assert (sAFConversationInfo != null);
        ReceivingAgentImpl receivingAgentImpl = this.getReceivingAgent(sAFConversationInfo);
        assert (receivingAgentImpl != null);
        if (SAFDebug.SAFManager.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("deliverIntenal(): conversation =  " + sAFConversationInfo.toString() + " receiving agent = " + receivingAgentImpl);
        }
        return receivingAgentImpl.deliver(agentDeliverRequest);
    }

    @Override
    public void registerTransport(SAFTransport sAFTransport) {
        if (this.transports.get(new Integer(sAFTransport.getType())) == null) {
            this.transports.put(new Integer(sAFTransport.getType()), sAFTransport);
        }
    }

    @Override
    public SAFTransport getTransport(int n) {
        return (SAFTransport)this.transports.get(new Integer(n));
    }

    @Override
    public void registerEndpointManager(int n, SAFEndpointManager sAFEndpointManager) {
        this.endpointManagers.put(new Integer(n), sAFEndpointManager);
    }

    @Override
    public SAFEndpointManager getEndpointManager(int n) {
        return (SAFEndpointManager)this.endpointManagers.get(new Integer(n));
    }

    @Override
    public String registerConversationOnSendingSide(SAFConversationInfo sAFConversationInfo) throws SAFException {
        return this.registerConversationOnSendingSide(sAFConversationInfo, null);
    }

    @Override
    public String registerConversationOnSendingSide(SAFConversationInfo sAFConversationInfo, SAFManager.ConversationNameRefinementCallback conversationNameRefinementCallback) throws SAFException {
        SAFConversationInfo sAFConversationInfo2;
        SAFManagerImpl.checkShutdown();
        if (SAFDebug.SAFManager.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("registerConversationOnSendingSide(): name = " + sAFConversationInfo.getConversationName());
        }
        if (sAFConversationInfo == null) {
            throw new IllegalArgumentException("Cannot register a conversation without a conversation info");
        }
        if (sAFConversationInfo.getRemoteContext() == null) {
            if (SAFDebug.SAFManager.isDebugEnabled()) {
                SAFDebug.SAFManager.debug("registerConversationOnSendingSide(): null remote context, create one");
            }
            sAFConversationInfo.setRemoteContext(new SAFRemoteContext());
        }
        if ((sAFConversationInfo2 = this.getCachedConversationInfoOnSendingSide(sAFConversationInfo.getConversationName())) != null) {
            return sAFConversationInfo2.getConversationName();
        }
        SendingAgentImpl sendingAgentImpl = this.getSendingAgent(sAFConversationInfo, conversationNameRefinementCallback);
        sendingAgentImpl.registerConversationInfo(sAFConversationInfo);
        return sAFConversationInfo.getConversationName();
    }

    @Override
    public void closeConversationOnSendingSide(String string, boolean bl) throws SAFException {
        SAFConversationInfo sAFConversationInfo;
        SAFManagerImpl.checkShutdown();
        if (SAFDebug.SAFManager.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("closeConversationOnSendingSide(): conversationName= " + string + " destroy? " + bl);
        }
        if ((sAFConversationInfo = this.getCachedConversationInfoOnSendingSide(string)) == null) {
            throw new SAFConversationNotAvailException("Cannot close a conversation that does not exist");
        }
        SendingAgentImpl sendingAgentImpl = this.getSendingAgent(sAFConversationInfo, null);
        sendingAgentImpl.closeConversation(string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addConversationInfoOnSendingSide(SAFConversationInfo sAFConversationInfo) {
        HashMap hashMap = this.conversationInfosOnSendingSide;
        synchronized (hashMap) {
            if (this.conversationInfosOnSendingSide.get(sAFConversationInfo.getConversationName()) == null) {
                this.conversationInfosOnSendingSide.put(sAFConversationInfo.getConversationName(), sAFConversationInfo);
                this.notifyAddConverationToCache(true, "ConversationName", sAFConversationInfo.getConversationName(), sAFConversationInfo);
                if (sAFConversationInfo.getCreateConversationMessageID() != null) {
                    this.conversationInfosOnSendingSide.put(sAFConversationInfo.getCreateConversationMessageID(), sAFConversationInfo);
                    this.notifyAddConverationToCache(true, "CreateConversationMessageD", sAFConversationInfo.getCreateConversationMessageID(), sAFConversationInfo);
                }
            }
        }
    }

    private SendingAgentImpl getSendingAgent(String string) throws SAFException {
        SendingAgentImpl sendingAgentImpl = this.getLocalSendingAgent(string);
        if (sendingAgentImpl == null) {
            sendingAgentImpl = this.findLocalSendingAgent(string);
        }
        if (sendingAgentImpl != null) {
            return sendingAgentImpl;
        }
        throw new SAFServiceNotAvailException("The SAF agent that handles conversation " + string + " is not available at the moment.");
    }

    private SendingAgentImpl getCachedSendingAgentId(SAFConversationInfo sAFConversationInfo) {
        String string = sAFConversationInfo.getCreateConversationMessageID();
        SendingAgentImpl sendingAgentImpl = this.getLocalSendingAgentId(sAFConversationInfo.getConversationName());
        if (sendingAgentImpl == null && string != null) {
            sendingAgentImpl = this.getLocalSendingAgentId(string);
        }
        return sendingAgentImpl;
    }

    private SendingAgentImpl getSendingAgent(SAFConversationInfo sAFConversationInfo, SAFManager.ConversationNameRefinementCallback conversationNameRefinementCallback) throws SAFException {
        SendingAgentImpl sendingAgentImpl = this.getCachedSendingAgentId(sAFConversationInfo);
        if (sendingAgentImpl != null) {
            return sendingAgentImpl;
        }
        sendingAgentImpl = (SendingAgentImpl)SAFManagerImpl.getNextLocalAgent(SendingAgentImpl.getAgentFactory(), null);
        if (SAFDebug.SAFManager.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("getSendingAgent(): candidated agent = " + sendingAgentImpl);
        }
        if (sendingAgentImpl != null) {
            if (conversationNameRefinementCallback != null) {
                SAFManager.LocationInfo locationInfo = new SAFManager.LocationInfo(sendingAgentImpl.getStoreName());
                conversationNameRefinementCallback.conversationPreStore(sAFConversationInfo, locationInfo);
            }
            this.addLocalSendingAgentId(sAFConversationInfo, sendingAgentImpl);
        }
        if (sendingAgentImpl == null) {
            if (SendingAgentImpl.getAgentFactory().haveSendingAgentAvailable()) {
                throw new SAFServiceNotAvailException("Conversation '" + sAFConversationInfo.getConversationName() + "' does not exist, has timed out, or has been administratively destroyed");
            }
            throw new SAFServiceNotAvailException("There is no active SAF sending agent available on server '" + ManagementService.getRuntimeAccess((AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction())).getServerName() + "'.");
        }
        return sendingAgentImpl;
    }

    private ReceivingAgentImpl getReceivingAgent(SAFConversationInfo sAFConversationInfo) throws SAFException {
        ReceivingAgentImpl receivingAgentImpl = this.findLocalReceivingAgent(sAFConversationInfo);
        if (receivingAgentImpl == null) {
            if (SAFDebug.SAFManager.isDebugEnabled() && SAFDebug.SAFVerbose.isDebugEnabled()) {
                SAFDebug.SAFManager.debug("getReceivingAgent(): The SAF agent that handles conversation " + sAFConversationInfo.getConversationName() + " is not available at the moment.");
            }
            throw new SAFException("The SAF receiving agent that handles conversation:" + sAFConversationInfo.getConversationName() + " is not available at the moment.");
        }
        return receivingAgentImpl;
    }

    private static AgentImpl getNextLocalAgent(SAFAgentFactoryInternal sAFAgentFactoryInternal, String string) {
        return sAFAgentFactoryInternal.getAgentImpl(string);
    }

    void addLocalReceivingAgent(ReceivingAgentImpl receivingAgentImpl) {
        this.localReceivingAgents.add(receivingAgentImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SendingAgentImpl findLocalSendingAgent(String string) {
        Iterator iterator;
        Object object = this.localSendingAgents;
        synchronized (object) {
            iterator = this.localSendingAgents.iterator();
        }
        while (iterator.hasNext()) {
            object = (SendingAgentImpl)iterator.next();
            if (((SendingAgentImpl)object).getConversation(string) == null) continue;
            return object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReceivingAgentImpl findLocalReceivingAgent(SAFConversationInfo sAFConversationInfo) {
        Iterator iterator;
        Object object = this.localReceivingAgents;
        synchronized (object) {
            iterator = this.localReceivingAgents.iterator();
        }
        while (iterator.hasNext()) {
            object = (ReceivingAgentImpl)iterator.next();
            if (((ReceivingAgentImpl)object).getConversation(sAFConversationInfo) == null) continue;
            return object;
        }
        return null;
    }

    void removeLocalReceivingAgent(ReceivingAgentImpl receivingAgentImpl) {
        this.localReceivingAgents.remove(receivingAgentImpl);
    }

    void addLocalSendingAgent(SendingAgentImpl sendingAgentImpl) {
        this.localSendingAgents.add(sendingAgentImpl);
    }

    void removeLocalSendingAgent(SendingAgentImpl sendingAgentImpl) {
        this.localSendingAgents.remove(sendingAgentImpl);
    }

    void recordDynamicName(String string, String string2) {
        if (string.equals(string2)) {
            return;
        }
        this.localSendingAgentIdsByConversationName.put(string2, this.getLocalSendingAgentId(string));
        try {
            this.addConversationInfoOnSendingSide(string2, this.getCachedConversationInfoOnSendingSide(string));
        }
        catch (SAFException sAFException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConversationInfoOnSendingSide(String string, SAFConversationInfo sAFConversationInfo) {
        HashMap hashMap = this.conversationInfosOnSendingSide;
        synchronized (hashMap) {
            if (this.conversationInfosOnSendingSide.get(string) == null) {
                this.conversationInfosOnSendingSide.put(string, sAFConversationInfo);
                this.notifyAddConverationToCache(true, "DynamicName", string, sAFConversationInfo);
            }
        }
    }

    void addLocalSendingAgentId(SAFConversationInfo sAFConversationInfo, SendingAgentImpl sendingAgentImpl) {
        this.localSendingAgentIdsByConversationName.put(sAFConversationInfo.getConversationName(), sendingAgentImpl);
        if (sAFConversationInfo.getCreateConversationMessageID() != null) {
            this.localSendingAgentIdsByConversationName.put(sAFConversationInfo.getCreateConversationMessageID(), sendingAgentImpl);
        }
    }

    private SendingAgentImpl getLocalSendingAgentId(String string) {
        return (SendingAgentImpl)this.localSendingAgentIdsByConversationName.get(string);
    }

    private SendingAgentImpl getLocalSendingAgent(String string) {
        return (SendingAgentImpl)this.localSendingAgentIdsByConversationName.get(string);
    }

    void removeLocalSendingAgentId(SAFConversationInfo sAFConversationInfo) {
        this.localSendingAgentIdsByConversationName.remove(sAFConversationInfo.getConversationName());
        if (sAFConversationInfo.getDynamicConversationName() != null) {
            this.localSendingAgentIdsByConversationName.remove(sAFConversationInfo.getDynamicConversationName());
        }
        if (sAFConversationInfo.getCreateConversationMessageID() != null) {
            this.localSendingAgentIdsByConversationName.remove(sAFConversationInfo.getCreateConversationMessageID());
        }
        this.cleanUpConversationInfoOnSendingSide(sAFConversationInfo.getConversationName());
    }

    @Override
    public SAFConversationHandle registerConversationOnReceivingSide(SAFConversationInfo sAFConversationInfo) throws SAFException {
        return this.registerConversationOnReceivingSide(sAFConversationInfo, null, null);
    }

    @Override
    public SAFConversationHandle registerConversationOnReceivingSide(SAFConversationInfo sAFConversationInfo, SAFManager.ConversationNameRefinementCallback conversationNameRefinementCallback, String string) throws SAFException {
        Object object;
        ReceivingAgentImpl receivingAgentImpl;
        SAFManagerImpl.checkShutdown();
        if (SAFDebug.SAFManager.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("Registering conversation:" + sAFConversationInfo.getConversationName() + " on the receiving side");
        }
        if ((receivingAgentImpl = this.findLocalReceivingAgent(sAFConversationInfo)) == null) {
            receivingAgentImpl = (ReceivingAgentImpl)SAFManagerImpl.getNextLocalAgent(ReceivingAgentImpl.getAgentFactory(), string);
        }
        if (receivingAgentImpl == null) {
            throw new SAFServiceNotAvailException("There is no active SAF receiving agent available on the server" + (string != null ? " that is configured to use store '" + string + "'" : ""));
        }
        if (conversationNameRefinementCallback != null) {
            object = new SAFManager.LocationInfo(receivingAgentImpl.getStoreName());
            conversationNameRefinementCallback.conversationPreStore(sAFConversationInfo, (SAFManager.LocationInfo)object);
        }
        this.addConversationInfoOnReceivingSide(sAFConversationInfo);
        object = receivingAgentImpl.getConversation(sAFConversationInfo);
        if (object == null) {
            object = receivingAgentImpl.createConversation(sAFConversationInfo, true);
        }
        if (object == null) {
            SAFException sAFException = new SAFException("Cannot send messages to a conversation that was never registered, timed out, or destroyed");
            throw sAFException;
        }
        ((ConversationReassembler)object).setAgentConnectionEstablished();
        return new SAFConversationHandleImpl(sAFConversationInfo.getConversationName(), sAFConversationInfo.getConversationTimeout(), sAFConversationInfo.getMaximumIdleTime(), sAFConversationInfo.getConversationOffer(), sAFConversationInfo.getCreateConversationMessageID(), sAFConversationInfo.getContext());
    }

    @Override
    public SAFManager.LocationInfo getLocationInfoForConversationOnSendingSide(String string) {
        SendingAgentImpl sendingAgentImpl = this.findLocalSendingAgent(string);
        if (sendingAgentImpl == null) {
            return null;
        }
        return new SAFManager.LocationInfo(sendingAgentImpl.getStoreName());
    }

    @Override
    public SAFManager.LocationInfo getLocationInfoForConversationOnReceivingSide(SAFConversationInfo sAFConversationInfo) {
        ReceivingAgentImpl receivingAgentImpl = this.findLocalReceivingAgent(sAFConversationInfo);
        if (receivingAgentImpl == null) {
            return null;
        }
        return new SAFManager.LocationInfo(receivingAgentImpl.getStoreName());
    }

    @Override
    public long getLastAcknowledged(SAFConversationInfo sAFConversationInfo) throws SAFException {
        SAFManagerImpl.checkShutdown();
        if (SAFDebug.SAFManager.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("getLastAcknowledged():" + sAFConversationInfo);
        }
        ReceivingAgentImpl receivingAgentImpl = this.findLocalReceivingAgent(sAFConversationInfo);
        ConversationReassembler conversationReassembler = receivingAgentImpl.getConversation(sAFConversationInfo);
        return conversationReassembler.getLastAcked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SAFConversationInfo getCachedConversationInfoOnReceivingSide(String string) throws SAFException {
        SAFManagerImpl.checkShutdown();
        HashMap hashMap = this.conversationInfosOnReceivingSide;
        synchronized (hashMap) {
            return (SAFConversationInfo)this.conversationInfosOnReceivingSide.get(string);
        }
    }

    @Override
    public SAFConversationInfo getConversationInfoOnReceivingSide(String string) throws SAFException {
        SAFManagerImpl.checkShutdown();
        if (SAFDebug.SAFManager.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("getConversationInfoOnReceivingSide():" + string);
        }
        return this.getCachedConversationInfoOnReceivingSide(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SAFConversationInfo getCachedConversationInfoOnSendingSide(String string) throws SAFException {
        SAFManagerImpl.checkShutdown();
        HashMap hashMap = this.conversationInfosOnSendingSide;
        synchronized (hashMap) {
            return (SAFConversationInfo)this.conversationInfosOnSendingSide.get(string);
        }
    }

    @Override
    public SAFConversationInfo getConversationInfoOnSendingSide(String string) throws SAFException {
        if (SAFDebug.SAFManager.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("getConversationInfoOnSendingSide():" + string);
        }
        return this.getCachedConversationInfoOnSendingSide(string);
    }

    @Override
    public boolean checkForConversationClosedOnReceivingSide(String string) throws SAFException {
        return this.getConversationInfoOnReceivingSide(string) == null;
    }

    @Override
    public boolean checkForConversationClosedOnSendingSide(String string) throws SAFException {
        return this.getConversationInfoOnSendingSide(string) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpConversationInfoOnSendingSide(String string) {
        block7: {
            try {
                SAFConversationInfo sAFConversationInfo = this.getConversationInfoOnSendingSide(string);
                if (sAFConversationInfo == null) break block7;
                HashMap hashMap = this.conversationInfosOnSendingSide;
                synchronized (hashMap) {
                    this.conversationInfosOnSendingSide.remove(string);
                    this.notifyRemoveConverationFromCache(true, "ConversationName", string, sAFConversationInfo);
                    if (sAFConversationInfo.isDynamic() && sAFConversationInfo.getDynamicConversationName() != null) {
                        this.conversationInfosOnSendingSide.remove(sAFConversationInfo.getDynamicConversationName());
                        this.notifyRemoveConverationFromCache(true, "DynamicName", sAFConversationInfo.getDynamicConversationName(), sAFConversationInfo);
                    }
                    if (sAFConversationInfo.getCreateConversationMessageID() != null) {
                        this.conversationInfosOnSendingSide.remove(sAFConversationInfo.getCreateConversationMessageID());
                        this.notifyRemoveConverationFromCache(true, "CreateConversationMessageD", sAFConversationInfo.getCreateConversationMessageID(), sAFConversationInfo);
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public void closeConversationOnReceivingSide(SAFConversationInfo sAFConversationInfo) throws SAFException {
        if (SAFDebug.SAFManager.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("closeConversationOnReceivingSide():" + sAFConversationInfo);
        }
        ReceivingAgentImpl receivingAgentImpl = this.findLocalReceivingAgent(sAFConversationInfo);
        receivingAgentImpl.removeConversation(sAFConversationInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeRAConversation(SAFConversationInfo sAFConversationInfo) {
        HashMap hashMap = this.conversationInfosOnReceivingSide;
        synchronized (hashMap) {
            this.conversationInfosOnReceivingSide.remove(sAFConversationInfo.getConversationName());
            this.notifyRemoveConverationFromCache(false, "ConversationName", sAFConversationInfo.getConversationName(), sAFConversationInfo);
            if (sAFConversationInfo.getCreateConversationMessageID() != null) {
                this.conversationInfosOnReceivingSide.remove(sAFConversationInfo.getCreateConversationMessageID());
                this.notifyRemoveConverationFromCache(false, "CreateConversationMessageID", sAFConversationInfo.getCreateConversationMessageID(), sAFConversationInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConversationInfoOnReceivingSide(SAFConversationInfo sAFConversationInfo) {
        HashMap hashMap = this.conversationInfosOnReceivingSide;
        synchronized (hashMap) {
            this.conversationInfosOnReceivingSide.put(sAFConversationInfo.getConversationName(), sAFConversationInfo);
            this.notifyAddConverationToCache(false, "ConversationName", sAFConversationInfo.getConversationName(), sAFConversationInfo);
            if (sAFConversationInfo.getCreateConversationMessageID() != null) {
                this.conversationInfosOnReceivingSide.put(sAFConversationInfo.getCreateConversationMessageID(), sAFConversationInfo);
                this.notifyAddConverationToCache(false, "CreateConversationMessageID", sAFConversationInfo.getCreateConversationMessageID(), sAFConversationInfo);
            }
        }
    }

    @Override
    public void acknowledge(String string, long l, long l2) throws SAFException {
        SAFManagerImpl.checkShutdown();
        SendingAgentImpl sendingAgentImpl = this.getSendingAgent(string);
        if (SAFDebug.SAFManager.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("acknowledge(): agent =  " + sendingAgentImpl + " conversation = " + string + " sequence number low = " + l + " sequence number high = " + l2);
        }
        sendingAgentImpl.acknowledge(string, l, l2);
    }

    @Override
    public void handleAsyncFault(String string, String string2, Exception exception) throws SAFException {
        SAFManagerImpl.checkShutdown();
        SendingAgentImpl sendingAgentImpl = this.getSendingAgent(string);
        if (SAFDebug.SAFManager.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("handleFault(): agent =  " + sendingAgentImpl + " conversation = " + string + " message ID  = " + string2 + " Exception = " + exception.getMessage());
        }
        sendingAgentImpl.handleAsyncFault(string, string2, exception);
    }

    @Override
    public void createConversationSucceeded(SAFConversationHandle sAFConversationHandle) throws SAFException {
        SAFManagerImpl.checkShutdown();
        SendingAgentImpl sendingAgentImpl = sAFConversationHandle.getCreateConversationMessageID() != null ? this.getSendingAgent(sAFConversationHandle.getCreateConversationMessageID()) : this.getSendingAgent(sAFConversationHandle.getConversationName());
        if (SAFDebug.SAFManager.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("onCreateSequenceSucceed(): found agent: " + sendingAgentImpl + " for conversation " + sAFConversationHandle.getConversationName() + " and createMsgID " + sAFConversationHandle.getCreateConversationMessageID());
        }
        sendingAgentImpl.onCreateConversationSucceed(sAFConversationHandle);
    }

    @Override
    public void storeConversationContextOnReceivingSide(String string, Externalizable externalizable) throws SAFException {
        SAFManagerImpl.checkShutdown();
        SAFConversationInfo sAFConversationInfo = this.getCachedConversationInfoOnReceivingSide(string);
        if (sAFConversationInfo == null) {
            throw new SAFException("Unknown conversation: " + string);
        }
        sAFConversationInfo.setContext(externalizable);
        ReceivingAgentImpl receivingAgentImpl = this.getReceivingAgent(sAFConversationInfo);
        if (SAFDebug.SAFManager.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("storeConversationContextOnReceivingSide(): found agent: " + receivingAgentImpl + " for conversation " + string);
        }
        receivingAgentImpl.storeConversationInfo(sAFConversationInfo);
    }

    @Override
    public void storeConversationContextOnSendingSide(String string, Externalizable externalizable) throws SAFException {
        SAFConversationInfo sAFConversationInfo;
        SAFManagerImpl.checkShutdown();
        SendingAgentImpl sendingAgentImpl = this.getSendingAgent(string);
        if (SAFDebug.SAFManager.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("storeConversationContextOnSendingSide(): found agent: " + sendingAgentImpl + " for conversation " + string);
        }
        if ((sAFConversationInfo = this.getCachedConversationInfoOnSendingSide(string)) == null) {
            throw new SAFException("Unknown conversation: " + string);
        }
        sAFConversationInfo.setContext(externalizable);
        sendingAgentImpl.storeConversationInfo(sAFConversationInfo);
    }

    @Override
    public List<Long> getAllSequenceNumberRangesOnReceivingSide(String string) throws SAFException {
        SAFConversationInfo sAFConversationInfo = this.getCachedConversationInfoOnReceivingSide(string);
        if (sAFConversationInfo == null) {
            throw new SAFException("Unknown conversation: " + string);
        }
        ReceivingAgentImpl receivingAgentImpl = this.getReceivingAgent(sAFConversationInfo);
        if (SAFDebug.SAFManager.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("getAllSequenceNumberRangesOnReceivingSide(): found agent: " + receivingAgentImpl + " for conversation " + string);
        }
        ConversationReassembler conversationReassembler = receivingAgentImpl.getConversation(sAFConversationInfo);
        return conversationReassembler.getAllSequenceNumberRanges();
    }

    @Override
    public long getLastAssignedSequenceValueOnSendingSide(String string) throws SAFException {
        SAFManagerImpl.checkShutdown();
        SendingAgentImpl sendingAgentImpl = this.getSendingAgent(string);
        if (SAFDebug.SAFManager.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("getLastAssignedSequenceValueOnSendingSide(): found agent: " + sendingAgentImpl + " for conversation " + string);
        }
        ConversationAssembler conversationAssembler = sendingAgentImpl.getConversation(string);
        return conversationAssembler.getLastAssignedSequenceValue();
    }

    @Override
    public List<Long> getAllSequenceNumberRangesOnSendingSide(String string) throws SAFException {
        SAFManagerImpl.checkShutdown();
        SendingAgentImpl sendingAgentImpl = this.getSendingAgent(string);
        if (SAFDebug.SAFManager.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("getAllSequenceNumberRangesOnSendingSide(): found agent: " + sendingAgentImpl + " for conversation " + string);
        }
        ConversationAssembler conversationAssembler = sendingAgentImpl.getConversation(string);
        return conversationAssembler.getAllSequenceNumberRanges();
    }

    @Override
    public boolean hasSentLastMessageOnSendingSide(String string) throws SAFException {
        SAFManagerImpl.checkShutdown();
        SendingAgentImpl sendingAgentImpl = this.getSendingAgent(string);
        if (SAFDebug.SAFManager.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("hasSentLastMessageOnSendingSide(): found agent: " + sendingAgentImpl + " for conversation " + string);
        }
        ConversationAssembler conversationAssembler = sendingAgentImpl.getConversation(string);
        return conversationAssembler.hasSeenLastMsg();
    }

    @Override
    public void setSentLastMessageOnSendingSide(String string, long l) throws SAFException {
        SAFManagerImpl.checkShutdown();
        SendingAgentImpl sendingAgentImpl = this.getSendingAgent(string);
        if (SAFDebug.SAFManager.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("setSentLastMessageOnSendingSide(): found agent: " + sendingAgentImpl + " for conversation " + string);
        }
        ConversationAssembler conversationAssembler = sendingAgentImpl.getConversation(string);
        conversationAssembler.setSeenLastMsg(true);
        conversationAssembler.setLastMsgSequenceNumber(l);
        conversationAssembler.checkCompleted();
    }

    @Override
    public boolean hasReceivedLastMessageOnReceivingSide(String string) throws SAFException {
        SAFConversationInfo sAFConversationInfo = this.getCachedConversationInfoOnReceivingSide(string);
        if (sAFConversationInfo == null) {
            throw new SAFException("Unknown conversation: " + string);
        }
        ReceivingAgentImpl receivingAgentImpl = this.getReceivingAgent(sAFConversationInfo);
        if (SAFDebug.SAFManager.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("hasReceivedLastMessageOnReceivingSide(): found agent: " + receivingAgentImpl + " for conversation " + string);
        }
        ConversationReassembler conversationReassembler = receivingAgentImpl.getConversation(sAFConversationInfo);
        return conversationReassembler.hasSeenLastMsg();
    }

    @Override
    public long getLastMessageSequenceNumberOnReceivingSide(String string) throws SAFException {
        SAFConversationInfo sAFConversationInfo = this.getCachedConversationInfoOnReceivingSide(string);
        if (sAFConversationInfo == null) {
            throw new SAFException("Unknown conversation: " + string);
        }
        ReceivingAgentImpl receivingAgentImpl = this.getReceivingAgent(sAFConversationInfo);
        if (SAFDebug.SAFManager.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("getLastMessageSequenceNumberOnReceivingSide(): found agent: " + receivingAgentImpl + " for conversation " + string);
        }
        ConversationReassembler conversationReassembler = receivingAgentImpl.getConversation(sAFConversationInfo);
        return conversationReassembler.getLastMsgSequenceNumber();
    }

    @Override
    public long getLastMessageSequenceNumberOnSendingSide(String string) throws SAFException {
        SAFManagerImpl.checkShutdown();
        SendingAgentImpl sendingAgentImpl = this.getSendingAgent(string);
        if (SAFDebug.SAFManager.isDebugEnabled()) {
            SAFDebug.SAFManager.debug("getLastMessageSequenceNumberOnSendingSide(): found agent: " + sendingAgentImpl + " for conversation " + string);
        }
        ConversationAssembler conversationAssembler = sendingAgentImpl.getConversation(string);
        return conversationAssembler.getLastMsgSequenceNumber();
    }

    @Override
    public void addConversationLifecycleListener(SAFManager.ConversationLifecycleListener conversationLifecycleListener) {
        this.conversationLifecycleListeners.add(conversationLifecycleListener);
    }

    @Override
    public void removeConversationLifecycleListener(SAFManager.ConversationLifecycleListener conversationLifecycleListener) {
        this.conversationLifecycleListeners.remove(conversationLifecycleListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAddConverationToCache(boolean bl, String string, String string2, SAFConversationInfo sAFConversationInfo) {
        int n;
        SAFManager.ConversationLifecycleListener[] conversationLifecycleListenerArray;
        if (bl) {
            conversationLifecycleListenerArray = this.conversationInfosOnSendingSide;
            synchronized (this.conversationInfosOnSendingSide) {
                n = this.conversationInfosOnSendingSide.size();
                // ** MonitorExit[var6_5] (shouldn't be in output)
            }
        }
        conversationLifecycleListenerArray = this.conversationInfosOnReceivingSide;
        synchronized (conversationLifecycleListenerArray) {
            n = this.conversationInfosOnReceivingSide.size();
        }
        {
            conversationLifecycleListenerArray = this.conversationLifecycleListeners.toArray(new SAFManager.ConversationLifecycleListener[0]);
            for (int i = 0; i < conversationLifecycleListenerArray.length; ++i) {
                conversationLifecycleListenerArray[i].addToCache(bl, string, string2, sAFConversationInfo, n);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyRemoveConverationFromCache(boolean bl, String string, String string2, SAFConversationInfo sAFConversationInfo) {
        int n;
        SAFManager.ConversationLifecycleListener[] conversationLifecycleListenerArray;
        if (bl) {
            conversationLifecycleListenerArray = this.conversationInfosOnSendingSide;
            synchronized (this.conversationInfosOnSendingSide) {
                n = this.conversationInfosOnSendingSide.size();
                // ** MonitorExit[var6_5] (shouldn't be in output)
            }
        }
        conversationLifecycleListenerArray = this.conversationInfosOnReceivingSide;
        synchronized (conversationLifecycleListenerArray) {
            n = this.conversationInfosOnReceivingSide.size();
        }
        {
            conversationLifecycleListenerArray = this.conversationLifecycleListeners.toArray(new SAFManager.ConversationLifecycleListener[0]);
            for (int i = 0; i < conversationLifecycleListenerArray.length; ++i) {
                conversationLifecycleListenerArray[i].removeFromCache(bl, string, string2, sAFConversationInfo, n);
            }
            return;
        }
    }

    void notifyPreConversationClose(boolean bl, boolean bl2, SAFConversationInfo sAFConversationInfo) {
        SAFManager.ConversationLifecycleListener[] conversationLifecycleListenerArray = this.conversationLifecycleListeners.toArray(new SAFManager.ConversationLifecycleListener[0]);
        for (int i = 0; i < conversationLifecycleListenerArray.length; ++i) {
            conversationLifecycleListenerArray[i].preClose(bl, bl2, sAFConversationInfo);
        }
    }

    void notifyAckConversation(SAFConversationInfo sAFConversationInfo, long l, long l2) {
        SAFManager.ConversationLifecycleListener[] conversationLifecycleListenerArray = this.conversationLifecycleListeners.toArray(new SAFManager.ConversationLifecycleListener[0]);
        for (int i = 0; i < conversationLifecycleListenerArray.length; ++i) {
            conversationLifecycleListenerArray[i].ack(sAFConversationInfo, l, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getConversationNamesOnSendingSide() {
        HashMap hashMap = this.conversationInfosOnSendingSide;
        synchronized (hashMap) {
            return new HashSet(this.conversationInfosOnSendingSide.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getConversationNamesOnReceivingSide() {
        HashMap hashMap = this.conversationInfosOnReceivingSide;
        synchronized (hashMap) {
            return new HashSet(this.conversationInfosOnReceivingSide.keySet());
        }
    }

    private static void checkShutdown() throws SAFException {
        if (SAFServerService.getService() == null) {
            throw new SAFServiceNotAvailException("Reliable Messaging cannot be invoked from a java client");
        }
        try {
            SAFServerService.getService().checkShutdown();
        }
        catch (ServiceFailureException serviceFailureException) {
            throw new SAFServiceNotAvailException("SAF service is shutting down");
        }
    }

    public void dump(SAFDiagnosticImageSource sAFDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        sAFDiagnosticImageSource.checkTimeout();
        xMLStreamWriter.writeStartElement("SAF");
        HealthState healthState = SAFService.getSAFService().getRuntimeMBean().getHealthState();
        SAFDiagnosticImageSource.dumpHealthStateElement(xMLStreamWriter, healthState);
        xMLStreamWriter.writeStartElement("EndpointManagers");
        Object[] objectArray = this.endpointManagers.values().toArray();
        xMLStreamWriter.writeAttribute("count", String.valueOf(objectArray.length));
        for (int i = 0; i < objectArray.length; ++i) {
            xMLStreamWriter.writeStartElement("EndpointManager");
            xMLStreamWriter.writeCharacters(objectArray[i].toString());
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("Transports");
        Object[] objectArray2 = this.transports.values().toArray();
        xMLStreamWriter.writeAttribute("count", String.valueOf(objectArray2.length));
        for (int i = 0; i < objectArray2.length; ++i) {
            SAFTransport sAFTransport = (SAFTransport)objectArray2[i];
            xMLStreamWriter.writeStartElement("Transport");
            xMLStreamWriter.writeAttribute("type", String.valueOf(sAFTransport.getType()));
            xMLStreamWriter.writeAttribute("isGapsAllowed", String.valueOf(sAFTransport.isGapsAllowed()));
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("SendingAgents");
        Object[] objectArray3 = this.localSendingAgents.toArray();
        xMLStreamWriter.writeAttribute("count", String.valueOf(objectArray3.length));
        for (int i = 0; i < objectArray3.length; ++i) {
            SendingAgentImpl sendingAgentImpl = (SendingAgentImpl)objectArray3[i];
            sendingAgentImpl.dump(sAFDiagnosticImageSource, xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("ReceivingAgents");
        Object[] objectArray4 = this.localReceivingAgents.toArray();
        xMLStreamWriter.writeAttribute("count", String.valueOf(objectArray4.length));
        for (int i = 0; i < objectArray4.length; ++i) {
            ReceivingAgentImpl receivingAgentImpl = (ReceivingAgentImpl)objectArray4[i];
            receivingAgentImpl.dump(sAFDiagnosticImageSource, xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }
}

