/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.internal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.server.SequenceData;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.common.SAFConversationInfoImpl;

public class SAFSequenceData
extends SequenceData {
    static final long serialVersionUID = -2611753600731762875L;
    private static final int EXTVERSION1 = 1;
    private static final int VERSION_MASK = 255;
    private static final int _HASINFO = 256;
    private static final int _HASLASTMSGSEQUENCENUMBER = 512;
    private SAFConversationInfo info;
    private long lastMsgSequenceNumber = Long.MAX_VALUE;

    public SAFSequenceData(SAFConversationInfo sAFConversationInfo) {
        this.info = sAFConversationInfo;
        this.setUnitOfOrder(sAFConversationInfo.getConversationName());
    }

    public SAFSequenceData() {
    }

    public SAFConversationInfo getConversationInfo() {
        return this.info;
    }

    public void setConversationInfo(SAFConversationInfo sAFConversationInfo) {
        this.info = sAFConversationInfo;
    }

    public synchronized long getLastMsgSequenceNumber() {
        return this.lastMsgSequenceNumber;
    }

    public synchronized void setLastMsgSequenceNumber(long l) {
        this.lastMsgSequenceNumber = l;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SAFSequenceData)) {
            return false;
        }
        SequenceData sequenceData = (SequenceData)object;
        if (this.info != null && !this.info.equals(((SAFSequenceData)object).getConversationInfo())) {
            return false;
        }
        if (((SAFSequenceData)object).getConversationInfo() != null && !((SAFSequenceData)object).getConversationInfo().equals(this.info)) {
            return false;
        }
        return this.lastMsgSequenceNumber == ((SAFSequenceData)object).getLastMsgSequenceNumber();
    }

    public int hashCode() {
        int n = super.hashCode();
        if (this.info != null) {
            n |= this.info.hashCode();
        }
        if (this.lastMsgSequenceNumber != Long.MAX_VALUE) {
            n = (int)((long)n | this.lastMsgSequenceNumber);
        }
        return n;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        super.writeExternal(objectOutput);
        if (this.info != null) {
            n |= 0x100;
        }
        if (this.lastMsgSequenceNumber != Long.MAX_VALUE) {
            n |= 0x200;
        }
        objectOutput.writeInt(n);
        if (this.info != null) {
            this.info.writeExternal(objectOutput);
        }
        if (this.lastMsgSequenceNumber != 0L) {
            objectOutput.writeLong(this.lastMsgSequenceNumber);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        if ((n & 0x100) != 0) {
            this.info = new SAFConversationInfoImpl();
            this.info.readExternal(objectInput);
        }
        if ((n & 0x200) != 0) {
            this.lastMsgSequenceNumber = objectInput.readLong();
        }
    }
}

