/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.saf.internal;

import java.util.HashMap;
import java.util.Iterator;
import weblogic.diagnostics.image.ImageManager;
import weblogic.diagnostics.image.ImageSource;
import weblogic.diagnostics.image.ImageSourceNotFoundException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.SAFAgentMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.utils.GenericManagedService;
import weblogic.management.utils.GenericServiceManager;
import weblogic.messaging.saf.SAFEndpointManager;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.SAFLogger;
import weblogic.messaging.saf.SAFTransport;
import weblogic.messaging.saf.internal.SAFAgentAdmin;
import weblogic.messaging.saf.internal.SAFDiagnosticImageSource;
import weblogic.messaging.saf.internal.SAFManagerImpl;
import weblogic.messaging.saf.internal.SAFServiceAdmin;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;

public final class SAFServerService
extends AbstractServerService {
    private static final int STATE_INITIALIZING = 0;
    private static final int STATE_SUSPENDING = 1;
    private static final int STATE_SUSPENDED = 2;
    private static final int STATE_STARTED = 4;
    private static final int STATE_SHUTTING_DOWN = 8;
    private static final int STATE_CLOSED = 16;
    private int state = 0;
    private static SAFServerService singleton;
    private SAFServiceAdmin safAdmin;
    private SAFManagerImpl safManager;
    private boolean registered;
    private GenericManagedService safServerService;
    private HashMap agents = new HashMap();
    static final String IMAGE_NAME = "SAF";
    private final ImageSource IMAGE_SOURCE = new SAFDiagnosticImageSource();

    public SAFServerService() {
        singleton = this;
    }

    public static SAFServerService getService() {
        return singleton;
    }

    public void stop() throws ServiceFailureException {
        this.suspend(false);
        this.shutdown();
        this.unregisterDiagnosticImageSource();
    }

    public void halt() throws ServiceFailureException {
        this.suspend(true);
        this.shutdown();
        this.unregisterDiagnosticImageSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws ServiceFailureException {
        Object object;
        this.safManager = (SAFManagerImpl)SAFManagerImpl.getManager();
        if (!this.registered) {
            object = GenericServiceManager.getManager();
            this.safServerService = object.register(SAFAgentMBean.class, SAFServiceAdmin.class, true);
            this.registered = true;
        }
        this.safServerService.start();
        this.registerDiagnosticImageSource();
        object = this;
        synchronized (object) {
            this.state = 2;
        }
        SAFLogger.logSAFInitialized();
        object = this;
        synchronized (object) {
            if (this.state == 4) {
                return;
            }
            this.processAgentServerLifeCycleEvent(4, true);
            this.state = 4;
        }
        this.safManager.registerEndpointManager(2, this.getWsrmSAFEndpointManager());
        this.safManager.registerEndpointManager(3, this.getWsrmJaxwsSAFEndpointManager());
        this.safManager.registerTransport(this.getWsrmTransport());
        this.safManager.registerTransport(this.getWsrmJaxwsTransport());
        SAFLogger.logSAFStarted();
    }

    private SAFEndpointManager getWsrmSAFEndpointManager() {
        try {
            Class<?> clazz = Class.forName("weblogic.wsee.reliability.WsrmEndpointManager");
            return (SAFEndpointManager)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    private SAFEndpointManager getWsrmJaxwsSAFEndpointManager() {
        try {
            Class<?> clazz = Class.forName("weblogic.wsee.reliability2.saf.WsrmSAFEndpointManager");
            return (SAFEndpointManager)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    private SAFTransport getWsrmTransport() {
        try {
            Class<?> clazz = Class.forName("weblogic.wsee.reliability.WsrmSAFTransport");
            return (SAFTransport)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    private SAFTransport getWsrmJaxwsTransport() {
        try {
            Class<?> clazz = Class.forName("weblogic.wsee.reliability2.saf.WsrmSAFTransport");
            return (SAFTransport)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspend(boolean bl) throws ServiceFailureException {
        SAFServerService sAFServerService = this;
        synchronized (sAFServerService) {
            try {
                this.processAgentServerLifeCycleEvent(1, bl);
                Object var4_3 = null;
                this.state = 2;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.state = 2;
                throw throwable;
            }
        }
        SAFLogger.logSAFSuspended();
    }

    private boolean isShutdown() {
        return this.state == 16 || this.state == 8;
    }

    void checkShutdown() throws ServiceFailureException {
        if (this.isShutdown()) {
            throw new ServiceFailureException("Store-and-forward Service is shutdown.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() throws ServiceFailureException {
        SAFServerService sAFServerService;
        SAFServerService sAFServerService2 = this;
        synchronized (sAFServerService2) {
            if (this.state == 16) {
                return;
            }
            this.state = 8;
        }
        this.safServerService.stop();
        this.registered = false;
        try {
            this.processAgentServerLifeCycleEvent(8, true);
            Object var4_3 = null;
            sAFServerService = this;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            SAFServerService sAFServerService3 = this;
            synchronized (sAFServerService3) {
                this.state = 16;
            }
            SAFLogger.logSAFShutdown();
            throw throwable;
        }
        synchronized (sAFServerService) {
            this.state = 16;
        }
        SAFLogger.logSAFShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAgentServerLifeCycleEvent(int n, boolean bl) throws ServiceFailureException {
        Iterator iterator;
        Object object = this;
        synchronized (object) {
            iterator = ((HashMap)this.agents.clone()).values().iterator();
            if (n == 8) {
                this.agents.clear();
            }
        }
        while (iterator.hasNext()) {
            object = (SAFAgentAdmin)iterator.next();
            switch (n) {
                case 4: {
                    try {
                        ((SAFAgentAdmin)object).resume();
                        break;
                    }
                    catch (SAFException sAFException) {
                        SAFLogger.logErrorResumeAgent((String)object.getName(), (Exception)sAFException);
                        throw new ServiceFailureException("Failed to start SAF agent '" + object.getName() + "', due to " + sAFException.getMessage());
                    }
                }
                case 1: {
                    ((SAFAgentAdmin)object).suspend(bl);
                    break;
                }
                case 8: {
                    ((SAFAgentAdmin)object).close();
                }
            }
        }
    }

    public void registerDiagnosticImageSource() {
        ImageManager imageManager = ImageManager.getInstance();
        imageManager.registerImageSource(IMAGE_NAME, this.IMAGE_SOURCE);
    }

    private void unregisterDiagnosticImageSource() {
        ImageManager imageManager = ImageManager.getInstance();
        try {
            imageManager.unregisterImageSource(IMAGE_NAME);
        }
        catch (ImageSourceNotFoundException imageSourceNotFoundException) {
            // empty catch block
        }
    }

    public boolean isTargetsChangeAllowed(SAFAgentMBean sAFAgentMBean) {
        TargetMBean[] targetMBeanArray = sAFAgentMBean.getTargets();
        if (targetMBeanArray == null || targetMBeanArray.length == 0 || !(targetMBeanArray[0] instanceof MigratableTargetMBean)) {
            return true;
        }
        SAFAgentAdmin sAFAgentAdmin = this.getAgent(sAFAgentMBean.getName());
        if (sAFAgentAdmin != null && sAFAgentAdmin.isActiveForWSRM()) {
            return false;
        }
        if (sAFAgentAdmin != null && sAFAgentAdmin.getMBean() != null) {
            TargetMBean[] targetMBeanArray2 = sAFAgentAdmin.getMBean().getTargets();
            if (targetMBeanArray2 == null || targetMBeanArray2.length == 0) {
                return true;
            }
            for (int i = 0; i < targetMBeanArray2.length; ++i) {
                if (!(targetMBeanArray2[i] instanceof ServerMBean) && !(targetMBeanArray2[i] instanceof ClusterMBean) || !(targetMBeanArray[0] instanceof MigratableTargetMBean)) continue;
                return false;
            }
        }
        return true;
    }

    synchronized void addAgent(SAFAgentAdmin sAFAgentAdmin) {
        this.agents.put(sAFAgentAdmin.getName(), sAFAgentAdmin);
    }

    synchronized SAFAgentAdmin getAgent(String string) {
        return (SAFAgentAdmin)this.agents.get(string);
    }

    synchronized SAFAgentAdmin removeAgent(String string) {
        return (SAFAgentAdmin)this.agents.get(string);
    }
}

